{2/98:  slowed down using Clocks to make drawing dynamic}

{$N+,E+}
PROGRAM Spheres;

  USES
    Clocks,
    DOS,
    Drivers,
    ErrorHandler,
    GRAPH,
    GraphFix,
    MathLibrary,
    Primitives;

  CONST
    WaitPeriod  = 0.50;   {seconds}

  VAR
    a             :  matrix;
    clkDOS        :  Clock;
    ErrorCode     :  INTEGER;
    GraphicsDriver:  INTEGER;
    GraphicsMode  :  INTEGER;
    w             :  GraphicsWindow;

  PROCEDURE Cube;
  BEGIN
    SetColor (4);
    w.SetCoordType (cartesian);
    w.MoveTo3D ( 1, 1, 1);
    w.LineTo3D (-1, 1, 1);
    w.LineTo3D (-1,-1, 1);
    w.LineTo3D ( 1,-1, 1);
    w.LineTo3D ( 1, 1, 1);

    w.LineTo3D ( 1, 1,-1);
    w.LineTo3D (-1, 1,-1);
    w.LineTo3D (-1,-1,-1);
    w.LineTo3D ( 1,-1,-1);
    w.LineTo3D ( 1, 1,-1);

    w.MoveTo3D (-1, 1,-1);
    w.LineTo3D (-1, 1, 1);

    w.MoveTo3D (-1,-1, 1);
    w.LineTo3D (-1,-1,-1);

    w.MoveTo3D ( 1,-1,-1);
    w.LineTo3D ( 1,-1, 1)
  END {Cube};

  PROCEDURE Sphere;
  VAR
    i,j  :  INTEGER;
    phi  :  REAL;
    r    :  REAL;
    theta:  REAL;
  BEGIN
    SetColor (9);
    w.SetCoordType (spherical);
    r := 1.0;
    FOR j := 1 TO 3 DO BEGIN
      phi := Radians(45 * j {degrees} );
      w.MoveTo3D (r,0,phi);
      FOR i := 1 TO 50 DO BEGIN
        theta := Radians(7.20 * i {degrees});
        w.LineTo3D (r,theta,phi)
      END
    END;

    FOR i := 0 TO 18 DO BEGIN
      theta := Radians(20 * i {degrees});  {0..360}
      w.MoveTo3D (r,theta,0);
      FOR j := 1 TO 50 DO BEGIN
        phi := Radians(3.60 * j {degrees});
        w.LineTo3D (r,theta,phi)
      END
    END
  END {sphere};

BEGIN
  SetExitWait (TRUE);

  DecodeDriverMode ( GetEnv('DRIVER'),GetEnv('MODE'), GraphicsDriver, GraphicsMode);

  InitGraph (GraphicsDriver, GraphicsMode, '');
  ErrorCode := GraphResult;
  IF   ErrorCode <> grOK
  THEN BEGIN
    SetErrorMessage (1,'BGI Graphics Error:  ' + GraphErrorMsg(ErrorCode));
    SetErrorMessage (2,'Program terminated.');
    HALT
  END;

  w.init;

  w.ViewPort (0.00,0.33, 0.00,0.33);
  ViewTransformMatrix (spherical,Radians(30),Radians(45),12,
        10,10,30, a);
  w.SetTransform (a);
  clkDOS.Start(DOSClock);
  Cube;
  Sphere;
  REPEAT UNTIL clkDOS.Elapsed > WaitPeriod;

  w.ViewPort (0.33,0.67, 0.00,0.33);
  ViewTransformMatrix (spherical,Radians(45),Radians(45),12,
        10,10,30, a);
  w.SetTransform (a);
  clkDOS.Start(DOSClock);
  Cube;
  Sphere;
  REPEAT UNTIL clkDOS.Elapsed > WaitPeriod;

  w.ViewPort (0.67,1.00, 0.00,0.33);
  ViewTransformMatrix (spherical,Radians(60),Radians(45),12,
        10,10,30, a);
  w.SetTransform (a);
  clkDOS.Start(DOSClock);
  Cube;
  Sphere;
  REPEAT UNTIL clkDOS.Elapsed > WaitPeriod;

  w.ViewPort (0.00,0.33, 0.33,0.67);
  ViewTransformMatrix (spherical,Radians(30),Radians(60),12,
        10,10,30, a);
  w.SetTransform (a);
  clkDOS.Start(DOSClock);
  Cube;
  Sphere;
  REPEAT UNTIL clkDOS.Elapsed > WaitPeriod;

  w.ViewPort (0.33,0.67, 0.33,0.67);
  ViewTransformMatrix (spherical,Radians(60),Radians(60),12,
        10,10,30, a);
  w.SetTransform (a);
  clkDOS.Start(DOSClock);
  Cube;
  Sphere;
  REPEAT UNTIL clkDOS.Elapsed > WaitPeriod;

  w.ViewPort (0.67,1.00, 0.33,0.67);
  ViewTransformMatrix (spherical,Radians(30),Radians(90),12,
        10,10,30, a);
  w.SetTransform (a);
  clkDOS.Start(DOSClock);
  Cube;
  Sphere;
  REPEAT UNTIL clkDOS.Elapsed > WaitPeriod;

  w.init;
  w.SetClipping (FALSE);

  w.WorldCoordinatesRange (-1.25,1.25, -1.25,1.25);
  w.ViewPort (0.00,0.33, 0.67,1.00);
  w.SetProjectionType (orthoXY);
  clkDOS.Start(DOSClock);
  Cube;
  Sphere;
  REPEAT UNTIL clkDOS.Elapsed > WaitPeriod;

  w.WorldCoordinatesRange (-1.25,1.25, -1.25,1.25);
  w.ViewPort (0.33,0.67, 0.67,1.00);
  w.SetProjectionType (orthoXZ);
  clkDOS.Start(DOSClock);
  Cube;
  Sphere;
  REPEAT UNTIL clkDOS.Elapsed > WaitPeriod;

  w.WorldCoordinatesRange (-1.25,1.25, -1.25,1.25);
  w.ViewPort (0.67,1.00, 0.67,1.00);
  w.SetProjectionType (orthoYZ);
  clkDOS.Start(DOSClock);
  Cube;
  Sphere;
  REPEAT UNTIL clkDOS.Elapsed > WaitPeriod;

  READLN;
  CloseGraph;
  SetGraph (FALSE)

END {Spheres}.
