UNIT GraphFix;

  {(C) Copyright 1991.  Earl F. Glynn, Overland Park, KS.
   All Rights Reserved.  This program may be freely distributed only
   for non-commercial use.

   This UNIT provides many graphics routines similar to those in the
   Borland Graphics Interface but "fixes" all calls so the coordinate
   system is the normal "first quadrant" from mathematics.  Instead
   of having dimensions "X" and "Y," these routines have dimensions
   "I" and "J" to indicate they represent discrete points.  ("X" and
   "Y" in mathematics are usually real quantities, "I" and "J" are
   discrete integer quantities.)

   Note that instead of having "Y" range from 0 at the top to GetMaxY
   at the bottom, the "I" dimension ranges from 0 at the bottom to
   MaxJ (i.e., GetMaxY) at the top.  That is, instead of the usual
   screen definition coordinate system:

         0 Ŀ
      Y                  Most graphics screens are defined this way;
                         The Borland Graphics Interface (BGI) is.
   GetMaxY 
           0       GetMaxX
                X

   The "IJ" routines are defined with the following geometry:

      MaxJ Ŀ
                         "GraphFix" coordinates.
       J              
         0 
           0         MaxI
                I
   IBM's Presentation Manager also sets the (0,0) graphics origin to
   the lower left corner (instead of the upper left corner).}


{}

INTERFACE

  VAR
    GraphicsDriver:  INTEGER;
    GraphicsMode  :  INTEGER;

  CONST
    Transparent = -1;
                          {Borland-like routines}
  PROCEDURE BarIJ         (i1,i2, j1,j2:  INTEGER);
  PROCEDURE Bar3DIJ       (i1,i2, j1,j2:  INTEGER);
  PROCEDURE CircleIJ      (i,j: INTEGER; radius:  WORD);
  PROCEDURE FillEllipseIJ (i,j:  INTEGER; iRadius,jRadius:  WORD);
  PROCEDURE FloodFillIJ   (i,j:  INTEGER; Border:  WORD);
  PROCEDURE GetImageIJ    (i1,i2, j1,j2:  INTEGER; p:  Pointer);
  FUNCTION  GetPixelIJ    (i,j:  INTEGER):  WORD;
  FUNCTION  ImageSizeIJ   (i1,i2, j1,j2:  INTEGER):  WORD;
  PROCEDURE LineIJ        (i1,j1, i2,j2:  INTEGER);
  PROCEDURE OutTextIJ     (i,j:  INTEGER;  s:  STRING);
  PROCEDURE PutImageIJ    (i,j:  INTEGER; p:  Pointer; BitBlt:  WORD);
  PROCEDURE PutPixelIJ    (i,j,pixel:  INTEGER);

  PROCEDURE SetGraph (state:  BOOLEAN);

         {low-level routines for my graphics primitives UNIT}
  PROCEDURE LineToPixel   (i,j:  INTEGER);
  PROCEDURE MoveToPixel   (i,j:  INTEGER);
  PROCEDURE PointAtPixel  (i,j:  INTEGER);

         {miscellaneous}
  PROCEDURE CenteredTitle (s:  STRING;
                           font,size,color,jPosition:  WORD);
  PROCEDURE CenteredTitleAt (s:  STRING;
                             font,size,color,iPosition,jPosition:  WORD);

{}

IMPLEMENTATION

  USES
    CRT,
    GRAPH;

  VAR
    ExitSave :  POINTER;
    GraphOpen:  BOOLEAN;
    iSave    :  INTEGER;
    jSave    :  INTEGER;
    SaveAttr :  BYTE;
    SaveMode :  WORD;


  PROCEDURE BarIJ   (i1,i2,j1,j2:  INTEGER);
  BEGIN
    GRAPH.BAR (i1,GetMaxY-j1, i2,GetMaxY-j2)
  END {BarIJ};


  PROCEDURE Bar3DIJ (i1,i2,j1,j2:  INTEGER);
  BEGIN
    GRAPH.BAR3D (i1,GetMaxY-j1, i2,GetMaxY-j2, 0, FALSE)
  END {Bar3DIJ};


  PROCEDURE CircleIJ (i,j:  INTEGER; radius:  WORD);
  BEGIN
    GRAPH.Circle (i, GetMaxY-j, radius)
  END {CircleIJ};


  PROCEDURE FillEllipseIJ (i,j:  INTEGER; iRadius,jRadius:  WORD);
  BEGIN
    GRAPH.FillEllipse (i, GetMaxY-j, iRadius, jRadius)
  END {FillEllipseIJ};


  PROCEDURE FloodFillIJ(i,j:  INTEGER; Border:  WORD);
  BEGIN
    GRAPH.FloodFill (i, GetMaxY-j, Border)
  END {FloodFillIJ};


  PROCEDURE GetImageIJ (i1,i2,j1,j2:  INTEGER; p:  Pointer);
  BEGIN
      GRAPH.GetImage (i1,GetMaxY-j1,i2,GetMaxY-j2, p^)
  END {PutImageIJ};


  FUNCTION  GetPixelIJ (i,j:  INTEGER):  WORD;
  BEGIN
    GetPixelIJ := GRAPH.GetPixel (i, GetMaxY-j)
  END {GetPixelIJ};

  FUNCTION  ImageSizeIJ (i1,i2, j1,j2:  INTEGER):  WORD;
  BEGIN
    ImageSizeIJ := GRAPH.ImageSize(i1,GetMaxY-j1, i2,GetMaxY-j2)
  END {ImageSizeIJ};

  PROCEDURE LineIJ (i1,j1, i2,j2:  INTEGER);
  BEGIN
    GRAPH.Line (i1, GetMaxY-j1, i2,GetMaxY-j2)
  END {LineIJ};


  PROCEDURE OutTextIJ (i,j:  INTEGER;  s:  STRING);
    { (i,j) refers to lower-left of text.  BGI needs upper left.}
  BEGIN
    GRAPH.OutTextXY (i,GetMaxY-j-TextHeight(s), s)
  END {OutTextIJ};


  PROCEDURE PutImageIJ (i,j:  INTEGER; p:  Pointer; BitBlt:  WORD);
    TYPE
      WORDArray    = ARRAY[0..1] OF WORD;
      WORDArrayPtr = ^WordArray;
    VAR
      w:  WordArrayPtr;   {w^[0] is image "i" dimension}
  BEGIN                   {w^[1] is image "j" dimension}
    IF   p <> NIL
    THEN BEGIN
      w := p;
      GRAPH.PutImage (i,GetMaxY-j-w^[1], p^, BitBlt)
    END
  END {PutImageIJ};


  PROCEDURE PutPixelIJ (i,j,pixel:  INTEGER);
  BEGIN
    GRAPH.PutPixel (i,GetMaxY-j, pixel)
  END {PutPixelIJ};


{}

  PROCEDURE SetGraph (state:  BOOLEAN);
  BEGIN
    GraphOpen := state
  END {SetGraph};


{}

  PROCEDURE LineToPixel (i,j:  INTEGER);
  BEGIN
    LineIJ (iSave,jSave, i,j);
    iSave := i;
    jSave := j
  END {LineToPixel};


  PROCEDURE MoveToPixel (i,j:  INTEGER);
  BEGIN
    iSave := i;
    jSave := j
  END {MoveToPixel};


  PROCEDURE PointAtPixel (i,j:  INTEGER);
  BEGIN
    PutPixelIJ (i,j,GRAPH.GetColor);
    iSave := i;
    jSave := j
  END {PointAtPixel};


{}

    PROCEDURE CenteredTitle (s:  STRING;
                             font,size,color,jPosition:  WORD);
    BEGIN
      SetTextStyle (font, HorizDir, size);
      SetColor (color);
      OutTextIJ ((GetMaxX - TextWidth(s)) DIV 2,
                jPosition,
                s)
    END {CenteredTitle};

    PROCEDURE CenteredTitleAt (s:  STRING;
                               font,size,color,iPosition,jPosition:  WORD);
    BEGIN
      SetTextStyle (font, HorizDir, size);
      SetColor (color);
      OutTextIJ (iPosition - TextWidth(s) DIV 2,
                jPosition,
                s)
    END {CenteredTitleAt};
{}

  {$F+}
  PROCEDURE UnitExit;
  BEGIN
    ExitProc := ExitSave;
    IF   GraphOpen
    THEN CloseGraph;
    TextMode (SaveMode);     {Restore text mode/colors}
    TextAttr := SaveAttr;
    ClrScr
  END {UnitExit};
  {$F-}


{}

BEGIN
  ExitSave  := ExitProc;
  ExitProc  := @UnitExit;
  SaveAttr  := CRT.TextAttr;  {Save text mode/colors}
  SaveMode  := CRT.LastMode;
  GraphOpen := FALSE;
  iSave     := 0;
  jSave     := 0
END {GraphFix}.
