{Original Borland FONTS.PAS file modified to be self-initializing.
 Earl F. Glynn, OPKS, 7 January 1989. }

{ Copyright (c) 1985, 1989 by Borland International, Inc. }

unit Fonts;
{ Sample unit to accompany BGILINK.PAS. This unit links all the BGI graphics
  fonts into a single TPU file. This makes it easy to incorporate the font
  files directly into an .EXE file. See BGILINK.PAS for more information.
}
interface

PROCEDURE InitFonts;
procedure GothicFontProc;
procedure SansSerifFontProc;
procedure SmallFontProc;
procedure TriplexFontProc;

implementation
  USES Graph;

PROCEDURE Abort(Msg:  string);
BEGIN
  WRITELN ('Font ',Msg,':  Error',GraphErrorMsg(GraphResult));
  HALT (1)
END;

PROCEDURE InitFonts;
BEGIN
  { Register all the fonts }
  IF    RegisterBGIfont(@GothicFontProc) < 0
  THEN  Abort ('Gothic');
  IF    RegisterBGIfont(@SansSerifFontProc) < 0
  THEN  Abort ('SanSerif');
  IF    RegisterBGIfont(@SmallFontProc) < 0
  THEN  Abort ('Small');
  IF    RegisterBGIfont(@TriplexFontProc) < 0
  THEN  Abort ('Triplex');
END;


procedure GothicFontProc; external;
{$L GOTH.OBJ }

procedure SansSerifFontProc; external;
{$L SANS.OBJ }

procedure SmallFontProc; external;
{$L LITT.OBJ }

procedure TriplexFontProc; external;
{$L TRIP.OBJ }

BEGIN
  InitFonts
END.
