UNIT ErrorHandler;

  {(C) Copyright 1991.  Earl F. Glynn, Overland Park, KS.  CIS 73257,3527.
   All Rights Reserved.  This UNIT may be freely distributed only for
   non-commercial use.

   This unit intercepts run-time errors and prints the text instead
   of the ususal error code.


{  Interface  }

INTERFACE

  PROCEDURE SetErrorMessage (i:  WORD;  s:  STRING);
  PROCEDURE SetExitWait (b:  BOOLEAN);


{  Implementation  }

IMPLEMENTATION

  USES
    REXX;

  CONST
    MaxMessages = 3;

  VAR
    ExitSave:  POINTER;
    i       :  WORD;
    Messages:  ARRAY[1..MaxMessages] OF STRING[80];
    Wait    :  BOOLEAN;

{}

  PROCEDURE SetErrorMessage (i:  WORD;  s:  STRING);
  BEGIN
    IF   i IN [1..MaxMessages]
    THEN Messages[i] := s
  END {SetErrorMessage};


  PROCEDURE SetExitWait (b:  BOOLEAN);
  BEGIN
    wait := b
  END {SetExitWait};

{  Exit  }

  {$F+}
  PROCEDURE UnitExit;
  BEGIN
    ExitProc := ExitSave;

    FOR i := 1 TO MaxMessages DO BEGIN
      IF   Messages[i] <> ''
      THEN WRITELN (Messages[i]);
    END;

    IF   ErrorAddr <> NIL
    THEN BEGIN                    {See Turbo Pascal 6 "Programmer's Guide}
      WRITE ('Fatal Error ');     {pp. 246-247, 341-346}
      CASE ExitCode OF
              {DOS errors}
          1:  WRITELN (  '1:  Invalid function number');
          2:  WRITELN (  '2:  File not found');
          3:  WRITELN (  '3:  Path not found');
          4:  WRITELN (  '4:  Too many open files');
          5:  WRITELN (  '5:  File access denied');
          6:  WRITELN (  '6:  Invalid file handle');
         12:  WRITELN ( '12:  Invalid file access code');
         15:  WRITELN ( '15:  Invalid driver number');
         16:  WRITELN ( '16:  Cannot remove current directory');
         17:  WRITELN ( '17:  Cannot rename across drives');

              {I/O errors}
        100:  WRITELN ('100:  Disk read error');
        101:  WRITELN ('101:  Disk write error');
        102:  WRITELN ('102:  File not assigned');
        103:  WRITELN ('103:  File not open');
        104:  WRITELN ('104:  File not open for input');
        105:  WRITELN ('105:  File not open for output');
        106:  WRITELN ('106:  Invalid numeric format');

              {Critical errors}
        150:  WRITELN ('150:  Disk is write-protected');
        151:  WRITELN ('151:  Unknown unit');
        152:  WRITELN ('152:  Drive not ready');
        153:  WRITELN ('153:  Unknown command');
        154:  WRITELN ('154:  CRC error in data');
        155:  WRITELN ('155:  Bad drive request structure length');
        156:  WRITELN ('156:  Disk seek error');
        157:  WRITELN ('157:  Unknown media type');
        158:  WRITELN ('158:  Sector not found');
        159:  WRITELN ('159:  Printer out of paper');
        160:  WRITELN ('160:  Device write fault');
        161:  WRITELN ('161:  Device read fault');
        162:  WRITELN ('162:  Hardware failure');

              {Fatal errors}
        200:  WRITELN ('200:  Division by zero');
        201:  WRITELN ('201:  Range check error');
        202:  WRITELN ('202:  Stack overflow error');
        203:  WRITELN ('203:  Heap overflow error');
        204:  WRITELN ('204:  Invalid pointer operation');
        205:  WRITELN ('205:  Floating point overflow');
        206:  WRITELN ('206:  Floating point underflow');
        207:  WRITELN ('207:  Invalid floating point operation');
        208:  WRITELN ('208:  Overlay manager not installed');
        209:  WRITELN ('209:  Overlay file read error');
        210:  WRITELN ('210:  Object not initialized');
        211:  WRITELN ('211:  Call to abstract method');
        212:  WRITELN ('212:  Stream registration error');
        213:  WRITELN ('213:  Collection index out of range');
        214:  WRITELN ('214:  Collection overflow error');
        ELSE  WRITELN ('-- Code ',ExitCode)
      END;
      WRITELN ('Error Address:  ',W2X(SEG(ErrorAddr^)),':',
                                  W2X(OFS(ErrorAddr^)));
      ErrorAddr := NIL;

      IF   wait
      THEN BEGIN
        WRITELN;
        WRITELN ('Press <enter> to continue ...');
        READLN
      END

    END
  END {UnitExit};
  {$F-}

{  Initialization  }

BEGIN
  ExitSave := ExitProc;
  ExitProc := @UnitExit;

  FOR i := 1 TO MaxMessages DO
    Messages[i] := '';

  wait := FALSE
END {ErrorHandler}.
