{Earl G. Glynn, OPKS, 7 January 1989}
{Updated 10 August 1992}


UNIT Drivers;

INTERFACE

  TYPE
    ColorValue     = RECORD
                       Rvalue, Gvalue, Bvalue:  BYTE
                     END;
    VGAPaletteType = ARRAY[0..255] OF ColorValue;

  PROCEDURE VGASetAllPalette(VAR P : VGAPaletteType);

  PROCEDURE DecodeDriverMode (DriverType,Resolution:  STRING;
                              VAR Driver,Mode:  INTEGER);

  PROCEDURE InitDrivers;

  PROCEDURE CGADriverProc;
  PROCEDURE EGAVGADriverProc;
  PROCEDURE SVGADriverProc;
  PROCEDURE S3DriverProc;


IMPLEMENTATION
  USES GRAPH, DOS;

  VAR
    SVGAdriver:  INTEGER;
    S3driver  :  INTEGER;


  PROCEDURE VGASetAllPalette(VAR P : VGAPaletteType);
    VAR
      Regs : Registers;
  BEGIN
    WITH Regs do
    BEGIN
      AX := $1012;
      BX := 0;
      CX := 256;
      ES := Seg(P);
      DX := Ofs(P);
    END;
    INTR ($10, Regs);
  END {VGASetAllPalette};


  PROCEDURE Abort(Msg : string);
  BEGIN
    Writeln('Driver ',Msg, ':  Error (',GraphResult,') ',
       GraphErrorMsg(GraphResult));
    Halt (1)
  END {Abort};


  PROCEDURE InitDrivers;     {Register all the drivers}
  BEGIN
    IF   RegisterBGIdriver(@CGADriverProc)    < 0
    THEN Abort('CGA');

    IF   RegisterBGIdriver(@EGAVGADriverProc) < 0
    THEN Abort('EGA/VGA');

    S3driver := InstallUserDriver('SVGAS3',NIL);
    IF   GraphResult <> grOK
    THEN BEGIN
      WRITELN ('Error ',GraphResult,' Installing S3 Driver');
      HALT (2);
    END;
    IF   RegisterBGIdriver(@S3DriverProc) < 0
    THEN Abort('S3');

    SVGAdriver := InstallUserDriver('SVGA256',NIL);
    IF   GraphResult <> grOK
    THEN BEGIN
      WRITELN ('Error ',GraphResult,' Installing SVGA Driver');
      HALT (2);
    END;
    IF   RegisterBGIdriver(@SVGADriverProc)   < 0
    THEN Abort('SVGA');

  END {InitDrivers};


  PROCEDURE DecodeDriverMode (DriverType,Resolution:  STRING;
                              VAR Driver,Mode:  INTEGER);
    VAR i:  BYTE;
  BEGIN

    DetectGraph(Driver, Mode);    {set defaults}

    IF   (LENGTH(DriverType) = 0) OR (LENGTH(Resolution) = 0)
    THEN EXIT;

    FOR i := 1 TO LENGTH(DriverType) DO
      DriverType[i] := UpCase( DriverType[i] );
    FOR i := 1 TO LENGTH(Resolution) DO
      Resolution[i] := UpCase( Resolution[i] );

    IF   DriverType = 'CGA'
    THEN BEGIN
      Driver := CGA;
      IF   (Resolution = '320X200A') OR   {default}
           (Resolution = '320x200')
      THEN Mode := CGAC0
      ELSE
        IF   Resolution = '320X200B'
        THEN Mode := CGAC1
        ELSE
          IF   Resolution = '320X200C'
          THEN Mode := CGAC2
          ELSE
            IF   Resolution = '320X200D'
            THEN Mode := CGAC3
            ELSE
              IF   Resolution = '640X200'
              THEN Mode := CGAHi
              ELSE Mode := CGAC0
    END
    ELSE

      IF   DriverType = 'EGA'
      THEN BEGIN
        Driver := EGA;
        IF   Resolution = '640X200'
        THEN Mode := EGALo
        ELSE Mode := EGAHi        {640X350 and default}
      END

      ELSE
        IF   DriverType = 'VGA'
        THEN BEGIN
          Driver := VGA;
          IF   Resolution = '640X200'
          THEN Mode := VGALo
          ELSE
            IF   Resolution = '640X350'
            THEN Mode := VGAMed
            ELSE Mode := VGAHi  {640X480 and default}
        END

        ELSE
          IF   DriverType = 'S3'
          THEN BEGIN
            Driver := S3driver;
            IF   Resolution = '640X480X256'
            THEN Mode := 0
            ELSE
              IF   Resolution = '800X600X256'
              THEN Mode := 1
              ELSE
                IF   Resolution = '1024X768X256'
                THEN Mode := 2
                ELSE
                  IF   Resolution = '800X600X16'
                  THEN Mode := 3
                  ELSE
                    IF   Resolution = '1024X768X16'
                    THEN Mode := 4
                    ELSE Mode := 0     {640X480x256 is default}
          END

          ELSE
            IF   DriverType = 'SUPERVGA'
            THEN BEGIN
              Driver := SVGAdriver;
              IF   Resolution = '640X480X256'
              THEN Mode := 2
              ELSE
                IF   Resolution = '800X600X256'
                THEN Mode := 3
                ELSE
                  IF   Resolution = '1024X768X256'
                  THEN Mode := 4
                  ELSE Mode := 2     {640X480X256 is default}
            END

            ELSE BEGIN
              Driver := Detect;
              Mode := 0
            END;

  END {DecodeDriverMode};


  PROCEDURE CGADriverProc;
  EXTERNAL;
    {$L CGA.OBJ}


  PROCEDURE EGAVGADriverProc;
  EXTERNAL;
    {$L EGAVGA.OBJ}


  PROCEDURE SVGADriverProc;
  EXTERNAL;
    {$L SVGA.OBJ}


  PROCEDURE S3DriverProc;
  EXTERNAL;
    {$L S3.OBJ}


BEGIN
  InitDrivers
END.
