; *******************************************************
; *                                                     *
; *     Turbo Pascal XMS support for loading overlays   *
; *                                                     *
; *     Copyright (C) 1992      Wilbert van Leijen      *
; *     Copyright (C) 2000-2002 Robert AH Prins         *
; *                             Incorporating 386'ified *
; *                             changes by              *
; *                             Veit Kannegieser        *
; *                                                     *
; *******************************************************

           TITLE   OVERXMS

           INCLUDE SE.ASM               ; added XMS functions

           .386

data       segment word public use16
           assume  ds:data

;  XMS block move record

XmsMoveType STRUC
           BlkSize     DD    ?
           SrcHandle   DW    ?
           SrcOffset   DD    ?
           DestHandle  DW    ?
           DestOffset  DD    ?
XmsMoveType ENDS

;  TP overlay manager record

OvrHeader  STRUC
           ReturnAddr   DD   ?          ; Virtual return address
           FileOfs      DD   ?          ; Offset into overlay file
           CodeSize     DW   ?          ; Size of overlay
           FixupSize    DW   ?          ; Size of fixup table
           EntryPts     DW   ?          ; Number of procedures
           CodeListNext DW   ?          ; Segment of next overlay
           LoadSeg      DW   ?          ; Start segment in memory
           Reprieved    DW   ?          ; Loaded in memory flag
           LoadListNext DW   ?          ; Segment of next in load list
           XmsOffset    DD   ?          ; Offset into allocated XMS block
           UserData     DW   3 DUP(?)
OvrHeader  ENDS

XmsDriver    DD    ?                    ; Entry point of XMS driver
ExitSave     DD    ?                    ; Pointer to previous exit proc
XmsMove      XmsMoveType <>
OvrXmsHandle DW    ?                    ; Returned by XMS driver

           Extrn   PrefixSeg   : Word
           Extrn   ExitProc    : DWord
           Extrn   OvrResult   : Word
           Extrn   OvrCodeList : Word
           Extrn   OvrDosHandle: Word
           Extrn   OvrHeapOrg  : Word
           Extrn   OvrReadBuf  : DWord
data       ends

code       segment byte public use16
           assume  cs:code

           Public  OvrInitXMS

ovrIOError     EQU     -4
ovrNoXMSDriver EQU     -7
ovrNoXMSMemory EQU     -8

OvrXmsExit PROC

; Release handle and XMS memory

        mov   dx, [OvrXmsHandle]
        mov   ah, xmsFreeEMB                        ; 10
        call  [XmsDriver]

; Restore pointer to previous exit procedure

        mov   eax, [ExitSave]                       ; RAHP
        mov   [ExitProc], eax                       ; RAHP
        retf

OvrXmsExit ENDP

        INCLUDE ALIGN.ASM                           ; RAHP

AllocateXms PROC

;  Determine the size of the XMS block to allocate:
;  Walk the CodeListNext chain
;  Store the total codesize in DX:AX

        xor   edx, edx                              ; RAHP
        mov   bx, [OvrCodeList]
@@1:    add   bx, [PrefixSeg]
        add   bx, 10h
        mov   es, bx
        movzx ecx, word ptr es:[OvrHeader.CodeSize] ; VK/RAHP
        inc   cx                                    ; VK
        add   edx, ecx                              ; VK/RAHP
        mov   bx, es:[OvrHeader.CodeListNext]
        or    bx, bx
        jnz   @@1

;  Obtain number of kilobytes to allocate

        shr   edx, 10                               ; RAHP
        inc   dx

;  Allocate the block

        mov   ah, xmsAllocEMB                       ; 9
        call  [XmsDriver]
        or    ax, ax
        jz    @@2

        mov   [OvrXmsHandle], dx
@@2:    retn

AllocateXms ENDP

        INCLUDE ALIGN.ASM                           ; RAHP

;  Function XmsReadFunc(OvrSeg: word): Integer; Far;

XmsReadFunc PROC

;  Swap the code from XMS to the heap

        push  bp
        mov   bp, sp
        mov   es, [bp + 6]

        movzx eax, word ptr es:[OvrHeader.CodeSize] ; RAHP
        mov   [XmsMove.BlkSize], eax                ; RAHP

        mov   ax, [OvrXmsHandle]
        mov   [XmsMove.SrcHandle], ax

        mov   eax, es:[OvrHeader.XmsOffset]         ; RAHP
        mov   [XmsMove.SrcOffset], eax              ; RAHP
        xor   eax, eax                              ; RAHP
        mov   dword ptr [XmsMove.DestHandle], eax   ; RAHP

        mov   ax, es:[OvrHeader.LoadSeg]
        mov   word ptr [XmsMove.DestOffset + 2], ax
        lea   si, XmsMove
        mov   ah, xmsMoveEMB                        ; 11
        call  [XmsDriver]
        or    ax, ax
        jz    @@1

        dec   ax
        jmp   @@2

@@1:    mov   ax, ovrIOError
@@2:    pop   bp
        retf  2

XmsReadFunc ENDP

        INCLUDE ALIGN.ASM                           ; RAHP

;  Copy an overlaid unit from the heap to XMS
;  If successful, carry flag is cleared
;  In/Out:
;    edi = offset into XMS memory block

CopyUnitToXms PROC

;  XMS requires that an even number of bytes is moved

        movzx edx, word ptr es:[OvrHeader.CodeSize]

        inc   dx                                    ; RAHP
        and   dx, -2                                ; RAHP
        mov   es:[OvrHeader.CodeSize], dx           ; RAHP

;  Get the fields of the XMS block move structure

@@1:    mov   [XmsMove.BlkSize], edx
        xor   ax, ax
        mov   [XmsMove.SrcHandle], ax
        mov   word ptr [XmsMove.SrcOffset], ax
        mov   ax, [OvrHeapOrg]
        mov   word ptr [XmsMove.SrcOffset + 2], ax
        mov   ax, [OvrXmsHandle]
        mov   [XmsMove.DestHandle], ax
        mov   [XmsMove.DestOffset], edi             ; RAHP
        mov   ah, xmsMoveEMB                        ; 11
        lea   si, XmsMove
        call  [XmsDriver]

;  Bump code size

        add   edi, edx                              ; RAHP

;  Check return code from XMS driver

        or    ax, ax
        jz    @@2
        clc
        retn

@@2:    stc
        retn

CopyUnitToXms ENDP

        INCLUDE ALIGN.ASM                           ; RAHP

OvrXmsLoad PROC

        push  bp
        mov   bp, sp

;  Walk the CodeList chain
;  First segment is PrefixSeg+10h+OvrCodeList
;  Push each element of overlaid unit list on the stack
;  Keep the size of the linked list in CX

        mov   ax, [OvrCodeList]
        xor   cx, cx
@@1:    add   ax, [PrefixSeg]
        add   ax, 10h
        mov   es, ax
        push  ax
        inc   cx
        mov   ax, es:[OvrHeader.CodeListNext]
        or    ax, ax
        jnz   @@1

;  Loop:
;    Pop each element of the overlaid unit list from the stack

        xor   edi, edi                              ; RAHP

@@2:    pop   es
        push  cx
        mov   ax, [OvrHeapOrg]
        mov   es:[OvrHeader.LoadSeg], ax
        mov   es:[OvrHeader.XmsOffset], edi         ; RAHP

;  Load overlay from disk

        push  edi                                   ; RAHP
        push  es
        push  es
        call  [OvrReadBuf]
        pop   es
        pop   edi                                   ; RAHP

;  Flag unit as 'unloaded'; check return code

        mov   es:[OvrHeader.LoadSeg], 0
        neg   ax
        jc    @@3

        call  CopyUnitToXms
        jc    @@3

        pop   cx
        loop  @@2

@@3:    mov   sp, bp
        pop   bp
        retn

OvrXMSLoad ENDP

        INCLUDE ALIGN.ASM                           ; RAHP

OvrInitXMS PROC

;  Make sure the file's been opened

        xor   ax, ax
        cmp   ax, [OvrDOSHandle]
        jne   @@1

        dec   ax                                    ; ovrError
        jmp   @@5

;  Check presence of XMS driver

@@1:    mov   ax, 4300h
        int   2fh
        cmp   al, 80h
        je    @@2

        mov   ax, ovrNoXmsDriver
        jmp   @@5

;  Get XMS driver's entry point

@@2:    mov   ax, 4310h
        int   2fh
        mov   word ptr [XmsDriver], bx
        mov   word ptr [XmsDriver + 2], es
        call  AllocateXms
        jnz   @@3

        mov   ax, ovrNoXMSMemory
        jmp   @@5

;  Load the overlay into XMS

@@3:    call  OvrXmsLoad
        jnc   @@4

;  An error occurred.  Release handle and XMS memory

        mov   dx, [OvrXmsHandle]
        mov   ah, xmsFreeEMB                        ; 10
        call  [XmsDriver]
        mov   ax, ovrIOError
        jmp   @@5

;  Close file

@@4:    mov   bx, [OvrDOSHandle]
        mov   ah, dosClose
        int   dos

;  OvrReadBuf := XmsReadFunc

        mov   word ptr [OvrReadBuf], Offset XmsReadFunc
        mov   word ptr [OvrReadBuf + 2], cs

;  ExitSave := ExitProc
;  ExitProc := OvrXmsExit

        mov   eax, [ExitProc]                       ; RAHP
        mov   [ExitSave], eax                       ; RAHP

        mov   word ptr [ExitProc], Offset OvrXmsExit
        mov   word ptr [ExitProc + 2], cs

;  Return result of initialisation

        xor   ax, ax
@@5:    mov   [OvrResult], ax
        retf

OvrInitXMS ENDP

        INCLUDE ALIGN.ASM                           ; RAHP

code    ends

        END