; *******************************************************
; *                                                     *
; *     Turbo Pascal Runtime Library Version 6.0/7.0    *
; *     Overlay OvrSetBuf procedure                     *
; *                                                     *
; *     Copyright (C) 2000-2002 Robert AH Prins         *
; *                                                     *
; *******************************************************

        TITLE   OVERSETB

        INCLUDE SE.ASM

        .386

DATA    SEGMENT WORD PUBLIC USE16

; Externals

        Extrn   OvrResult   : Word
        Extrn   OvrHeapSize : Word
        Extrn   OvrHeapOrg  : Word
        Extrn   OvrHeapEnd  : Word
        Extrn   OvrLoadlist : Word
        Extrn   OvrDosHandle: Word
        Extrn   HeapOrg     : DWord
        Extrn   HeapPtr     : DWord
        Extrn   HeapEnd     : DWord
        Extrn   FreeList    : Dword

DATA    ENDS

CODE    SEGMENT BYTE PUBLIC USE16
        ASSUME  CS:CODE,DS:DATA

; Publics

        Public  OvrSetBuf

ovrOk       EQU      0
ovrError    EQU     -1
ovrNotFound EQU     -2
ovrNoMemory EQU     -3
ovrIOError  EQU     -4

; procedure OvrSetBuf(Size: LongInt); far;

OvrSetBuf PROC

        xor   ax, ax
        cmp   ax, [OvrDosHandle]
        je    @@2                        ; overlay file not opened

        cmp   ax, [OvrLoadList]
        jne   @@2                        ; no overlays loaded

        mov   bx, sp
        mov   eax, ss:[bx + 4]           ; requested size (longint)
        shr   eax, 4                     ; convert to paragraphs

        cmp   ax, [OvrHeapSize]
        jb    @@2

        add   ax, [OvrHeapOrg]
        jb    @@3

        cmp   ax, word ptr [HeapEnd + 2]
        ja    @@3

        mov   [OvrHeapEnd], ax
        mov   word ptr [HeapOrg + 2], ax
        shl   eax, 16
        mov   [HeapPtr], eax
        mov   [FreeList], eax

@@1:    mov   [OvrResult], ax
        retf  4

@@2:    mov   ax, ovrError
        jmp   @@1

@@3:    mov   ax, ovrNoMemory
        jmp   @@1

OvrSetBuf ENDP

        INCLUDE ALIGN.ASM

Code    ENDS

        END