{*******************************************************}
{                                                       }
{       Turbo Pascal Runtime Library Version 6.0/7.0    }
{       Overlay Interface Unit                          }
{                                                       }
{       Copyright (C) 1988,91   Borland International   }
{       Copyright (C) 2000-2002 Robert AH Prins         }
{                                                       }
{*******************************************************}

unit Overlay;

{$D-,I-,S-}

interface

const
  ovrOk          =  0;
  ovrError       = -1;
  ovrNotFound    = -2;
  ovrNoMemory    = -3;
  ovrIOError     = -4;
  ovrNoEMSDriver = -5;
  ovrNoEMSMemory = -6;

const
  OvrResult   : Integer = 0;
  OvrEmsPages : Word    = 0;
  OvrTrapCount: Word    = 0;
  OvrLoadCount: Word    = 0;
  OvrFileMode : Byte    = 0;

type
  OvrReadFunc = function(OvrSeg: Word): Integer;

var
  OvrReadBuf: OvrReadFunc;

procedure OvrInit(FileName: String);
procedure OvrInitEMS;
procedure OvrSetBuf(Size: LongInt);
function  OvrGetBuf: LongInt;
procedure OvrSetRetry(Size: LongInt);
function  OvrGetRetry: LongInt;
procedure OvrClearBuf;

implementation

{$L OVERLAY.OBJ  }
{$L OVERSETB.OBJ }
{$L OVERGETB.OBJ }
{$L OVERSETR.OBJ }
{$L OVERGETR.OBJ }
{$L OVERCBUF.OBJ }
{$L OVEREMS.OBJ  }

const
  OvrRetrySize: Word    = 0;
  OvrFileBase : Longint = 0;

procedure OvrInit(FileName: String);  external { OVERLAY.ASM  };
procedure OvrSetBuf(Size: LongInt);   external { OVERSETB.ASM };
function  OvrGetBuf: LongInt;         external { OVERGETB.ASM };
procedure OvrSetRetry(Size: LongInt); external { OVERSETR.ASM };
function  OvrGetRetry: LongInt;       external { OVERGETR.ASM };
procedure OvrClearBuf;                external { OVERCBUF.ASM };
procedure OvrInitEMS;                 external { OVEREMS.ASM  };

procedure OverlayHalt;
begin
  RunError(209);
end;

end.