; *******************************************************
; *                                                     *
; *     Turbo Pascal Runtime Library Version 6.0/7.0    *
; *     Overlay Unit                                    *
; *                                                     *
; *     Copyright (C) 2000-2002 Robert AH Prins         *
; *                                                     *
; *******************************************************

        TITLE   OVERLAY

        INCLUDE SE.ASM

        .386

DATA    SEGMENT WORD PUBLIC USE16

; Externals

        Extrn   OvrResult   : Word
        Extrn   OvrTrapCount: Word
        Extrn   OvrLoadCount: Word
        Extrn   OvrFileMode : Byte
        Extrn   OvrRetrySize: Word
        Extrn   OvrFileBase : DWord

        Extrn   OvrReadBuf  : DWord
        Extrn   OvrCodeList : Word
        Extrn   OvrHeapsize : Word
        Extrn   OvrDebugPtr : DWord
        Extrn   OvrHeapOrg  : Word
        Extrn   OvrHeapPtr  : Word
        Extrn   OvrHeapEnd  : Word
        Extrn   OvrLoadlist : Word
        Extrn   OvrDosHandle: Word
        Extrn   HeapOrg     : DWord
        Extrn   HeapPtr     : DWord
        Extrn   HeapEnd     : DWord
        Extrn   FreeList    : Dword
        Extrn   PrefixSeg   : Word

DATA    ENDS

CODE    SEGMENT BYTE PUBLIC USE16
        ASSUME  CS:CODE,DS:DATA

; Externals

        EXTRN   OverlayHalt:NEAR

; Publics

        Public  OvrInit
        Public  $G01

ovrOk         EQU      0
ovrError      EQU     -1
ovrNotFound   EQU     -2
ovrNoMemory   EQU     -3
ovrIOError    EQU     -4

Path    db    'PATH='

;-------------------------------------------------------------------------------
; procedure OvrInit(FileName: String); far;

OvrInit PROC

        push  bp
        mov   bp, sp
        sub   sp, 130
        cld
        cmp   word ptr [OvrCodeList], 0  ; no overlays!
        je    @@2

        mov   al, [OvrFileMode]
        mov   [bp - 2], al
        call  @@10
        jnc   @@3

        call  @@11
        jnc   @@3

        call  @@16
        jnc   @@3

        mov   ax, ovrNotFound
        jmp   @@9

@@1:    mov   ah, dosClose               ; close file [bx]
        int   21h

@@2:    mov   ax, ovrError
        jmp   @@9

@@3:    mov   bx, ax
        xor   ax, ax
        xor   dx, dx

@@4:    push  ds
        push  dx
        push  ax
        mov   cx, dx
        mov   dx, ax
        mov   ax, 4200h                  ; seek from start
        int   21h
        jc    @@5

        lea   dx, [bp - 10]
        push  ss
        pop   ds
        mov   cx, 8
        mov   ah, dosRead                ; read file [cx] bytes
        int   21h
        jc    @@5

        cmp   ax, cx

@@5:    pop   ax
        pop   dx
        pop   ds
        jc    @@1

        cmp   word ptr [bp - 10], 'ZM'
        jne   @@6

        mov   ax, [bp - 6]
        mov   dx, 0200h
        mul   dx
        mov   cx, [bp - 8]
        neg   cx
        and   cx, 01FFh
        sub   ax, cx
        sbb   dx, 0
        jmp   @@4

@@6:    cmp   word ptr [bp - 10], 'BF'
        jne   @@1

        cmp   word ptr [bp - 8], 'VO'
        je    @@7

        add   ax, [bp - 6]
        adc   dx, [bp - 4]
        add   ax, 8
        adc   dx, 0
        jmp   @@4

@@7:    mov   [OvrDosHandle], bx
        mov   word ptr [OvrFileBase], ax
        mov   word ptr [OvrFileBase + 2], dx
        mov   word ptr [OvrReadBuf], offset OvrReadFile
        mov   word ptr [OvrReadBuf + 2], cs
        or    [OvrDebugPtr], 0
        jnz   @@8

        mov   word ptr [OvrDebugPtr], offset cs:OvrNoDebug
        mov   word ptr [OvrDebugPtr + 2], cs

@@8:    push  ds
        mov   dx, offset cs:OvrInt3F
        push  cs
        pop   ds
        mov   ax, 253Fh                  ; set interrupt (3F)
        int   21h

        pop   ds
        xor   ax, ax                     ; ovrOk

@@9:    mov   [OvrResult], ax
        mov   sp, bp
        pop   bp
        retf  4

@@10:   push  ds
        lea   di, [bp - 130]
        push  ss
        pop   es
        call  @@25
        pop   ds
        retn

@@11:   mov   ah, dosVersion             ; get DOS version [al]
        int   21h

        cmp   al, 3
        jb    @@15

        push  ds
        mov   ds, [PrefixSeg]
        mov   ds, ds:[pspEnvSeg]         ; segment of environment
        xor   si, si

@@12:   lodsb
        or    al, al
        jnz   @@12

        lodsb
        or    al, al
        jnz   @@12

        lodsw
        lea   di, [bp - 130]
        push  ss
        pop   es
        mov   bx, di

@@13:   lodsb
        stosb
        or    al, al
        jz    @@14

        cmp   al, '\'
        jne   @@13

        mov   bx, di
        jmp   @@13

@@14:   mov   di, bx
        call  @@25
        pop   ds
@@15:   retn

@@16:   push  ds
        mov   ds, [PrefixSeg]
        mov   ds, ds:[pspEnvSeg]         ; segment of environment
        xor   si, si

@@17:   mov   di, offset cs:Path
        push  cs
        pop   es
        mov   cx, 5
        rep   cmpsb
        je    @@20

        dec   si

@@18:   lodsb
        or    al, al
        jnz   @@18

        cmp   al, [si]
        jne   @@17

@@19:   pop   ds
        stc
        retn

@@20:   cmp   byte ptr [si], 0
        je    @@19

        lea   di, [bp - 130]
        push  ss
        pop   es
        xor   al, al

@@21:   mov   ah, al
        lodsb
        or    al, al
        jz    @@22

        cmp   al, ';'
        je    @@23

        stosb
        jmp   @@21

@@22:   dec   si

@@23:   cmp   ah, ':'
        je    @@24

        cmp   ah, '\'
        je    @@24

        mov   al, '\'
        stosb

@@24:   push  ds
        push  si
        call  @@25
        pop   si
        pop   ds
        jc    @@20

        pop   ds
        retn

@@25:   lds   si, [bp + 6]
        lodsb
        movzx cx, al
        rep   movsb
        xor   al, al
        stosb
        lea   dx, [bp - 130]
        push  ss
        pop   ds
        mov   al, [bp - 2]
        mov   ah, dosOpen                ; open file
        int   21h
        retn

OvrInit ENDP

        INCLUDE ALIGN.ASM

;-------------------------------------------------------------------------------
OvrReadFile PROC

        mov   bx, sp
        mov   es, ss:[bx + 4]
        push  ds
        mov   bx, [OvrDosHandle]
        mov   di, [PrefixSeg]
        add   di, 10h
        mov   edx, dword ptr es:[ovFilePos]
        add   edx, es:[OvrFileBase]
        shld  ecx, edx, 16
        mov   ax, 4200h                  ; seek from start
        int   21h

        mov   ds, es:[ovSegment]
        xor   dx, dx
        mov   cx, es:[ovCodeSize]
        mov   ah, dosRead                ; read file [cx] bytes
        int   21h
        jc    @@4

        cmp   ax, cx
        jb    @@3

        add   ax, 000Fh
        shr   ax, 4

        add   ax, es:[ovSegment]
        mov   ds, ax
        xor   dx, dx
        mov   cx, es:[ovFixupSize]
        jcxz  @@2

        mov   ah, dosRead                ; read file [cx] bytes
        int   21h
        jc    @@4

        cmp   ax, cx
        jb    @@3

        shr   cx, 1
        xor   si, si
        mov   es, es:[ovSegment]
        cld

@@1:    lodsw
        mov   bx, ax
        add   es:[bx], di
        loop  @@1

@@2:    xor   ax, ax
        jmp   @@4

@@3:    mov   ax, 0064h

@@4:    pop   ds
        retf  2

OvrReadFile ENDP

;-------------------------------------------------------------------------------

OvrNoDebug PROC

        retf

OvrNoDebug   ENDP

        INCLUDE ALIGN.ASM

;-------------------------------------------------------------------------------

OvrInt3F PROC

        push  bp
        mov   bp, sp
        push  ax
        push  bx
        push  cx
        push  dx
        push  si
        push  di
        push  ds
        push  es
        mov   ax, seg data
        mov   ds, ax
        sti
        les   bx, [bp + 2]
        push  es:word ptr [bx]
        sub   word ptr [bp + 2], 2
        jnz   @@1

        call  @@3

        jmp   @@2

@@1:    add   bp, 6
        mov   ax, [bp]
        xchg  [bp - 6], ax
        mov   [bp], ax
        call  @@3

        mov   ax, [bp]
        xchg  [bp - 6], ax
        mov   [bp], ax

@@2:    pop   bx
        mov   ax, es:[ovRetryCount]
        cmp   ax, 1
        sbb   ax, ax
        call  [OvrDebugPtr]

        pop   es
        pop   ds
        pop   di
        pop   si
        pop   dx
        pop   cx
        pop   bx
        pop   ax
        pop   bp
        iret

@@3:    inc   word ptr [OvrTrapCount]
        cmp   es:word ptr [ovSegment], 0
        je    @@4

        mov   es:word ptr [ovRetryCount], 1
        jmp   @@9

@@4:    inc   word ptr [OvrLoadCount]
        push  es
        call  $G20

        mov   dx, es:[ovFixupSize]
        add   dx, 000Fh
        shr   dx, 4

        add   dx, ax
        call  $G17

        jmp   @@8

@@5:    push  dx
        call  @@14

        mov   es, [OvrLoadList]
        mov   ax, es:[ovNext]
        mov   [OvrLoadList], ax
        cmp   es:word ptr [ovRetryCount], 0
        jne   @@6

        call  $G01

        mov   es:word ptr [ovSegment], 0
        call  $G20
        jmp   @@7

@@6:    dec   es:word ptr [ovRetryCount]

        call  $G04

        call  $G08

        xor   ax, ax

@@7:    pop   dx

@@8:    sub   dx, ax
        ja    @@5

        pop   es
        mov   ax, [OvrHeapPtr]
        mov   es:[ovSegment], ax
        push  es
        push  es
        call  [OvrReadBuf]

        pop   es
        or    ax, ax
        jnz   @@13

        call  $G08

@@9:    call  @@19

        push  es
        call  $G17

        mov   es, [OvrLoadList]

@@10:   mov   cx, es:[ovNext]
        jcxz  @@12

        cmp   ax, [OvrRetrySize]
        jnb   @@12

        push  cx
        push  ax
        cmp   es:word ptr [ovRetryCount], 0
        jne   @@11

        call  $G01

@@11:   call  $G20

        pop   cx
        pop   es
        add   ax, cx
        jmp   @@10

@@12:   pop   es
        retn

@@13:   jmp   OverlayHalt

@@14:   mov   ax, [OvrLoadList]
        or    ax, ax
        je    @@17

        mov   es, ax
        mov   dx, es:[ovSegment]
        cmp   dx, [OvrHeapPtr]
        jnb   @@18

        xor   cx, cx

@@15:   inc   cx
        push  ax
        mov   es, ax
        mov   ax, es:[ovNext]
        or    ax, ax
        jne   @@15

        mov   [OvrLoadList], ax
        mov   ax, [OvrHeapEnd]
        mov   [OvrHeapPtr], ax
@@16:   pop   es
        push  cx
        mov   ax, [OvrLoadList]
        mov   es:[ovNext], ax
        mov   [OvrLoadList], es
        call  $G20

        sub   [OvrHeapPtr], ax
        call  $G04

        pop   cx
        loop  @@16

@@17:   mov   ax, [OvrHeapOrg]
        mov   [OvrHeapPtr], ax

@@18:   retn

@@19:   cmp   es:byte ptr [ovVectors], 0EAh
        je    @@22

        mov   cx, es:[ovSaveReturn]
        jcxz  @@20

        mov   ax, es:[ovSegment]
        mov   dx, es
        call  $G11

@@20:   mov   bx, es:[ovSegment]
        mov   cx, es:[ovJumpCount]
        mov   di, 0020h
        cld

@@21:   mov   dx, es:[di + 2]
        mov   al, 0EAh
        stosb
        mov   ax, dx
        stosw
        mov   ax, bx
        stosw
        loop  @@21

@@22:   retn

OvrInt3F ENDP

        INCLUDE ALIGN.ASM

;-------------------------------------------------------------------------------
$G01:   cmp   es:byte ptr [ovVectors], 0CDh
        je    $G03

        mov   ax, es
        mov   dx, es:[ovSegment]
        xor   cx, cx
        call  $G11

        mov   es:[ovSaveReturn], cx
        mov   cx, es:[ovJumpCount]
        mov   di, 0020h
        cld

$G02:   mov   dx, es:[di + 1]
        mov   ax, 03FCDh
        stosw
        mov   ax, dx
        stosw
        xor   al, al
        stosb
        loop  $G02

$G03:   retn

$G04:   mov   ax, [OvrHeapPtr]
        mov   dx, es:[ovSegment]
        mov   es:[ovSegment], ax
        mov   cx, es:[ovCodeSize]
        inc   cx
        shr   cx, 1
        xor   si, si
        cld
        cmp   ax, dx
        jb    $G05

        mov   si, cx
        dec   si
        shl   si, 1
        std

$G05:   mov   di, si
        push  ds
        push  es
        mov   ds, dx
        mov   es, ax
        rep   movsw
        pop   es
        pop   ds
        cmp   es:byte ptr [ovVectors], 0CDh
        je    $G07

        call  $G13

        mov   cx, es:[ovJumpCount]
        mov   di, 0023h
        cld

$G06:   stosw
        add   di, 3
        loop  $G06

$G07:   retn

$G08:   call  $G20

        add   [OvrHeapPtr], ax
        push  ds
        mov   bx, offset OvrLoadList

$G09:   mov   ax, [bx]
        or    ax, ax
        jz    $G10

        mov   ds, ax
        mov   bx, 0014h
        jmp   $G09

$G10:   mov   [bx], es
        mov   es:[ovNext], ax
        pop   ds
        retn

$G11:   call  $G13

        or    bx, bx
        je    $G12

        xchg  ss:[bx + 2], cx
$G12:   retn

$G13:   xor   bx, bx
        push  bp
        push  cx
        jmp   $G15

$G14:   shl   cx, 1
        je    $G16

        mov   bp, cx

$G15:   mov   cx, [bp]
        shr   cx, 1
        jb    $G14

        cmp   dx, [bp + 4]
        jne   $G14

        mov   [bp + 4], ax
        or    bx, bx
        jne   $G14

        mov   bx, bp
        jmp   $G14

$G16:   pop   cx
        pop   bp
        retn

$G17:   mov   ax, [OvrLoadList]
        or    ax, ax
        je    $G18

        mov   es, ax
        mov   ax, es:[ovSegment]
        sub   ax, [OvrHeapPtr]
        jnb   $G19

$G18:   mov   ax, [OvrHeapEnd]
        sub   ax, [OvrHeapPtr]
$G19:   retn

$G20:   mov   ax, es:[ovCodeSize]
        add   ax, 000Fh
        shr   ax, 4
        retn

        INCLUDE ALIGN.ASM

Code    ENDS

        END