; *******************************************************
; *                                                     *
; *     Turbo Pascal Runtime Library Version 6.0/7.0    *
; *     Overlay EMS support                             *
; *                                                     *
; *     Copyright (C) 2000-2002 Robert AH Prins         *
; *                                                     *
; *******************************************************

        TITLE   OVEREMS

        INCLUDE SE.ASM

        .386

DATA    SEGMENT WORD PUBLIC USE16

; Externals

        EXTRN   OvrResult   : Word
        EXTRN   OvrEmsPages : Word
        EXTRN   OvrReadBuf  : DWord
        EXTRN   OvrCodeList : Word
        EXTRN   OvrHeapOrg  : Word
        EXTRN   OvrDosHandle: Word
        EXTRN   OvrEmsHandle: Word
        EXTRN   PrefixSeg   : Word
        EXTRN   ExitProc    : DWord

OvrEmsFrame dw      1 dup(?)
EmsExitSave dd      1 dup(?)

Data    ENDS

CODE    SEGMENT BYTE PUBLIC USE16
        ASSUME  CS:CODE,DS:DATA

; Publics

        PUBLIC  OvrInitEMS

ovrOk          EQU      0
ovrError       EQU     -1
ovrIOError     EQU     -4
ovrNoEMSDriver EQU     -5
ovrNoEMSMemory EQU     -6

EMMXXXX0 db     'EMMXXXX0'

OvrInitEMS PROC

;  Make sure the file's been opened

        xor   ax, ax                     ; ovrOk
        cmp   ax, [OvrDosHandle]
        jne   @@1

        dec   ax                         ; ovrError
        jmp   @@5

@@1:    call  OvrEmsCheck
        jz    @@2

        mov   ax, ovrNoEMSDriver
        jmp   @@5

@@2:    call  OvrEmsSize
        jnc   @@3

        mov   ax, ovrNoEMSMemory
        jmp   @@5

@@3:    call  OvrEmsLoad
        jnc   @@4

        mov   dx, [OvrEMSHandle]
        mov   ah, 45h                    ; release handle and memory
        int   67h

        mov   ax, ovrIOError
        jmp   @@5

@@4:    mov   bx, [OvrDosHandle]
        mov   ah, dosClose               ; close file [bx]
        int   21h

        mov   word ptr [OvrReadBuf], offset cs:EmsReadFunc
        mov   word ptr [OvrReadBuf + 2], cs

        mov   eax, [ExitProc]
        mov   [EmsExitSave], eax

        mov   word ptr [ExitProc], offset cs:OvrEmsExit
        mov   word ptr [ExitProc + 2], cs

        xor   ax, ax                     ; ovrOk

@@5:    mov   [OvrResult], ax
        retf

OvrInitEMS ENDP

        INCLUDE ALIGN.ASM

;-------------------------------------------------------------------------------

OvrEmsExit PROC

; Release handle and EMS memory

        mov   dx, [OvrEMSHandle]
        mov   ah, 45h                    ; release handle and memory
        int   67h

; Restore pointer to previous exit procedure

        mov   eax, [EmsExitSave]
        mov   [ExitProc], eax

        retf

OvrEMSExit ENDP

        INCLUDE ALIGN.ASM

;-------------------------------------------------------------------------------

OvrEmsCheck PROC

;  Check presence of EMS driver

        mov   ax, 3567h                  ; get int 67 [es:bx]
        int   21h

        mov   cx, 8
        mov   si, offset cs:EMMXXXX0
        mov   di, 10
        push  ds
        push  cs
        pop   ds
        cld
        rep   cmpsb
        pop   ds
        retn

OvrEmsCheck ENDP

        INCLUDE ALIGN.ASM

;-------------------------------------------------------------------------------
;  Walk the CodeList chain
;  First segment is PrefixSeg + 10h + OvrCodeList
;  Add sizes of all overlays in DX:AX
;  Check if there is sufficient EMS memory available
;-------------------------------------------------------------------------------
OvrEmsSize PROC

        mov   ah, 41h                    ; get pageframe segment [bx]
        int   67h

        shl   ah, 1                      ; these instructions
        jc    @@2                        ;   were added in BP7!

        mov   [OvrEmsFrame], bx
        mov   ax, 3FFFh
        xor   dx, dx
        mov   bx, [OvrCodeList]

@@1:    add   bx, [PrefixSeg]
        add   bx, 10h
        mov   es, bx
        add   ax, es:[ovCodeSize]        ; add VK (OVERXMS) change?
        adc   dx, 0
        mov   bx, es:[ovLink]
        or    bx, bx
        jnz   @@1

        shrd  ax, dx, 14
        mov   bx, ax
        mov   ah, 43h                    ; get handle and allocate pages [bx]
        int   67h

        shl   ah, 1
        jc    @@2

        mov   [OvrEmsPages], bx
        mov   [OvrEMSHandle], dx
@@2:    retn

OvrEmsSize ENDP

        INCLUDE ALIGN.ASM

;-------------------------------------------------------------------------------

OvrEmsLoad PROC

        push  bp
        mov   bp, sp
        mov   dx, [OvrEMSHandle]
        mov   ah, 47h                    ; save mapping context
        int   67h

        mov   ax, [OvrCodeList]
        xor   cx, cx

@@1:    add   ax, [PrefixSeg]
        add   ax, 10h
        mov   es, ax
        push  ax
        inc   cx
        mov   ax, es:[ovLink]
        or    ax, ax
        jnz   @@1

        xor   bx, bx
        xor   di, di

@@2:    pop   es
        push  cx
        mov   ax, [OvrHeapOrg]
        mov   es:[ovSegment], ax
        mov   es:[ovEmsPage], bx
        mov   es:[ovEmsOffset], di

;  Load overlay from disk

        push  bx
        push  di
        push  es
        push  es
        call  [OvrReadBuf]
        pop   es
        pop   di
        pop   bx

        mov   es:word ptr [ovSegment], 0
        neg   ax
        jc    @@3

        call  OvrCopyToEms
        jc    @@3

        pop   cx
        loop  @@2

@@3:    pushf
        mov   dx, [OvrEMSHandle]
        mov   ah, 48h                    ; restore mapping context
        int   67h

        popf
        mov   sp, bp
        pop   bp
        retn

OvrEmsLoad ENDP

        INCLUDE ALIGN.ASM

;-------------------------------------------------------------------------------

OvrCopyToEms PROC

        mov   dx, es:[ovCodeSize]
        xor   si, si

@@1:    or    di, di
        jnz   @@2

        push  dx
        mov   dx, [OvrEMSHandle]
        mov   ax, 4400h                  ; map memory page [al]
        int   67h

        pop   dx
        shl   ah, 1
        jc    @@5

@@2:    mov   cx, 4000h
        sub   cx, di
        cmp   cx, dx
        jb    @@3

        mov   cx, dx

@@3:    sub   dx, cx
        push  ds
        push  es
        mov   es, [OvrEmsFrame]
        mov   ds, [OvrHeapOrg]
        cld
        rep   movsb
        pop   es
        pop   ds
        cmp   di, 4000h
        jne   @@4

        inc   bx
        xor   di, di

@@4:    or    dx, dx
        jnz   @@1

@@5:    retn

OvrCopyToEms ENDP

        INCLUDE ALIGN.ASM

;-------------------------------------------------------------------------------

;  Function EmsReadFunc(OvrSeg: Word): Integer; Far;

EmsReadFunc  PROC

        mov   bx, sp
        mov   es, ss:[bx + 4]
        mov   dx, [OvrEMSHandle]
        mov   ah, 47h                    ; save mapping context
        int   67h

        mov   bx, es:[ovEmsPage]
        mov   dx, es:[ovCodeSize]
        mov   si, es:[ovEmsOffset]
        xor   di, di

@@1:    mov   cx, 4000h
        sub   cx, si
        cmp   cx, dx
        jb    @@2

        mov   cx, dx

@@2:    sub   dx, cx
        push  dx
        mov   dx, [OvrEMSHandle]
        mov   ax, 4400h                  ; map memory page [al]
        int   67h

        pop   dx
        or    ah, ah
        jnz   @@3

        push  ds
        push  es
        mov   ds, [OvrEmsFrame]
        mov   es, es:[ovSegment]
        cld
        rep   movsb
        pop   es
        pop   ds
        inc   bx
        xor   si, si
        or    dx, dx
        jnz   @@1

@@3:    movzx ax, ah
        push  ax
        mov   dx, [OvrEMSHandle]
        mov   ah, 48h                    ; restore mapping context
        int   67h

        pop   ax
        retf  2

EmsReadFunc ENDP

        INCLUDE ALIGN.ASM

CODE    ENDS

        END