Unit Complex;
interface

Type
 PComplex = ^TComplex;
 TComplex = record
             Real : Real;
             Imag : Real;
            end;

Procedure ComplexMultiply(var First, Second,Result : TComplex);
Procedure ComplexSquare(var First,Result : TComplex);
Procedure ComplexAdd(var First, Second,Result : TComplex);
Procedure ComplexSubtract(var First,Second,Result : TComplex);
Procedure ToComplex(First,Second : Real; var Result : TComplex);

implementation

Procedure ComplexMultiply;
begin
 Result.Real:=(First.Real * Second.Real) - (First.Imag * Second.Imag);
 Result.Imag:=(First.Real * Second.Imag) - (First.Imag * Second.Real);
end;

Procedure ComplexSquare;
begin
 Result.Real:=(Sqr(First.Real)-Sqr(First.Imag));
 Result.Imag:=2*First.Real*First.Imag;
end;

Procedure ComplexAdd;
begin
 Result.Real:=First.Real+Second.Real;
 Result.Imag:=First.Imag+Second.Imag;
end;

Procedure ComplexSubtract;
begin
 Result.Real:=First.Real-Second.Real;
 Result.Imag:=First.Imag-Second.Imag;
end;

Procedure ToComplex;
begin
 Result.Real:=First;
 Result.Imag:=Second;
end;

begin
 WriteLn('Complex Mathematics Unit Version 1.0 Started Up...');
end.
end;