Program CAD_INT9;

{
  Copyright
  ---------

  Copyright Joseph Kevin Robertson,
            9 Whitfield Square,
            DUNDEE.
            16th April 1995

  Disclaimer
  ----------

  **  DO NOT REMOVE THIS DISCLAIMER **

  Mr. J. K. Robertson, MCSCS3JKR@ZIPPY.DCT.AC.UK, hereby disclaims
  all warranties relating to the use of the software herein - namely
  CADZ_INT9.

  Mr. J. K. Robertson will not be liable for any incidental,
  consequential, special, indirect, or similar damages due to
  loss of data or any other reason.

  The user using this example application assumes all responsibility
  for its use, its quality, and performance.

  Further Information
  -------------------

  It should be noted that if another Int 9H interrupt is installed alongside
  this one then there is no guarantee that this application will still
  prevent a warm boot. Further Int 9H Interrupt Routines may force a
  warm boot upon capture of the Control-Alt-Delete keypress.
}

Uses
  Crt,
  Dos;

Const
  DeleteKey         = 83; {Scan Code of Delete Key.                       }
  KeyboardInterrupt = 9;  {Interrupt Number of Keyboard ISR.              }
  KeyboardFlagMask  = $C; {Mask to test Control, and Alt, bits of Keyboard}
                          {flag.                                          } 

Var
  OldKeyboardInterrupt : Pointer;              {Ms-Dos KISR Vector Address}
  OldExitRoutine       : Pointer;              {TP Exit Routine}
  KeyboardFlags        : Byte Absolute $0040:$0017; {BIOS DATA AREA!}
  Character            : Char;

{$F+}
Procedure CallOldInterrupt(OldInterrupt : Pointer);
{$F-}
Begin
  Asm
    PushF                    {Store Flags}
    Call DWord Ptr [BP + 06] {Execute instructions found at memory location}
                             {passed via OldInterrupt variable}
  End;
End;

Procedure NewKeyboardInterrupt(Flags, CS, IP, AX, BX, CX, DX, SI, DI,
                                                           DS, ES, BP : Word);
Interrupt;
Label
  ExitInterrupt;
Begin
  If (((KeyboardFlags And KeyboardFlagMask) = KeyboardFlagMask)
      And (Port[$60] = DeleteKey)) Then
  Begin
    Asm
      Sti                 {Allow Interrupts}
      PushF               {Store Flags onto stack}
      In    AL, $61       {Read control byte from Port B of 8255 chip}
      Mov   AH, AL        {Save control byte}
      Or    AL, $80       {Set RESET bit on control byte}
      Out   $61, AL       {Send control byte to Port B of 8255 chip}
      Xchg  AH, AL        {Restore original control byte}
      Out   $61, AL       {Send original control byte to Port B}
      PopF                {Retrieve Flags from stack}
      Cli                 {Disallow interrupts (except NMI)}
      Mov   AL, $20       {Set EOI value}
      Out   $20, AL       {Send EOI to 8259 Interrupt Controller Chip}
      Jmp   ExitInterrupt {Avoid calling of Old Keyboard Interrupt}
    End;
  End;
  CallOldInterrupt(OldKeyboardInterrupt); {Ctrl-Alt-Delete Was NOT pressed}
  ExitInterrupt:
  Asm
    Sti                   {Allow Interrupts}
  End;
End;

{$F+}
Procedure ExitProcedure;
{$F-}
Begin
  SetIntVec(KeyboardInterrupt, OldKeyboardInterrupt);
  ExitProc := OldExitRoutine;
End;

Begin
  ClrScr;
  GetIntVec(KeyboardInterrupt, OldKeyboardInterrupt);
  SetIntVec(KeyboardInterrupt, @NewKeyboardInterrupt);
  OldExitRoutine := ExitProc;
  ExitProc := @ExitProcedure;
  WriteLn('No Control-Alt-Delete Allowed');
  WriteLn('=============================');
  WriteLn;
  WriteLn('This application cannot be reset via Control-Alt-Delete.');
  WriteLn;
  WriteLn('This is due to the new keyboard handler that has been');
  WriteLn('installed. Normal service will resume when this application');
  WriteLn('is terminated ...');
  WriteLn;
  Write('Q or q to Quit < >', Chr(8), Chr(8));
  Repeat
    Character := ReadKey;
    If (Character = #0) Then
    Begin
      Character := ReadKey;
      Character := #0;
    End;
  Until (Character In ['Q', 'q']);
End.