program BitTest; {Copyright 1995, Shawn Bayern.  Demonstration of
                  unit BitWise}

{This program just provides simple sample usages of the unit BitWise.
 See the documentation, BITWISE.DOC, for instructions and further
 examples.}

uses BitWise;

var
   MyArray:  array[1..1000] of byte;  {this gives us 8000 bits to work with}
   SingleByte: byte; {this gives us 8 bits}
   counter: integer;

begin
   SetElement(MyArray,634);  {now, element (i.e., bit) #634 is "1"}
   ResetElement(SingleByte,7); {element #293 is now "0"}
   IF Element(MyArray,634)
      then
         Writeln('Element #634 of MyArray is "on."')
      else
         Writeln('Element #634 of MyArray is "off."');
   If Element(SingleByte,7)
      then
         Writeln('Element #7 of SingleByte is "on."')
      else
         Writeln('Element #7 of SingleByte is "off."');

   SingleByte:=not SingleByte; {negate all 8 bits in one fell swoop}
   Writeln(
'It is now ',Element(SingleByte,7),' that Element #7 of SingleByte is "on"');
   {and again ...}
   Writeln;
   Writeln('Toggling ...');
   Writeln;
   SingleByte:=not SingleByte; {negate all 8 bits in one fell swoop}
   Writeln(
'It is now ',Element(SingleByte,7),' that Element #7 of SingleByte is "on."');
   Writeln('Press ENTER to continue ...');
   Readln;
   {another example}
   for counter:=1 to 1000 do
      MyArray[counter]:=Random(255);  {*quickly* initialize 800 bits
                                      with random values}
   {now, just to *do* something with these "pseudo-boolean" values}
   for counter:=1 to 8000 do
      if Element(MyArray,counter) then write('*') else Write(' ');

   Writeln;
   Writeln('And all these data are stored in a small, 1000-byte array.');
end.

