program bench; { Adler32 / CRC32 benchmarking program }
uses Adler32, Checksum, Timing;
const
  rounds = 500; { 500 Mb to test }
{.$define TP}
{ Delete the "." and define TP if compiling under Turbo Pascal }

var
{This kind of big array will only work with FPK-Pascal or GNU-Pascal}
{$ifdef TP}
  bytea  : Array[0..30000] of Byte;  { TP only has 65520 bytes data segment}
{$else}
  bytea : Array[0..999999] of Byte; { 1,000,000 Bytes ~ 1Mb}
{$endif}
  crc   : LongInt;
  i     : LongInt;
  s     : LongInt;
  time  : LongInt;
begin
 s := SizeOf(bytea);
 FillChar(bytea, s, $FF);

 StartClock;
 crc := 1;  { Initialize the CRC }
 for i := 1 to rounds do
   Adler32Update(crc, bytea, s);

 time := StopClock;
 Writeln('Adler32 Speed : ', Round((rounds * s) / (time * 1024)), ' KiloBytes/Second    (',time,' seconds)');

 StartClock;
 InitCRC32Value(crc);
 for i := 1 to rounds do
   UpdateCRC32(bytea, s, crc);
 FinalizeCRC32Value(crc);

 time := StopClock;
 Writeln('  CRC32 Speed : ', Round((rounds * s) / (time * 1024)), ' KiloBytes/Second    (',time,' seconds)');
end.