Program TestTrig;

Uses trig;

{ This tests some of the functions in the TRIG.TPU file.  Make
  sure TRIG.TPU is where Pascal can find it before trying to run
  this program! }

var testx,testy:real;

begin
 writeln('TRIG.TPU Test');
 writeln('-------------');
 { Following line should return the square root of 2. }
 writeln('Distance between 0,0 and 1,1 (2-D space): ',distance(0,0,1,1):1:4);
 { Should return the square root of 3. }
 writeln('Distance between 0,0,0 and 1,1,1 (3-D space): ',distance3d(0,0,0,1,1,1):1:4);
 { Should return 90. }
 writeln('Compass angle between 0,0 and 1,0: ',findangle(0,0,1,0):1:4);
 { Should return 0. }
 writeln('Polar angle between 0,0 and 1,0: ',findpolar(0,0,1,0):1:4);
 { Should return 1.5708. }
 writeln('Number of radians in 90 degrees: ',deg2rad(90):1:4);
 { Should return *around* 90 (some precision is lost). }
 writeln('Number of degrees in 1.5708 radians: ',rad2deg(1.5708):1:4);
 { -=- }
 pol2cart(testx,testy,sqrt(2),45);
 { Should return Cartesian coordinates (1.00,1.00). }
 writeln('Converting Polar (r,a = ',sqrt(2):1:4,',','45) to Cartesian (x,y = ',testx:1:2,',',testy:1:2,')');
 { Should return the cube root of 2, about 1.2599 }
 writeln('2 to the 1/3 power equals: ',power(2,1/3):1:3);
 { Should both return 1. }
 writeln('Sine of 90 degrees: ',dsin(90):1:3);
 writeln('Cosine of 0 degrees: ',dcos(0):1:3);
 writeln('The Golden Ratio is: ',goldenratio:1:6);
 writeln('Euler''s Constant is: ',e:1:6);
 writeln;
 writeln('For a complete list of functions and constants,');
 writeln('please see TRIG.TXT');
 writeln;
 writeln(' - Sean O''Malley, Feb. 1999');
end.