{*****************************************************************************
 This program patches TPC.EXE, version 5.5. The resulting command line
 compiler can produce additional code to call a user-supplied routine whenever
 a pointer is dereferenced. The user-supplied routine can perform any of a
 variety of operations: error-checking the pointer, transparently supporting
 handle-based pointers for heap compaction, or implementing a complete virtual
 heap in EMS or on disk.

 To use this program, compile it and run it from a directory where a copy of
 TPC.EXE resides. The program directly changes TPC.EXE -- no backup is made.
 The program works only on version 5.50 of Turbo Pascal, which to our
 knowledge is the only released version of Turbo 5.5. We have not developed a
 similar patch for TURBO.EXE -- that would be possible, but the integrated
 compiler is linked differently, making it a chore to find the patch
 locations.

 If the patching program halts with an error, be sure to restore a fresh copy
 of TPC.EXE from a backup. At the time of the error, the compiler may be
 partially patched.

 For further information on using the patched compiler, refer to HEAP.DOC.

 Written 1/6/90, Kim Kokkonen, TurboPower Software.
   Thanks to Chris Franzen of O.K.Soft, West Germany, for tracking down the
   locations in the version 5.5 compiler that corresponded to the ones I
   found in earlier versions.
*****************************************************************************}

{$R-,S-,I+,F-,B-,V-}

program HeapPatch;
const
  DerefInterrupt = $66; {Change this constant to use a different
                         interrupt number to call the user routine}
type
  PatchRec =            {Describes one patch}
    record
      P : LongInt;      {File position}
      O : Byte;         {Original byte}
      N : Byte;         {New byte}
    end;

const
  PatchFileSize = 61926;
  NumPatches = 70;
  PatchArray : array[1..NumPatches] of PatchRec = (
    (P : $000008AE; O : $0B; N : $46),         {Adjust start of patch area}
    (P : $000008B3; O : $80; N : $63),         {Adjust length of patch area}
    (P : $0000090B; O : $90; N : $F7),         {Interrupt generation code}
    (P : $0000090C; O : $90; N : $06),
    (P : $0000090D; O : $90; N : $0A),
    (P : $0000090E; O : $90; N : $2A),
    (P : $0000090F; O : $90; N : $08),
    (P : $00000910; O : $90; N : $00),
    (P : $00000911; O : $90; N : $74),
    (P : $00000912; O : $90; N : $06),
    (P : $00000913; O : $90; N : $B8),
    (P : $00000914; O : $90; N : $CD),
    (P : $00000915; O : $90; N : DerefInterrupt),
    (P : $00000916; O : $90; N : $E8),
    (P : $00000917; O : $90; N : $EC),
    (P : $00000918; O : $90; N : $75),
    (P : $00000919; O : $90; N : $E9),
    (P : $0000091A; O : $90; N : $9F),
    (P : $0000091B; O : $90; N : $75),
    (P : $0000091C; O : $90; N : $00),         {Expanded option mask table}
    (P : $0000091E; O : $90; N : $40),
    (P : $0000091F; O : $90; N : $00),
    (P : $00000920; O : $90; N : $00),
    (P : $00000921; O : $90; N : $81),
    (P : $00000922; O : $90; N : $00),
    (P : $00000923; O : $90; N : $00),
    (P : $00000924; O : $90; N : $00),
    (P : $00000925; O : $90; N : $84),
    (P : $00000926; O : $90; N : $00),
    (P : $00000927; O : $90; N : $00),
    (P : $00000928; O : $90; N : $00),
    (P : $00000929; O : $90; N : $00),
    (P : $0000092A; O : $90; N : $20),
    (P : $0000092B; O : $90; N : $00),
    (P : $0000092C; O : $90; N : $01),
    (P : $0000092D; O : $90; N : $00),
    (P : $0000092E; O : $90; N : $00),
    (P : $0000092F; O : $90; N : $00),
    (P : $00000930; O : $90; N : $00),
    (P : $00000931; O : $90; N : $00),
    (P : $00000932; O : $90; N : $00),
    (P : $00000933; O : $90; N : $00),
    (P : $00000934; O : $90; N : $00),
    (P : $00000935; O : $90; N : $82),
    (P : $00000936; O : $90; N : $00),
    (P : $00000937; O : $90; N : $00),
    (P : $00000938; O : $90; N : $80),
    (P : $00000939; O : $90; N : $80),
    (P : $0000093A; O : $90; N : $00),
    (P : $0000093B; O : $90; N : $88),
    (P : $0000093C; O : $90; N : $02),
    (P : $0000093D; O : $90; N : $00),
    (P : $0000093E; O : $90; N : $04),
    (P : $0000093F; O : $90; N : $00),
    (P : $00000940; O : $90; N : $00),
    (P : $00000941; O : $90; N : $00),
    (P : $00000942; O : $90; N : $10),
    (P : $00000943; O : $90; N : $00),
    (P : $00000944; O : $90; N : $08),
    (P : $00000945; O : $90; N : $00),
    (P : $00004A95; O : $24; N : $74),         {Activate pointer gen code}
    (P : $00004A96; O : $34; N : $BE),
    (P : $000098D9; O : $D2; N : $1C),         {Refer to new option table}
    (P : $000098DA; O : $9A; N : $07),
    (P : $000099CD; O : $D2; N : $1C),         {Refer to new option table}
    (P : $000099CE; O : $9A; N : $07),
    (P : $00009CD1; O : $00; N : $01),         {Add $P option}
    (P : $00009CD2; O : $00; N : $50),
    (P : $00009CD3; O : $90; N : $00),
    (P : $0000DC88; O : $20; N : $70)          {Mark compiler as patched}
   );

var
  f : file of Byte;
  i : word;
  b : byte;

  procedure Abort;
  begin
    WriteLn('Cannot complete patch. Be sure to restore a clean copy of TPC.EXE');
    Halt(1);
  end;

begin
  Assign(f, 'TPC.EXE');
  Reset(f);
  if FileSize(f) <> PatchFileSize then begin
    WriteLn('Unknown version of TPC.EXE');
    Abort;
  end;

  for i := 1 to numpatches do
    with patcharray[i] do begin
      seek(f, P);
      read(f, b);
      if b <> O then
        abort;
      seek(f, P);
      write(f, N);
    end;

  Close(f);
  WriteLn('TPC.EXE 5.5 patched for pointer-dereference interrupts');
end.
