{*****************************************************************************
 This unit lets a program take control of the standard operations for New,
 GetMem, Dispose, FreeMem from the SYSTEM unit. USE it anywhere in a program's
 USES list. You must call the routine CustomHeapControl in order to grab
 control.

 For further information about this unit, refer to HEAP.DOC.

 Written 7/18/88, Kim Kokkonen, TurboPower Software.
 Compuserve ID 76004,2611
 Released to the public domain.

 Version 1.0
   First release.
 Version 5.0
   For consistency with 5.0 release of other heap utilities.
 Version 5.5, 1/6/90
   Updated for Turbo Pascal 5.5
*****************************************************************************}

{$R-,S-,B-,F-}

unit GrabHeap;

interface

type
  GetMemFunc = function(Size : Word) : pointer;
  FreeMemProc = procedure(P : Pointer; Size : Word);

procedure CustomHeapControl(GetPtr : GetMemFunc; FreePtr : FreeMemProc);
  {-Give control of GetMem, New, FreeMem, Dispose to specified procedures}

procedure SystemHeapControl;
  {-Restore control to the system heap routines}

  {===============================================================}

implementation

type
  Xfer = record
           Instr : Byte;
           Addr : Pointer;
         end;
var
  P : ^Byte;
  GetMemPtr : ^Xfer;
  FreeMemPtr : ^Xfer;
  GetSave : Xfer;
  FreeSave : Xfer;

  procedure CustomHeapControl(GetPtr : GetMemFunc; FreePtr : FreeMemProc);
  var
    X : Xfer;
  begin
    with X do begin
      Instr := $EA;               {JMP FAR}
      Addr := @GetPtr;
      GetMemPtr^ := X;
      Addr := @FreePtr;
      FreeMemPtr^ := X;
    end;
  end;

  procedure SystemHeapControl;
  begin
    GetMemPtr^ := GetSave;
    FreeMemPtr^ := FreeSave;
  end;

  function FindCsPtr(N : Word) : Pointer;
    {-Return pointer in code segment N bytes before macro call}
  inline
  ($E8/$00/$00/                   {  call next}
   $5F/                           {next:  pop  di}
   $0E/                           {  push cs}
   $07/                           {  pop  es}
   $58/                           {  pop  ax}
   $83/$EF/$07/                   {  sub  di,7}
   $29/$C7/                       {  sub  di,ax}
   $26/$C4/$05/                   {  les  ax,es:[di]}
   $8C/$C2);                      {  mov  dx,es}

begin
  {Find GetMem and FreeMem in SYSTEM}
  New(P);
  GetMemPtr := FindCsPtr(11);
  Dispose(P);
  FreeMemPtr := FindCsPtr(4);
  {Save the first 5 bytes of each routine, which will be overwritten}
  GetSave := GetMemPtr^;
  FreeSave := FreeMemPtr^;
end.
