{

Program to show application of MemCheck. Compile with debug info enabled
if you want the InstallPMD to have any effect.

}


{$X+}
program TestMem;

uses {$IFDEF Windows}
     WinCrt,
     {$ENDIF}
     BBError,
     ObjMemory,
     PMD, MemCheck;

var
  p : pointer;
  c : char;

procedure DisposeBug;
begin
  FreeMem(p, 200);
end;

procedure OverwriteBug;
begin
  PChar(p)[100] := #0;
  FreeMem(p, 100);
end;


begin
  InitBBError('TESTMEM.LOG', TRUE);
  InitObjMemory;
  InitPMD(dfStandard);
  GetMem(p, 100);
  writeln('1. Dispose other size than allocated.');
  writeln('2. Write into memory after allocated memory block.');
  writeln('3. Allocated, but not deallocated -> see ', ReportFileName, '.');
  writeln('X. Exit');
  writeln;
  write('Type 1, 2, 3 or X and press ENTER => ');
  read(c);
  case c of
    '1' : DisposeBug;
    '2' : OverwriteBug;
    '3' : MemCheckReport;
  end;
end.
