{$R+,S+}
{$M $2000,0,0}
Program P5Stat;

Uses
  P5, Dos, ExecPath, MyDos, Cpu_Unit;

Procedure Syntax;
begin
  WriteLn('Pentium Statistics V1.0 (C) 1994 Terje W Mathisen');
  WriteLn('Usage: P5Stat [option] command_to_execute [command_params]');
  Halt(1);
end;

var
  pcnt, p, res : Word;
  cmd, opt : String;

  msr11, msr12, msr13, zero, time : Int64;
  stab, ctab : array [StatReg] of LongInt;
  dual : Boolean;

begin
  pcnt := ParamCount;
  if pcnt = 0 then Syntax;

  if Ord(CPU_TYPE) < Ord(Pentium) then begin
    WriteLn('Must have Pentium or later CPU!');
    Halt(1);
  end;

  dual := false;
  p := 1;
  while (p <= pcnt) do begin
    cmd := ParamStr(p);
    Inc(p);
    UpcaseStr(cmd);
    if (cmd[1] <> '/') and (cmd[1] <> '-') then Break;
    Delete(cmd,1,1);
    if Pos(cmd,'VERBOSE') = 1 then
      dual := True
    else
      Syntax;
  end;

  cmd := FindInPath(cmd);

  opt := ParamStr(p); Inc(p);
  while p <= pcnt do begin
    opt := opt + ParamStr(p);
    Inc(p);
  end;

  WriteLn('Testing program (to fill caches):');
  Flush(output);
  Exec(cmd, opt);
  res := DosError;
  if res <> 0 then begin
    WriteLn('DosError = ',res);
    Halt(res);
  end;
  res := DosExitCode;
  if res <> 0 then begin
    WriteLn('DosExitCode = ',res);
    Halt(res);
  end;

  SwapVectors;
  p := 0;
  msr11.h := 0;
  zero.h := 0; zero.l := 0;
  FillChar(stab,SizeOf(stab),#0);
  FillChar(ctab,SizeOf(ctab),#0);

  repeat
    if dual then
      msr11.l := $1C000C0 + StatRegNr[p] + LongInt(StatRegNr[p]) Shl 16
    else
      msr11.l := $C000C0 + StatRegNr[p] + LongInt(StatRegNr[p+1]) Shl 16;
    WRMSR($10,zero);
    WRMSR($11,msr11);
    WRMSR($12,zero);
    WRMSR($13,zero);
    Exec(cmd, opt);
    RDMSR($12,msr12);
    RDMSR($13,msr13);
    RDTSC(time);

    stab[p] := msr12.l;
    if dual then begin
      ctab[p] := msr13.l;
      Inc(p);
    end
    else begin
      stab[p+1] := msr13.l;
      Inc(p,2);
    end;
  until p > 37;
  SwapVectors;

  WriteLn;
  WriteLn('Pentium statistics for');
  WriteLn(cmd,' ',opt);

  for p := 0 to 37 do
    if dual then begin
      if stab[p] <> 0 then
        WriteLn(FmtNr(stab[p], 12, ','),1.0*ctab[p] / stab[p]:10:1,
                ' ',StatName[p])
      else
        WriteLn(FmtNr(stab[p], 12, ','),'':10,
                ' ',StatName[p]);
    end
    else
      WriteLn(FmtNr(stab[p], 12, ','),' ',StatName[p]);

  WriteLn(FmtNr(time.l, 12,','),' Clocks');
end.
