{$R-,S-}
Unit P5;

Interface

type
  Int64 = record
    l, h : LongInt;
  end;

  StatReg = 0..37;

const
 StatRegNr : array [StatReg] of byte = (
   0,1,2,3,4,5,6,7,8,9,$A,$B,$C,$D,$E,$F,
   $12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F,
   $22,$23,$24,$25,$26,$27,$28,$29);

  StatName : Array [StatReg] of String[40] = (
 'Data Read',
 'Data Write',
 'Data TLB Miss',
 'Data Read Miss',
 'Data Write Miss',
 'Write (hit) to M or E state lines',
 'Data Cache Lines Written Back',
 'Data Cache Snoops',
 'Data Cache Snoop Hits',
 'Memory Accesses In Both Pipes',
 'Bank Conflicts',
 'Misaligned Data Memory References',
 'Code Read',
 'Code TLB Miss',
 'Code Cache Miss',
 'Any Segment Register Load',

 'Branches',
 'BTB Hits',
 'Taken Branch or BTB Hit',
 'Pipeline Flushes',
 'Instructions Executed',
 'Instructions Executed in the v-pipe',
 'Bus Utilization (clocks)',
 'Pipeline Stalled by Write Backup',
 'Pipeline Stalled by Data Mem Read',
 'Pipeline Stalled by write to E or M line',
 'Locked Bus Cycle',
 'I/O Read or Write Cycle',
 'Non-cacheable memory references',
 'AGI (Address Generation Interlock)',

 'Floating Point Operations',
 'Breakpoint 0 Match',
 'Breakpoint 1 Match',
 'Breakpoint 2 Match',
 'Breakpoint 3 Match',
 'Hardware Interrupts',
 'Data Read or Data Write',
 'Data Read Miss or Data Write Miss');
{ 'Clocks', }


Procedure WRMSR(reg: word; var ts : Int64);
Procedure RDTSC(var ts : Int64);
Procedure RDMSR(reg: word; var ts : Int64);

Implementation

Procedure WRMSR(reg: word; var ts : Int64);
Assembler;
asm
  les di,[ts]
  db 66h; xor cx,cx
  mov cx,[reg]
  db 66h; mov ax,es:[di]
  db 66h; mov dx,es:[di+4]
  db 0fh,30h
end;

Procedure RDTSC(var ts : Int64);
Assembler;
asm
  les di,[ts]
  db 0fh,31h
  db 66h; mov es:[di],ax
  db 66h; mov es:[di+4],dx
end;

Procedure RDMSR(reg: word; var ts : Int64);
Assembler;
asm
  les di,[ts]
  db 66h; xor cx,cx
  mov cx,[reg]
  db 0fh,32h
  db 66h; mov es:[di],ax
  db 66h; mov es:[di+4],dx
end;

begin
end.
