        .MODEL TPASCAL

        .DATA

EXTRN   CPU_TYPE:BYTE
EXTRN   NDP_TYPE:BYTE

CW      DW      ?

        .CODE

        public  GetCpuAndNdp
GetCpuAndNdp   proc near

        pushf                           ; Save all CPU flags

        mov     bl,6                    ; assume 286
        xor     ax,ax
        push    ax
        popf
        pushf
        pop     ax
        and     ah,0f0h
        cmp     ah,0f0h
         je     testprefetch            ; before 286

        mov     ah,0f0h 
        push    ax
        popf
        pushf
        pop     ax
        and     ah,0f0h

        .486
         jz     cpudone                 ; its a 286
        inc     bx                      ; its a 386 or 486!
;
; *************** Her kommer kode for 486! *******************
;
if 0
        mov     si, offset myint6
        mov     di, cs
        mov     cx,1
        call    swap                    ; Returns with CLI
        and     esp,0FFFFh              ; To be able to use ESP safely!
        xadd    dx,dx
        call    swap
        sti                             ; Let's open up external int's again
         jcxz   cpudone                 ; must be a 386 -> No XADD opcode!
        inc     bx
         jmp    short cpudone
else
        push    bp
        mov     bp,sp
        and     sp,not 3                ; ALIGN 4 the stack for AC
        pushfd

        pushfd
        pop     eax
        mov     ecx, eax
        xor     eax,40000h
        push    eax
        popfd
        pushfd
        pop     eax

        popfd
        mov     sp,bp
        pop     bp
        xor     eax,ecx
         jz     cpudone
        inc     bx                      ; Must be 486+, have AC bit!

;
; Check for Pentium!
;
        pushfd

        pushfd
        pop     eax
        mov     ecx, eax
        xor     eax,200000h             ; CPUID available bit
        push    eax
        popfd
        pushfd
        pop     eax

        popfd
        xor     eax,ecx
         jz     cpudone

        xor     eax,eax
        push    bx
        db      0Fh, 0A2h               ; CPUID opcode
        pop     bx
        test    eax,eax
         jz     cpudone

        mov     eax,1
        push    bx
        db      0Fh, 0A2h               ; CPUID opcode
        pop     bx
        mov     al,ah
        and     al,15
        sub     al,4
        add     bl,al
        jmp     cpudone
endif
        .8086

testprefetch:
        std
        push    cs
        pop     es
        mov     di, offset laststi
        mov     cx,4
        mov     byte ptr es:[di-3],43h  ; INC BX opcode
        mov     ax,0fbh                 ; STI opcode
        mov     si,01234h
        cli
         jmp    $+2
        mul     si
        div     si
    rep stosb
        nop
        nop
        nop
        nop
        inc     bx                      ; Odd bx -> 86,186 or V30
        sti
        sti
laststi:
        sti
        sub     bl,2                    ; assume 186
        mov     al,0ffh
        mov     cl,33                   ; 186/188 uses (ShiftCount AND 31)
        shl     al,cl
         jnz    cpudone
        sub     bl,2  ; assume NEC V20
        mov     cx,0FFFFh               ; Do for a LONG time
;        sti                             ; Make sure we get a timer int
    rep lods    byte ptr es:[si]
         jcxz   cpudone                 ; OK, so NEC V20/V30
        sub     bl,2                    ; default -> 8088/8086

cpudone:                                ; Common end for CPU testing code
        mov     [cpu_type],bl

        popf                            ; Restore cpu flags

;        mov     dl,4
;        cmp     bl,8
;         jae    ndpdone

        fninit
        xor     dx,dx                   ; DL = (NO87, 8087, 287, 387, 487)
        mov     bx,offset cw
        mov     [bx],dx
        fnstcw  [bx]
         jmp    $+2                     ; Wait for result
         jmp    $+2                     ; Wait for result
        cmp     byte ptr [bx+1],03
         jne    ndpdone                 ; NO 87 installed

        fdisi                           ; 8087 Disable interrupts
        fstcw   [bx]
        inc     dx                      ; At least 8087
        fwait                           ;  Wait for result from FSTCW
        test    byte ptr [bx],80h       ; DISI bit set?
         jnz    ndpdone                 ; Yes, it's a 8087

        .286
        .287
        inc    dx                       ; 80287 or 80387
        fld1
        fldz
        fdivp   st(1),st                ; 1/0 = +Inf
        fld     st(0)
        fchs                            ; = -Inf
        fcompp
        fwait                           ; Wait for result
        fstsw   ax
        sahf                            ; Status from float point cmp
         je     ndpdone                 ; +Inf == -Inf => 287
        inc     dx                      ; 387
        .8086
        .8087
ndpdone:
        mov    [ndp_type],dl

        ret

GetCpuAndNdp endp

if 0

swap    proc    near uses ds            ; Swap DI:SI with INT6
        xor     ax,ax
        mov     ds,ax
        cli
        xchg    si,[ds:6*4]
        xchg    di,[ds:6*4+2]
        ret                             ; Return with CLI
swap    endp

;-----------------------------------------------------------------------------  
; INT6 handler resets a semaphore (CX=0) and adjusts the return address to     
; point past the invalid opcode.                                                
;-----------------------------------------------------------------------------  
myint6  proc    far
        dec     cx                      ; make CX=0                          
        .386
        add     word ptr [esp],3        ; point IP past invalid opcode
        iret
myint6  endp

endif

        END
