PROGRAM SqzPas;
{+H
---------------------------------------------------------------------------
  File        - SQZPAS.PAS

  Copyright   - None. Public Domain.

  Author      - Keith S. Brown (except where otherwise noted)
                713-483-8952
                Surface mail:              Email:(brownk@samnet.jsc.nasa.gov)
                  K.Brown
                  Code:NASA/JSC/ES64
                  Houston, TX 77058 (USA)  Voice:(713)483-8952

  Purpose     - Compact a pascal source file by removing all comments, extra
                spaces, control characters, etc.

  Requires    - KBlkRead.

  Revised     - 1993.0914 (KSB) Wrote initial version.
---------------------------------------------------------------------------}
USES
  KBlkRead;


TYPE
  oBuf   = OBJECT(oBuffer)
    finished  : BOOLEAN;
    line      : STRING;
    maxLen    : BYTE;

    CONSTRUCTOR Init;
    DESTRUCTOR  Done; VIRTUAL;
    PROCEDURE   OutOfText; VIRTUAL;
    PROCEDURE   Process;
  END {OBJECT};




{}CONSTRUCTOR oBuf.Init;
  VAR
    s    : STRING;
    L    : BYTE ABSOLUTE s;
    i,j  : WORD;

{}{}FUNCTION GetVal(s:STRING):INTEGER;
    VAR
      k  : INTEGER;
    BEGIN
      s := Copy(s,2,L);
      Val(s,j,k);
      IF k = 0 THEN
        GetVal := j
      ELSE
        GetVal := 0;
{}{}END {GetVal};


  BEGIN
    finished := FALSE;
    maxLen   := 127;
    line := '';

    IF ParamCount > 1 THEN BEGIN
      FOR i := 2 TO ParamCount DO BEGIN
        s := ParamStr(i);
        IF s[1] IN ['/','-'] THEN BEGIN
          s := Copy(s,2,L);

          IF (L > 1) THEN
            CASE UpCase(s[1]) OF
              'L' :
              BEGIN
                j := GetVal(s);
                IF j = 0 THEN
                  j := 127
                ELSE
                IF j > 255 THEN
                  j := 255
                ELSE
                IF j < 40 THEN
                  j := 40;

                maxLen := j;
              END {BEGIN};
            END {CASE};

        END {IF};
      END {FOR};
    END {IF};

  IF NOT oBuffer.Init THEN
    Fail;
{}END {Init};




{}DESTRUCTOR oBuf.Done;
  BEGIN
    oBuffer.Done;
{}END {Done};




{}PROCEDURE oBuf.OutOfText;
  BEGIN
    finished := TRUE;
{}END {OutOfText};




{}PROCEDURE oBuf.Process;

{}{}PROCEDURE TrimLineEnd;
    CONST
      delimit : SET OF CHAR  = ['('..'-',':'..'>','['..']','}',#39];
    VAR
      L  : BYTE ABSOLUTE line;
    BEGIN
      IF (L>1) AND (line[L]=' ') AND (line[L-1] IN delimit) THEN
        Dec(L);
{}{}END {TrimLineEnd};


{}{}PROCEDURE DoCmnt1;
    VAR
      c  : CHAR;
    BEGIN
      REPEAT
        c := GetNextChar;
      UNTIL c = '}';
{}{}END {DoCmnt1};


{}{}PROCEDURE DoCmnt2;
    VAR
      c  : CHAR;
      isDone  : BOOLEAN;
    BEGIN
      c := GetNextChar;  {removes '('}
      c := GetNextChar;  {removes '*'}

      REPEAT
        c := GetNextChar;
        isDone := c = '*';
        IF isDone THEN BEGIN
          c := GetNextChar;
          isDone := c = ')';
        END {IF};
      UNTIL isDone;
{}{}END {DoCmnt2};


{}{}PROCEDURE DoQuote;
    VAR
      c  : CHAR;
      s  : STRING;
    BEGIN
      s := '';
      c := GetNextChar;
      WHILE c = #39 DO BEGIN
        s := s + c;
        c := GetNextChar;
      END {WHILE};

      IF Odd(Length(s)) THEN BEGIN
        WHILE c <> #39 DO BEGIN
          s := s + c;
          c := GetNextChar;
        END {WHILE};
        s := s + c;
      END ELSE
        PushBack(c);

      TrimLineEnd;

      IF WORD(Length(line)) + WORD(Length(s)) < MAXLEN THEN
        line := line + s
      ELSE BEGIN
        WriteLn(line);
        line := s;
      END {IF};
{}{}END {DoQuote};


{}{}PROCEDURE DoSymbol;
    VAR
      s  : STRING;
      c  : CHAR;
      L  : BYTE ABSOLUTE line;
    BEGIN
      s := '';
      c := GetNextChar;
      WHILE UpCase(c) IN ['_','A'..'Z','0'..'9'] DO BEGIN
        s := s + c;
        c := GetNextChar;
      END {WHILE};
      PushBack(c);

      TrimLineEnd;

      IF WORD(Length(line)) + WORD(Length(s)) < MAXLEN THEN BEGIN
        IF UpCase(line[L]) IN ['A'..'Z','_','0'..'9'] THEN
          line := line + ' ';

        line := line + s
      END ELSE BEGIN
        WriteLn(line);
        line := s;
      END {IF};
{}{}END {DoSymbol};


{}{}PROCEDURE SqzSpace;
    VAR
      L  : BYTE ABSOLUTE line;
      c  : CHAR;
    BEGIN
      c := GetNextChar;
      IF L = MAXLEN THEN BEGIN
        WriteLn(line);
        line := '';
      END {IF};

      CASE c OF
        ' ' :
        IF (L>0) AND (line[L] <> ' ') THEN
          line := line + c;

        #0..#31 :;

        ELSE
          line := line + c;
      END {CASE};
{}{}END {SqzSpace};


{}{}PROCEDURE SqzChar(c:CHAR);
    VAR
      L  : BYTE ABSOLUTE line;
    BEGIN
      IF (L>0) AND (line[L] = ' ') THEN
        Dec(L);

      IF L < (MAXLEN-2) THEN
        line := line + c
      ELSE BEGIN
        WriteLn(line);
        line := c;
      END {IF};
{}{}END {SqzChar};


  VAR
    c    : CHAR;
  BEGIN
    WHILE NOT finished DO BEGIN
      c := GetNextChar;

      CASE UpCase(c) OF
        '{' :
        BEGIN
          PushBack(c);
          DoCmnt1;
        END {BEGIN};

        '(' :
        BEGIN
          c := GetNextChar;
          IF c = '*' THEN BEGIN
            PushBack('(*');
            DoCmnt2;
          END ELSE BEGIN
            SqzChar('(');
            PushBack(c);
          END {BEGIN};
        END {BEGIN};

        #39 :
        BEGIN
          PushBack(c);
          DoQuote;
        END {BEGIN};

        #00..#32 :
        BEGIN
          PushBack(c);
          SqzSpace;
        END {BEGIN};


        '_','A'..'Z','0'..'9':
        BEGIN
          PushBack(c);
          DoSymbol;
        END {BEGIN};

        ELSE
          SqzChar(c);

      END {CASE};
    END {WHILE};
    IF Length(line) > 0 THEN
      WriteLn(line);
{}END {Process};




VAR
  src    : oBuf;

BEGIN
  src.Init;
  IF src.OpenSource(ParamStr(1)) THEN
    src.Process
  ELSE BEGIN
    WriteLn('SQZPAS');
    WriteLn;
    WriteLn('Purpose:');
    WriteLn('  Compact Pascal source code.');
    WriteLn;
    WriteLn('Usage:');
    WriteLn('  SQZPAS file.pas > target        -- squeeze to 127 char/line');
    WriteLn('  SQZPAS file.pas /80 > target    -- squeeze to  80 char/line');
  END {IF};
END {BEGIN}.
