unit keyboard;

interface
         const
              TabKey = 9;
              ReturnKey = 13;
              EscKey = 27;
              DownKey = 10;
              UpKey = 11;
              LeftKey = 8;
              RightKey = 21;
              SpaceKey = 32;
              DelLeftKey = 127;
              NumericKey = $800;
              ShiftKey = $400;
              CtrlKey = $200;
              AltKey = $100;
              F1key = ord ('A') - 1 + NumericKey;
              F2key = ord ('A') + NumericKey;
              F3key = ord ('B') + NumericKey;
              F4key = ord ('C') + NumericKey;
              F5key = ord ('D') + NumericKey;
              F6key = ord ('E') + NumericKey;
              F7key = ord ('F') + NumericKey;
              F8key = ord ('G') + NumericKey;
              F9key = ord ('H') + NumericKey;
              F10key = ord ('I') + NumericKey;
              F11key = ord ('J') + NumericKey;
              F12key = ord ('K') + NumericKey;
              F13key = ord ('L') + NumericKey; {installed for expansion only}
              F14key = ord ('M') + NumericKey; {installed for expansion only}
              F15key = ord ('N') + NumericKey; {installed for expansion only}
              PageUpKey = ord ('a') - 1 + NumericKey;
              PageDnKey = ord ('a') + NumericKey;
              HomeKey = ord ('b') + NumericKey;
              EndKey = ord ('c') + NumericKey;
              InsKey = ord ('d') + NumericKey;
              DelRightKey = 127 + NumericKey;

         type
             BoardOfKeys = object
                                 function KeyPressed : boolean;
                                 function Read : word;
                                 procedure ClearBuffer;
                           end;

         var
            KeyInput : BoardOfKeys;


{****************************************************************************}
{****************************************************************************}

implementation

uses
    dos;

var
   Extended, ShiftStat, ControlStat, AltStat, CapsStat, NumericStat : boolean;
   regs : registers;
   HoldKey : word;

{****************************************************************************}

procedure translate;

var
   ScanCode, AsciiCode : byte;

begin
ScanCode := hi (HoldKey);
AsciiCode := lo (HoldKey);
regs.ah := 2;
intr ($16, regs);
with regs do
     begin
     ShiftStat := al and 3 > 0;
     ControlStat := al and 4 > 0;
     AltStat := al and 8 > 0;
     CapsStat := al and 64 > 0;
     NumericStat := al and 32 > 0;
     end;
if AsciiCode > 0 then
   begin
   if (AsciiCode = 8) and (ScanCode = $0e) then
      AsciiCode := 127;
   if (AsciiCode < 32) and not (AsciiCode in [10, 13, 9, 27]) or (AsciiCode in
                 [13, 9, 27]) and not (ScanCode in [$e0, $1, $f, $1c]) then
      inc (AsciiCode, 64);
   if AsciiCode = 10 then
      AsciiCode := 13;
   HoldKey := AsciiCode + ord ((AsciiCode < 33) or (AsciiCode = 127)) * ord
           (ShiftStat) * ShiftKey + ord (ControlStat) * CtrlKey + ord
           (AltStat) * AltKey + ord (ScanCode in [$47..$53, $e0, $37]) *
           NumericKey;
   if AsciiCode = 224 then
      begin
      case ScanCode of
           $47 : HoldKey := HomeKey or hi (HoldKey) * 256;
           $48 : HoldKey := UpKey or hi (HoldKey) * 256 and not NumericKey;
           $49 : HoldKey := PageUpKey or hi (HoldKey) * 256;
           $4b : HoldKey := LeftKey or hi (HoldKey) * 256 and not NumericKey;
           $4d : HoldKey := RightKey or hi (HoldKey) * 256 and not NumericKey;
           $4f : HoldKey := EndKey or hi (HoldKey) * 256;
           $50 : HoldKey := DownKey or hi (HoldKey) * 256 and not NumericKey;
           $51 : HoldKey := PageDnKey or hi (HoldKey) * 256;
           $52 : HoldKey := InsKey or hi (HoldKey) * 256;
           $53 : HoldKey := DelRightKey or hi (HoldKey) * 256;
           end;
      HoldKey := HoldKey or (ord (ShiftStat) * ShiftKey);
      end;
   end
else
    begin
    case ScanCode of
         $3b..$44 : HoldKey := F1key + ScanCode - $3b + ord (ShiftStat) *
                            ShiftKey;
         $54..$5d : HoldKey := F1key + ScanCode - $54 + ShiftKey;
         $5e..$67 : HoldKey := F1key + ScanCode - $5e + ord (ShiftStat) *
                            ShiftKey;
         $68..$71 : HoldKey := F1key + ScanCode - $68 + ord (ShiftStat) *
                            ShiftKey;
         $97, $77, $47 : HoldKey := HomeKey + ord (ShiftStat) * ShiftKey;
         $98, $8d, $48 : HoldKey := UpKey + ord (ShiftStat) * ShiftKey;
         $99, $84, $49 : HoldKey := PageUpKey + ord (ShiftStat) * ShiftKey;
         $8e, $4a : HoldKey := ord ('-') + NumericKey + ord (ShiftStat) *
               ShiftKey;
         $9b, $73, $4b : HoldKey := LeftKey + ord (ShiftStat) * ShiftKey;
         $8f, $4c : HoldKey := ord ('5') + NumericKey + ord (ShiftStat) *
                            ShiftKey;
         $9d, $74, $4d : HoldKey := RightKey + ord (ShiftStat) * ShiftKey;
         $90, $4e : HoldKey := ord ('+') + NumericKey + ord (ShiftStat) *
                            ShiftKey;
         $9f, $75, $4f : HoldKey := EndKey + ord (ShiftStat) * ShiftKey;
         $a0, $91, $50 : HoldKey := DownKey + ord (ShiftStat) * ShiftKey;
         $a1, $76, $51 : HoldKey := PageDnKey + ord (ShiftStat) * ShiftKey;
         $5, $a2, $4, $52 : HoldKey := InsKey + ord (ShiftStat) * ShiftKey;
         $7, $6, $a3, $53 : HoldKey := DelRightKey + ord (ShiftStat) * ShiftKey;
         $85, $87, $89, $8b : HoldKey := F11key + ord (ShiftStat) * ShiftKey;
         $86, $88, $8a, $8c : HoldKey := F12key + ord (ShiftStat) * ShiftKey;
         $1 : HoldKey := EscKey + ord (ShiftStat) * ShiftKey;
         $78..$80 : HoldKey := ord ('1') + ScanCode - $78;
         $b : HoldKey := ord ('0');
         $82, $c : HoldKey := ord ('-');
         $83, $d : HoldKey := ord ('=');
         $1e : HoldKey := ord ('A');
         $1f : HoldKey := ord ('S');
         $20 : HoldKey := ord ('D');
         $21 : HoldKey := ord ('F');
         $22 : HoldKey := ord ('G');
         $23 : HoldKey := ord ('H');
         $24 : HoldKey := ord ('J');
         $25 : HoldKey := ord ('K');
         $26 : HoldKey := ord ('L');
         $27 : HoldKey := ord (';');
         $28 : HoldKey := ord ('''');
         $29 : HoldKey := ord ('`');
         $39 : HoldKey := SpaceKey + ord (ShiftStat) * ShiftKey;
         $f, $94, $a5 : HoldKey := TabKey + ord (ShiftStat) * ShiftKey;
         $10 : HoldKey := ord ('Q');
         $11 : HoldKey := ord ('W');
         $12 : HoldKey := ord ('E');
         $13 : HoldKey := ord ('R');
         $14 : HoldKey := ord ('T');
         $15 : HoldKey := ord ('Y');
         $16 : HoldKey := ord ('U');
         $17 : HoldKey := ord ('I');
         $18 : HoldKey := ord ('O');
         $19 : HoldKey := ord ('P');
         $1a : HoldKey := ord ('[');
         $1b : HoldKey := ord (']');
         $a6, $1c : HoldKey := ReturnKey + ord (ShiftStat) * ShiftKey +
                            NumericKey;
         $2b : HoldKey := ord ('\');
         $2c : HoldKey := ord ('Z');
         $2d : HoldKey := ord ('X');
         $2e : HoldKey := ord ('C');
         $2f : HoldKey := ord ('V');
         $30 : HoldKey := ord ('B');
         $31 : HoldKey := ord ('N');
         $32 : HoldKey := ord ('M');
         $33 : HoldKey := ord (',');
         $34 : HoldKey := ord ('.');
         $35 : HoldKey := ord ('/');
         $a4, $95 : HoldKey := ord ('/') + NumericKey;
         $37, $96 : HoldKey := ord ('*') + NumericKey;
         end;
    HoldKey := HoldKey or (ord (ControlStat) * CtrlKey + ord (AltStat) *
            AltKey);
    end;
end;

{****************************************************************************}

function BoardOfKeys.KeyPressed : boolean;

begin
if HoldKey = 0 then
   begin
   regs.ah := 1 + ord (extended) * 16;
   intr ($16, regs);
   with regs do
        begin
        KeyPressed := (flags and fZero) = 0;
        if (flags and fZero) = 0 then
           begin
           ah := ord (extended) * 16;
           intr ($16, regs);
           HoldKey := ax;
           translate;
           end;
        end;
   end
else
    KeyPressed := true;
end;

{****************************************************************************}

function BoardOfKeys.Read : word;

begin
while not KeyPressed do
      ;
Read := HoldKey;
HoldKey := 0;
end;

{****************************************************************************}

procedure BoardOfKeys.ClearBuffer;

begin
while KeyPressed do
      Read;
HoldKey := 0;
end;

{****************************************************************************}

begin
ShiftStat := false;
HoldKey := 0;
repeat
      regs.ah := 5;
      regs.cx := $ffff;
      intr ($16, regs);
      regs.ah := 16;
      intr ($16, regs);
      Extended := regs.ax = $ffff;
      ShiftStat := Extended or (HoldKey = 15) or (regs.al = 1);
      inc (HoldKey);
until ShiftStat;
HoldKey := 0;
regs.ah := 2;
intr ($16, regs);
with regs do
     begin
     ShiftStat := al and 3 > 0;
     ControlStat := al and 4 > 0;
     AltStat := al and 8 > 0;
     CapsStat := al and 64 > 0;
     NumericStat := al and 32 > 0;
     end;
end.