(*
  This is a brief example program to demonstrate the use of
  SerialClass and InterruptClass classes.
*)

PROGRAM Terminal;


USES

  CRT,
  Hex,
  Error,
  Keyboard,
  Consts,
  Regs,
  StrIO,
  SerialIO;


VAR

  ch            : Char;
  com           : Byte;
  irq           : Byte;
  base          : Word;
  exit_terminal : Boolean;


PROCEDURE Init;
BEGIN
  IF ParamCount < 3 THEN
    PrintError('Usage: TERMINAL port irq base', fatal);
  com := Str2Int(ParamStr(1));
  irq := Str2Int(ParamStr(2));
  base := HexToDec(ParamStr(3));
  exit_terminal := FALSE;
  IF (com > MAX_PORTS) OR (irq > MAX_IRQS) THEN
    Halt;
  New(sio[com], AllocatePort(base,
                             SPEED_57600,
                             DATA_BITS_8,
                             PARITY_NONE,
                             STOP_BITS_1,
                             FIFO_14,
                             FLOW_RTS_CTS,
                             IER_ERDAI + IER_ETHREI + IER_ERLSI + IER_EMST,
                             2048,
                             2048));
  IF error_alarm THEN
    Halt;
  New(irqs[irq], InstallInterruptHandler(irq, interrupt_vector));
  IF error_alarm THEN
    Halt;
  irqs[irq]^.AddService(com);
  (*
    AllocatePort enables automatically interrupts from UART.
    After enabling interrupts from PIC (EnableIRQ) the interrupts
    will really be ENABLED.
  *)
  irqs[irq]^.EnableIRQ;
END; (* Init *)

PROCEDURE CheckExtended;
VAR
  ch    : Char;

BEGIN
  ch := ReadKey;
  CASE ch OF
    ALT_X       : exit_terminal := TRUE;
    ALT_S       : sio[com]^.SetRTS(FALSE);
    ALT_Q       : sio[com]^.SetRTS(TRUE);
  END; (* CASE *)
END; (* CheckExtended *)

BEGIN
  Init;
  REPEAT
    IF KeyPressed THEN
      BEGIN
        ch := ReadKey;
        IF ch = NUL THEN
          CheckExtended
        ELSE
          IF NOT sio[com]^.output_buffer.OverflowDanger THEN
            sio[com]^.WriteChar(ch);
      END (* IF *)
    ELSE
      IF sio[com]^.input_buffer.CharAvailable THEN
        Write(sio[com]^.input_buffer.ReadChar);
  UNTIL exit_terminal;
END. (* Terminal *)

