(*
  This example program redirects input from port A to port B and
  input from port B to port A.
*)

PROGRAM Redir;


USES

  CRT,
  Hex,
  Error,
  Keyboard,
  Consts,
  Regs,
  StrIO,
  SerialIO;


CONST

  USAGE         = 'Usage: REDIR port_a irq_a base_a port_b irq_b base_b';


VAR

  exit_redir            : Boolean;
  port_a, port_b        : Byte;
  irq_a, irq_b          : Byte;
  base_a, base_b        : Word;


PROCEDURE Init;
BEGIN
  IF ParamCount <> 6 THEN
    PrintError(USAGE, fatal);
  port_a  := Str2Int(ParamStr(1));
  irq_a   := Str2Int(ParamStr(2));
  base_a  := HexToDec(ParamStr(3));
  port_b  := Str2Int(ParamStr(4));
  irq_b   := Str2Int(ParamStr(5));
  base_b  := HexToDec(ParamStr(6));
  IF (port_a > MAX_PORTS) OR (port_b > MAX_PORTS) THEN
    PrintError('Invalid port number', fatal);
  IF (irq_a > MAX_IRQS) OR (irq_b > MAX_IRQS) THEN
    PrintError('Invalid irq number', fatal);
  New(sio[port_a], AllocatePort(base_a,
                                SPEED_57600,
                                DATA_BITS_8,
                                PARITY_NONE,
                                STOP_BITS_1,
                                FIFO_14,
                                FLOW_RTS_CTS,
                                IER_ERDAI + IER_ETHREI + IER_ERLSI + IER_EMST,
                                500,
                                500));
  New(sio[port_b], AllocatePort(base_b,
                                SPEED_19200,
                                DATA_BITS_8,
                                PARITY_NONE,
                                STOP_BITS_1,
                                FIFO_14,
                                FLOW_XON_XOFF,
                                IER_ERDAI + IER_ETHREI + IER_ERLSI + IER_EMST,
                                500,
                                500));
  New(irqs[irq_a], InstallInterruptHandler(irq_a, interrupt_vector));
  New(irqs[irq_b], InstallInterruptHandler(irq_b, interrupt_vector));
  IF error_alarm THEN
    Halt;
  irqs[irq_a]^.AddService(port_a);
  irqs[irq_b]^.AddService(port_b);
  (*
    AllocatePort enables automatically interrupts from UART.
    After enabling interrupts from PIC (EnableIRQ) the interrupts
    will really be ENABLED.
  *)
  irqs[irq_a]^.EnableIRQ;
  irqs[irq_b]^.EnableIRQ;
  sio[port_a]^.SetDTR(TRUE);
  sio[port_b]^.SetDTR(TRUE);
  exit_redir := FALSE;
END; (* Init *)

BEGIN
  Init;
  REPEAT
    IF sio[port_a]^.input_buffer.CharAvailable THEN
      IF NOT sio[port_b]^.output_buffer.OverflowDanger THEN
        IF sio[port_b]^.THRE THEN
          sio[port_b]^.SendChar(sio[port_a]^.input_buffer.ReadChar)
        ELSE
          sio[port_b]^.output_buffer.WriteChar(sio[port_a]^.input_buffer.ReadChar);
    IF sio[port_b]^.input_buffer.CharAvailable THEN
      IF NOT sio[port_a]^.output_buffer.OverflowDanger THEN
        IF sio[port_a]^.THRE THEN
          sio[port_a]^.SendChar(sio[port_b]^.input_buffer.ReadChar)
        ELSE
          sio[port_a]^.output_buffer.WriteChar(sio[port_b]^.input_buffer.ReadChar);
    IF KeyPressed THEN
      CASE ReadKey OF
        NUL        : CASE ReadKey OF
                       ALT_X      : exit_redir := TRUE;
                     END; (* CASE *)
      END; (* CASE *)
  UNTIL exit_redir;
  sio[port_a]^.SetDTR(FALSE);
  sio[port_b]^.SetDTR(FALSE);
END. (* Redir *)

