(* ---------------------------------- *)
(* Keyboard                           *)
(* Copyright (c) 1994 by Dado Colussi *)
(* ---------------------------------- *)


UNIT Keyboard;


INTERFACE


CONST

  (* Useful ASCII codes *)

  NUL                 = #0;
  ACK                 = #6;
  BEL                 = #7;
  BS                  = #8;
  HT                  = #9;
  LF                  = #10;
  VT                  = #11;
  FF                  = #12;
  CR                  = #13;
  NAK                 = #21;
  ESC                 = #27;
  SP                  = #32;
  DEL                 = #127;
  NL                  = CR + LF;
  XON                 = ''; (* Ctrl-Q *)
  XOFF                = ''; (* Ctrl-S *)
  
  ON                  = TRUE;
  OFF                 = FALSE;

  (* Alt-keys *)

  ALT_A               = #30;
  ALT_B               = #48;
  ALT_C               = #46;
  ALT_D               = #32;
  ALT_E               = #18;
  ALT_F               = #33;
  ALT_G               = #34;
  ALT_H               = #35;
  ALT_I               = #23;
  ALT_J               = #36;
  ALT_K               = #37;
  ALT_L               = #38;
  ALT_M               = #50;
  ALT_N               = #49;
  ALT_O               = #24;
  ALT_P               = #25;
  ALT_Q               = #16;
  ALT_R               = #19;
  ALT_S               = #31;
  ALT_T               = #20;
  ALT_U               = #22;
  ALT_V               = #47;
  ALT_W               = #17;
  ALT_X               = #45;
  ALT_Y               = #21;
  ALT_Z               = #44;

  (* Function-keys *)

  F1                  = #59;
  F2                  = #60;
  F3                  = #61;
  F4                  = #62;
  F5                  = #63;
  F6                  = #64;
  F7                  = #65;
  F8                  = #66;
  F9                  = #67;
  F10                 = #68;
  F11                 = #133;
  F12                 = #134;

  (* Shift + Function *)

  SHIFT_F1            = #84;
  SHIFT_F2            = #85;
  SHIFT_F3            = #86;
  SHIFT_F4            = #87;
  SHIFT_F5            = #88;
  SHIFT_F6            = #89;
  SHIFT_F7            = #90;
  SHIFT_F8            = #91;
  SHIFT_F9            = #92;
  SHIFT_F10           = #93;
  SHIFT_F11           = #135;
  SHIFT_F12           = #136;

  (* Alt + Function *)

  ALT_F1              = #104;
  ALT_F2              = #105;
  ALT_F3              = #106;
  ALT_F4              = #107;
  ALT_F5              = #108;
  ALT_F6              = #109;
  ALT_F7              = #110;
  ALT_F8              = #111;
  ALT_F9              = #112;
  ALT_F10             = #113;
  ALT_F11             = #139;
  ALT_F12             = #140;

  (* Control + Function *)

  CTRL_F1             = #94;
  CTRL_F2             = #95;
  CTRL_F3             = #96;
  CTRL_F4             = #97;
  CTRL_F5             = #98;
  CTRL_F6             = #99;
  CTRL_F7             = #100;
  CTRL_F8             = #101;
  CTRL_F9             = #102;
  CTRL_F10            = #103;
  CTRL_F11            = #137;
  CTRL_F12            = #138;

  (* Arrow keys *)

  UP_ARROW             = #72;
  DOWN_ARROW           = #80;
  LEFT_ARROW           = #75;
  RIGHT_ARROW          = #77;

  (* Keypad *)

  PGUP                = #73;
  PGDOWN              = #81;
  INS                 = #82;
  EXT_DEL             = #83;
  HOME                = #71;
  EXT_END             = #79;

  (* Control + Keypad *)

  CTRL_PGUP            = #132;
  CTRL_PGDOWN          = #118;
  CTRL_LEFT_ARROW       = #115;
  CTRL_RIGHT_ARROW      = #116;
  CTRL_HOME            = #119;
  CTRL_END             = #117;


IMPLEMENTATION


END. (* Keyboard *)

