; TUBRO Pascal version 4.0   EXTERNAL FUNCTION                 ...red }
; =================================================================== }
; Copyright 1996 Roger E. Donais              <rdonais@southeast.net> }
; May be used freely as long as due credit is given                   }
; ------------------------------------------------------------------- }

; FUNCTION SeekFile(VAR F: Text; Distance: Longint; Direction: Word): Longint;
; { ================================================================= }

        MODEL  Tpascal

        INCLUDE FILEDEFS.ASM

        .CODE

         EXTRN   Limit:FAR

         PUBLIC  SeekFile

LSW = WORD PTR 0
MSW = WORD PTR 2

SeekFile PROC    FAR  FileVar:DWORD, Distance:DWORD, Direction:WORD

         push DS
         mov  DX, [ Distance.LSW ]
         mov  CX, [ Distance.MSW ]
         mov  AX, [ Direction ]
         lds  SI, [ FileVar ]
         mov  BX, [ SI ]
         inc  BX
         jnz  @Dos

         cmp  AX, 1
         jz   @Pos
         js   @Limit         ; from beginning of file CX:DX "as is"

         ; from end of file
         mov   AX, [ TextRec(SI).BufEnd ]
         sub   AX, CX
         mov   CX, AX
         mov   AX, 0
         sbb   AX, DX
         mov   DX, AX
         jmp   @Limit

@Pos:    ; from current position
         add   CX, [ TextRec(SI).BufPos ]
         adc   DX, BX

@Limit:  mov   AX, [ TextRec(SI).BufEnd ]
         pop   DS
         push  BX
         push  BX
         push  DX
         push  CX
         push  BX
         push  AX
         call  Limit
         push  DS
         lds   SI, [ FileVar ]
         mov   [ TextRec(SI).BufPos ], AX
         jmp   @Exit

@Dos:    dec  BX
         xor  DI, DI
         mov  [ TextRec(SI).BufPos ], DI
         mov  [ TextRec(SI).BufEnd ], DI
         mov  AH, 42h
         int  21h
         jnc  @Exit
         or   DX, 80h

@Exit:   pop  DS
         ret

SeekFile ENDP
CODE     ENDS
         END
