UNIT FMEMO; {931227 red}
{ ******************************************************************* }
{ Turbo Pascal - Turbo Vision file memo support unit                  }
{ ------------------------------------------------------------------- }
{ Copyright 1993 Roger E. Donais              <rdonais@southeast.net> }
{ freeware - use at own risk                                          }
{ ------------------------------------------------------------------- }
{-R-}    { Range checking                                             }
{-S-}    { Stack checking                                             }
{$B-}    { Complete Boolean evaluation                                }
{$I+}    { I/O checking                                               }
{$N-}    { Numeric coprocessor                                        }
{$E-}    { 8087 Emulation                                             }
{-O+}    { Overlay compatiblity                                       }
{-D+}    { Dedug                                                      }
{-L+}    { Local label information                                    }
{ ------------------------------------------------------------------- }
INTERFACE

PROCEDURE OpenMemo(VAR DatF: Text; Memo: Pointer);
{ =================================================================== }
{ Prepares text file "f" for variable length record access            }
{ =================================================================== }


FUNCTION SeekMemo(VAR F: Text;  ByteCount, Dir: Word): Word;
{ =================================================================== }
{ Repositions a memo file to the designated byte position relative    }
{ to Direction ( 0==Beginning, 1==Current, 2==End of file)            }
{                                                                     }
{ EXAMPLE:  SeekMemo(F,123);                                          }
{ =================================================================== }


FUNCTION MemoPos(VAR F: Text): Word;
{ =================================================================== }
{ Returns the current position within a memo file.  (e.g. starting    }
{ position of the next character to be read...                        }
{                                                                     }
{ EXAMPLE:  N := MemoPos(F);                                          }
{ =================================================================== }

{ ******************************************************************* }
IMPLEMENTATION
USES DOS, UTIL;

TYPE  tpMemoData = ^trMemoData;
      trMemoData = Record
         Length: Word;
         Buffer: Array[0..65520] of Char;
      End;

      Tf = RECORD                             { Redefines DOS TextRec }
         Handle    : Word;
         Mode      : Word;
         BufSize   : Word;
         Private   : Word;
         BufPos    : Word;
         BufEnd    : Word;
         BufPtr    : tpMemoData;
         OpenFunc  : Pointer;
         InOutFunc : Pointer;
         FlushFunc : Pointer;
         CloseFunc : Pointer;
         Rec       : LongInt;                 { See textfile for use of }
         Unused    : LongInt;                 { Rec, Unused, and Free   }
         Free      : LongInt;
         filler    : Longint;
         Name      : Array[0..79] of Char;
         Buffer    : Array[0..127] of Byte;
      End{Tf};

FUNCTION TDnop(VAR DatF: Text): Integer; {$F-} FAR;
{ =================================================================== }
{                                                                     }
{ =================================================================== }
BEGIN  TDnop := 0;  END;

FUNCTION TDinp(VAR DatF: Text): Integer; FAR;
{ =================================================================== }
{                                                                     }
{ =================================================================== }
BEGIN
    If Tf(DatF).mode <> fmINPUT Then TDinp := 103
    Else Begin
       Tf(DatF).BufPos := 0;
       Tf(DatF).BufEnd := 0;
       TDinp := 0;
    End;
END;

PROCEDURE TDopen(VAR Datf: Text);              FAR;
{ =================================================================== }
{                                                                     }
{ =================================================================== }
BEGIN
    With Tf(DatF) Do Begin
       If Mode <> fmINPUT Then
          RunError(101);
       Name[0] := #0;
       Handle    := $FFFF;
        {\BufPtr    := @Buffer; {}
       OpenFunc  := @TDopen;
       CloseFunc := @TDnop;
       FlushFunc := @TDnop;
       InOutFunc := @TDinp;
       BufSize   := BufPtr^.Length +2;
       BufEnd    := BufSize;
       BufPos    := 2;
    End;
END;


FUNCTION MemoPos(VAR F: Text): Word;
{ =================================================================== }
BEGIN
    MemoPos := Tf(F).BufPos -2;
END;


FUNCTION SeekMemo(VAR F: Text;  ByteCount, Dir: Word): Word;
{ =================================================================== }
VAR i: Integer;
BEGIN
    Case Dir of
       0: i := ByteCount + 2;
       1: i := tf(F).BufPos + ByteCount;
       2: i := Longint(Tf(F).BufPos) - ByteCount;
    End;
    Tf(F).BufPos := Limit(2, i, Tf(F).BufPtr^.Length+2);
END;


PROCEDURE OpenMemo(VAR DatF: Text; Memo: Pointer);
{ =================================================================== }
{ Prepares text file "f" for variable length record access            }
{ =================================================================== }
BEGIN
    Tf(Datf).Mode := fmINPUT;
    Tf(DatF).BufPtr := Memo;
    TDopen(Datf);
END;



END.

