UNIT FILES;
{ ******************************************************************* }
{ Turbo Pascal Version 4.0 -> 7.0 File Functions and Procedures       }
{ ------------------------------------------------------------------- }
{ Copyright 1988, 1995 Roger E. Donais        <rdonais@southeast.net> }
{ ------------------------------------------------------------------- }

(*---comment-out for version 4.0 --->*)
{$IFDEF VER70}
   {$X+}           { Unit uses extended syntax }
   {$DEFINE X}     { allow pChar and extended syntax    }
   {$DEFINE C}     { allow const parameter declarations }
   {$DEFINE STRINGS}
   {$DEFINE BASM}
{$ENDIF}

{$IFDEF VER60}
   {$X+}           { Unit uses extended syntax }
   {$DEFINE X}     { allow pChar and extended syntax    }
   {$DEFINE BASM}
{$ENDIF}
(*<---end version 4.0 comment ---*)

{ ******************************************************************* }
INTERFACE
USES DOS, UTIL
     {$IFDEF VER60}, OBJECTS {$ENDIF}   { pChar }
     {$IFDEF STRINGS}, STRINGS {$ENDIF}
     ;

{$IFDEF VER40}
TYPE PathStr = String[79];
     DirStr  = String[67];
     NameStr = String[8];
     ExtStr  = String[4];

CONST ReadOnly  = $00;
      WriteOnly = $01;
      ReadWrite = $02;
      { Select one from above and optionally one from below }
      DenyAll   = $10;
      DenyWrite = $20;
      DenyRead  = $30;
      DenyNone  = $40;
      {Also may add ...}
      NoInherit = $80;




FUNCTION FSearch(Name, Paths: String): PathStr;
{ ==================================================================== }
{ Searches for file "Name" on DOS type paths string "Paths"            }
{ Returns Path+Name if found, else returns empty string ''             }
{ SEE: DOS Unit Version 5.0 and above                                  }
{ ==================================================================== }

PROCEDURE FSPlit(FileSpec: PathStr; VAR Dir: DirStr; VAR Nam: NameStr; VAR Ext: ExtStr);
{ ==================================================================== }

FUNCTION FExpand(FileSpec: PathStr): PathStr;
{ ==================================================================== }

PROCEDURE RunError(No: Integer);
{ ==================================================================== }
{$ENDIF}

PROCEDURE ChDir(Directory: String);
{ ==================================================================== }
{ Changes current directory (final backslash okay)                     }
{ ==================================================================== }

FUNCTION SwapFile({$IFDEF C}const {$ENDIF} Name: String): String;
{ ==================================================================== }
{ Returns the full spec of TmpPath + Name + GetEnv('STATION') .SWP     }
{ ==================================================================== }

FUNCTION TmpPath: String;
{ ==================================================================== }
{ Returns the work directory (Env: 'TMP' or 'TEMP', Default, or 'C:\'  }
{ ==================================================================== }

FUNCTION ExePath: String;
{ ==================================================================== }
{ Returns the directory containing the program file                    }
{ ==================================================================== }

{$IFNDEF DPMI}
Procedure ExtendPSPFileHandles;
Procedure ExtendFileHandles(Number: Integer);
{ ==================================================================== }
{ ExtendPSPFileHandles moves file table to extened FCB1 and 2          }
{ ExnendFileHandles uses variable in data segment (bombs w/ execswap)  }
{ ==================================================================== }
{$ENDIF}

FUNCTION DriveOf(FileSpec: String): Integer;
{ ==================================================================== }
{ Returns the drive number of a disk file specification (A=1,B=2,etc.) }
{ ==================================================================== }

FUNCTION FileNameOf(FileSpec: String): String;
{ ==================================================================== }
{ Returns the file name portion of a file specification                }
{ ==================================================================== }

FUNCTION FileTypeOf(FileSpec: String): String;
{ ==================================================================== }
{ Returns the file type (extent) portion of a disk file specification  }
{ ==================================================================== }

FUNCTION FullTypeOf(FileSpec: String): String;
{ ==================================================================== }
{ Returns full four character file type (extent) of a file spec        }
{ ==================================================================== }

FUNCTION FullNameOf(FileSpec: String): String;
{ ==================================================================== }
{ Returns file name + extension of the specified DOS file spec         }
{ ==================================================================== }

FUNCTION ShortSpecOf(Spec: String; Len: Integer): String;
{ ==================================================================== }
{ Returns a modified drive:\path\name.ext of a file specification      }
{ suitable for display. e.g.  C:\root\...\sub\files.ext                }
{ ==================================================================== }

FUNCTION FullSpecOf(FileSpec: String): String;
{ ==================================================================== }
{ Returns the full drive:\path\name.ext of a disk file specification   }
{ Function version of FExpand()                                        }
{ ==================================================================== }

FUNCTION FullPathOf(FileSpec: String): String;
{ ==================================================================== }
{ Returns the drive and path portion of a disk file specification      }
{ Includes trailing backslach                                          }
{ ==================================================================== }

FUNCTION FileSpecOf(VAR FileVar): String;
{ ==================================================================== }
{ Returns the assigned name of a file variable                         }
{ ==================================================================== }

FUNCTION FileAttrOf(Spec: String): Integer;
{ ==================================================================== }
{ Returns attributes of the specified DOS file/directory specification }
{ Bit7=1 and Bits 0..6 of the Low Byte contains the attributes for the }
{ FIRST matching entry, Bit15=1 and Bits 8..14 contains the attributes }
{ for the second matching occurance...                                 }
{ ==================================================================== }

FUNCTION Exists(Fname: String): Boolean;
{ =================================================================== }
{  Returns TRUE If the given Fname can be opened, and FALSE otherwise }
{  - Returns FALSE if Fname refers to a device       (e.g Fname = '') }
{ =================================================================== }

Procedure SetBinaryMode(VAR F: Text);
{ =================================================================== }
{ Puts file F into binary mode (e.g. allow reading/writing ^Z)        }
{ =================================================================== }

FUNCTION  IsDevice(VAR F): Boolean;
{ =================================================================== }
{ Returns true If the given TEXT/FILE is a Device                     }
{ =================================================================== }

FUNCTION MapFile(Source, Pattern: String): String; { Name Only }
{ =================================================================== }
{ Returns Source file name applied to a wildcard pattern.             }
{ NOTE: Use "*\" to return source path.  Example:  *\*.$$$            }
{ =================================================================== }

PROCEDURE Erase(VAR F: Text);                                         { Erase Single File }
PROCEDURE EraseFile({$IFDEF C}const{$ENDIF} Spec: String);            { Erase Single File }
PROCEDURE EraseAll(FileSpec: String);                                 { Erase w/Wildcards }
PROCEDURE RemoveScratchDirectory({$IFDEF C}const{$ENDIF} Dir: String);{ Files & Directory }
{ =================================================================== }

FUNCTION  TempFileOf({$IFDEF C}const{$ENDIF} FileSpec: String): String;
{ =================================================================== }
{ Returns '.$$$' file type for specified file spec                    }
{ =================================================================== }

PROCEDURE RollOver({$IFDEF C}const{$ENDIF} FileSpec: String);
{ =================================================================== }
{ Deletes Spec.BAK, then Renames Spec to Spec.Bak & Spec.$$$ to Spec  }
{ =================================================================== }

FUNCTION SeekFile(VAR F: Text; Distance: Longint; Direction: Word): Longint;
{ =================================================================== }
{ Repositions a text file to the designated byte position relative    }
{ to Direction ( 0==Beginning, 1==Current, 2==End of file)            }
{                                                                     }
{ EXAMPLE:  SeekFile(F,123, 0);                                       }
{ =================================================================== }

PROCEDURE SeekText(VAR F: Text; Position: Longint);
{ =================================================================== }
{ Repositions a text file to the designated byte position relative    }
{ to the beginning of the file                                        }
{                                                                     }
{ EXAMPLE:  SeekText(F,123);                                          }
{ =================================================================== }

FUNCTION TextPos(VAR F: Text): Longint;
{ =================================================================== }
{ Returns the current position within a text file.  (e.g. starting    }
{ position of the next character to be read...                        }
{                                                                     }
{ EXAMPLE:  N := TextPos(F);                                          }
{ =================================================================== }

FUNCTION TextSize(VAR F: Text): Longint;
{ =================================================================== }
{ Returns the size of current file w/o changing current file position }
{ =================================================================== }

PROCEDURE TruncateFile(VAR F: Text);
{ =================================================================== }
{ Truncates a text file at current position. (File is flushed first!) }
{ =================================================================== }

PROCEDURE Rewind(VAR F: Text);
{ =================================================================== }
{ Repositions to beginning of a text file.                            }
{ =================================================================== }

PROCEDURE OpenLF(VAR F: Text;{$IFDEF C}const{$ENDIF} FileSpec: String);
{ =================================================================== }
{ Prepares text file "f" to read text file w/lines ending in #10 only }
{ Compatible w/ file procedures such as Reset, SeekFile, TextPos, etc.}
{ <if reading CR-LF delimited lines, every other line will be blank>  }
{ =================================================================== }

PROCEDURE OpenVAR(VAR F: Text; VAR Buf; Size: Integer);
{ =================================================================== }
{ Prepares text file "f" to read variable Buf of Size bytes           }
{ Compatible w/ file procedures such as Reset, SeekFile, TextPos, etc.}
{ =================================================================== }

PROCEDURE OpenString(VAR F: Text; VAR s: String);
{ =================================================================== }
{ Prepares text file "f" to read string "s"                           }
{ Compatible w/ file procedures such as Reset, SeekFile, TextPos, etc.}
{ =================================================================== }

PROCEDURE OpenPChar(VAR F: Text; p: pChar);
{ =================================================================== }
{ Prepares text file "f" to read nul terminated string p^             }
{ Compatible w/ file procedures such as Reset, SeekFile, TextPos, etc.}
{ =================================================================== }

PROCEDURE GetTextBuf(VAR F: Text; BufSize: Word); { Alloc & set buf   }
PROCEDURE FreeTextBuf(VAR F: Text);               { Free & reset buf  }
PROCEDURE ResetTextBuf(VAR F: Text);              { Reset text buffer }
{ =================================================================== }
{ Assign resets the default 128-Byte text file buffer.  To dispose of }
{ a buffer that was allocated on the heap, you don't have to save the }
{ pointer, simply call FreeTextBuf().  To set the text buffer using   }
{ the heap, simply call GetTextBuf().  Use RestTextBuf() when you     }
{ have a buffer that you wish to reclaim to use somewhere else.       }
{ ------------------------------------------------------------------- }
{ It is the callers responsibility to insure that it is safe to       }
{ remove the buffer (e.g. file has been flushed or is closed.   ..red }
{ =================================================================== }


FUNCTION Open(VAR F: Text; Access: Byte): Boolean;
{ =================================================================== }
{ Open text file for input in something other than compatibility mode }
{ e.g.  Open(F, ReadOnly+DenyNone);                                   }
{ ------------------------------------------------------------------- }


PROCEDURE CreateForUpdate(VAR F: Text);{ Creates text file for Read/Write - ready for OUTPUT }
PROCEDURE OpenForUpdate( VAR F: Text); { Open text file for Read/Write    - ready for INPUT  }
PROCEDURE ResetForInput( VAR F: Text); { Change file mode for input   }
PROCEDURE ResetForOutput(VAR F: Text); { Change file mode for output  }
{ =================================================================== }
{ OpenForUpdate positions to start of file ready for input.           }
{ CreateForUpdate positions to start of file ready for output.        }
{ ResetFor.... flushes buffer only if file mode not in desired state. }
{ =================================================================== }

FUNCTION CopyFile(Source, Target: String): Boolean;
{ =================================================================== }
{ Returns TRUE if Source successfully copied to target, else FALSE.   }
{ If MakeBusy is NOT NIL, executes MakeBusy after copying each block  }
{ =================================================================== }

FUNCTION ReadFile(VAR F: Text;  VAR Target; ByteCount: Word): Word;
{ =================================================================== }
{ Read the specified number of bytes from a text file.                }
{ NOTE: The number of bytes read is NOT influenced by the established }
{       record size.  File position is advanced by the number of      }
{       bytes read.                                                   }
{                                                                     }
{ EXAMPLE:  ReadText(F,Header,32);                                    }
{ ------------------------------------------------------------------- }
{ CAUTION: This routine writes directly to the DOS file, and does     }
{ *not* flush or otherwise maintain the current text buffer    ...red }
{ =================================================================== }

FUNCTION WriteFile(VAR F: Text; VAR Target; ByteCount: Word): Word;
{ =================================================================== }
{ Writes the specified number of bytes to a text file.                }
{ NOTE: The number of bytes written read is NOT influenced by the     }
{       established record size.  File position is advanced by the    }
{       number of bytes written.                                      }
{                                                                     }
{ EXAMPLE:  WriteFile(F,Header,32);                                   }
{ ------------------------------------------------------------------- }
{ CAUTION: This routine reads directly to the DOS file, and does      }
{ *not* flush or otherwise maintain the current text buffer    ...red }
{ =================================================================== }

const  Stdin  = 0;
       Stdout = 1;
       Stderr = 2;
       Stdaux = 3;
       Stdprn = 4;

PROCEDURE ReDirect(VAR F : Text; Device: Word);
{ =================================================================== }
{ Redirects standard device to a previously opened file variable.     }
{ Uses TextRec.UserData[1..4] to store old handle & Device Number     }
{                                                                     }
{ EXAMPLE:                                                            }
{     Redirect(F, Stdin);                                             }
{     ReDirect(G, Stdout);                                            }
{     Exec(Fsearch('VSORT.COM', GetEnv('PATH')), '');                 }
{     UnDirect(F);                                                    }
{     UnDirect(G);                                                    }
{ =================================================================== }

PROCEDURE UnDirect(VAR F : Text);
{ =================================================================== }
{ Restores standard device from a previously redirected file variable }
{ Uses TextRec.UserData[1..4] to restore old handle & Device Number   }
{                                                                     }
{ EXAMPLE:                                                            }
{     Redirect(F, Stdin);                                             }
{     ReDirect(G, Stdout);                                            }
{     Exec(Fsearch('VSORT.COM', GetEnv('PATH')), '');                 }
{     UnDirect(F);                                                    }
{     UnDirect(G);                                                    }
{ =================================================================== }

PROCEDURE BeginRedirect(VAR Input, Output: Text);
PROCEDURE EndRedirect;
{ =================================================================== }
{ Redirects Input and Output to StdInp and StdOut                     }
{ =================================================================== }

PROCEDURE Commit(VAR F {File or Text});
{ =================================================================== }
{ Commits file to disk.           (code is DOS 2. compatible  ...red) }
{ =================================================================== }

IMPLEMENTATION
{$IFOPT F+} {$DEFINE FAR}   {$ELSE} {$UNDEF FAR}   {$ENDIF}
{$IFOPT I+} {$DEFINE IOCHK} {$ELSE} {$UNDEF IOCHK} {$ENDIF}

{ =================================================================== }
const TDinp: ARRAY[0..3] Of Pointer = (NIL, NIL, NIL, NIL);
      TDout: ARRAY[0..3] Of Pointer = (NIL, NIL, NIL, NIL);

{$IFNDEF DPMI}
VAR  ExtendedFileTable: Array[0..255] Of Byte;

Procedure ExtendFileHandles(Number: Integer);
{ ==================================================================== }
TYPE tFileHandleRecord = RECORD MaxFiles: Word; Table: Pointer; End;
VAR Temp: Array[0..255] of Byte;
Begin { ExtendFileHandles }

{$IFOPT R+}
    If (Number < 20) or (Number > 255) Then
       RunError(201);
{$ENDIF}
    With tFileHandleRecord(Ptr(PrefixSeg, $32)^) Do Begin
       Move(Table^, Temp, MaxFiles);                           { Save existing table }
       FillChar(ExtendedFileTable, Number, $FF);               { incase it is being  }
       Move(Temp, ExtendedFileTable, iMin(Number, MaxFiles));  { extended     ...red }
       Table := @ExtendedFileTable;
       MaxFiles := Number;
    End;
End; { ExtendFileHandles }


Procedure ExtendPSPFileHandles;
{ ==================================================================== }
TYPE tFileHandleRecord = RECORD MaxFiles: Word; Table: Pointer; End;
VAR p: Pointer;
    Temp: Array[0..43] of Byte;

Begin { ExtendPSPFileHandles }

    With tFileHandleRecord(Ptr(PrefixSeg, $32)^) Do Begin
       If (MaxFiles > 43) Then RunError(201);
       p := Ptr(PrefixSeg, $55);
       Move(Table^, Temp, MaxFiles);                           { Save existing table }
       FillChar(p^, 43, $FF);
       Move(Temp, p^, MaxFiles);
       MaxFiles := 43;
       Table := p;
    End;
End; { ExtendPSPFileHandles }
{$ENDIF}

{$L SEEKFILE } FUNCTION  SeekFile;                           EXTERNAL;
{$L SEEKTEXT } PROCEDURE SeekText;                           EXTERNAL;
{$L COMMIT   } PROCEDURE Commit;                             EXTERNAL;
{$L RW_FILE  } FUNCTION  ReadFile;                           EXTERNAL;
               FUNCTION  WriteFile;                          EXTERNAL;
{$L LF2CR    } FUNCTION  TFDD_LFinp(VAR F: Text): Integer;   EXTERNAL;
{$L TEXTPOS  } FUNCTION  TextPos(VAR F: Text): Longint;      EXTERNAL;


FUNCTION TextSize(VAR F: Text): Longint;
{ =================================================================== }
VAR i: Longint;
BEGIN
    If TextRec(F).Handle = $FFFF Then
       TextSize := TextRec(F).BufEnd
    Else Begin
       i := TextPos(F);
       TextSize := SeekFile(F, 0, 2);
       SeekText(F, i);
    End;
END;


PROCEDURE Rewind(VAR F: Text);
{ =================================================================== }
BEGIN
    Flush(F);
    SeekText(F, 0);
END;


PROCEDURE TruncateFile(VAR F: Text);
{ =================================================================== }
{$IFNDEF BASM}
VAR Reg: Registers;
BEGIN
    Flush(F);
    Reg.AX := $4000; { Write       }
    Reg.CX := 0;     { Zero length }
    Reg.BX := TextRec(F).Handle;
    msdos(Reg);
{$ELSE}
BEGIN
    Flush(F);
    ASM
        les  BX, [ F ]
        mov  BX, [ ES:BX ]
        xor  CX, CX
        mov  AX, $4400
        int  21h
    END;
{$ENDIF}
END;


PROCEDURE ResetForInput(VAR F: Text);
{ =================================================================== }
{ Changes file mode for input                                         }
{ =================================================================== }
BEGIN
    With TextRec(F) Do
       If Mode = fmOUTPUT Then Begin
          Flush(F);
          Mode := fmINPUT;
          Move(TDinp, TextRec(F).OpenFunc, Sizeof(TDinp));
       End;
END;


PROCEDURE ResetForOutput(VAR F: Text);
{ =================================================================== }
{ Changes file mode for output                                        }
{ =================================================================== }
{$IFNDEF X}VAR i: Integer; {$ENDIF}
BEGIN
    With TextRec(F) Do
       If Mode = fmINPUT Then Begin
          {$IFNDEF X} i := {$ENDIF} TextPos(F);   { Reset file buffer }
          Move(TDout, TextRec(F).OpenFunc, Sizeof(TDout));
          Mode := fmOUTPUT;
       End;
END;


PROCEDURE ClearIOResult;
{ =================================================================== }
BEGIN
    {$IFDEF VER40}
      If IOResult <> 0 Then {nop};
    {$ELSE}
       InOutRes := 0;
    {$ENDIF}
END;

{$IFDEF VER40}
{$F+}
PROCEDURE RunError(No: Integer); {$IFNDEF FAR} {$F-} {$ENDIF}
{ =================================================================== }
VAR Caller: Pointer;
BEGIN
    Caller := Pointer( Ptr(Seg(Caller), Ofs(Caller)+6)^ );
    Writeln('IO Error ', No);
    Writeln('At ', Hex(Seg(Caller^)),':',Ofs(Caller^));
    Halt(No);
END;


FUNCTION FSearch(Name, Paths: String): PathStr;
{ =================================================================== }
VAR i,j: Integer;
    s: String;
BEGIN
    j := DCount(';', Paths);
    For i := 1 to j Do Begin
        s := Change('\\', '\', Field(Paths, ';', i) + '\' + Name);
        If FileAttrOf(s) <> 0 Then Begin
           FSearch := s;
           Exit;
        End;
    End;
    FSearch := '';
END;


PROCEDURE FSPlit(FileSpec: PathStr; VAR Dir: DirStr; VAR Nam: NameStr; VAR Ext: ExtStr);
{ =================================================================== }
VAR i,j  : Integer;
    Temp : String;
BEGIN
    i := Max(Lpos('\',FileSpec), Lpos(':',FileSpec));
    j := Max(Lpos('.',FileSpec), Apos('.',FileSpec));

    If j < i Then Begin
       Nam := '';
       Ext := '';
       Dir := FileSpec;
    End Else Begin
       Nam := Copy(FileSpec, Succ(i), Pred(j-i));
       Ext := Copy(FileSpec, j, 4);
       Dir := Copy(FileSpec, 1, Pred(i));
    End;
END;


FUNCTION FExpand(FileSpec: PathStr): PathStr;
{ =================================================================== }
VAR   i,j: Integer;
      Dir: DirStr;
      Nam: NameStr;
      Ext: ExtStr;
      s: String;
BEGIN
    i := Pos(':', FileSpec);
    If i > 2 Then
       s := FileSpec  { must be a network volume, pass it back }
    Else Begin
       If i <> 0 Then Begin
          GetDir(Ord(FileSpec[1]) and $1F, s);
          Delete(FileSpec, 1, i);
       End Else GetDir(0, s);
       If s[Ord(s[0])] <> '\' Then s := s + '\';

       FSplit(FileSpec, Dir, Nam, Ext);
       i := Pos('\', FileSpec);
       If i = 1 Then
          s := Char(DriveOf(s) + $40) + ':' + FileSpec
       Else Begin
          i := Pos('..\', FileSpec);
          While (i <> 0) Do Begin
             If i = 1 Then Begin
                Delete(FileSpec, 1, 3);
                Dec(s[0]);
                s := BeforeLast('\', s) + '\';
             End Else Begin
                FileSpec := BeforeLast('\', Copy(FileSpec, 1, Pred(i)))
                          + Copy(FileSpec, i+2, 80);
             End;
             i := Pos('..\', FileSpec);
          End;
          s := s + FileSpec;
       End;
    End;
    FExpand := s;
END;
{$ENDIF}

FUNCTION Open(VAR F: Text; Access: Byte): Boolean;
{ ============================================================= }
VAR S: Array[0..79] of Char;
    Reg: Registers;
BEGIN
    Open := FALSE; { Assume failure }
    If Access and 3 <> ReadOnly Then
       Exit;  { not prepared to handle rewrite or append }

    If TextRec(F).Mode <> fmClosed Then Begin
       If  (TextRec(F).Mode <> fmInput) 
       and (TextRec(F).Mode <> fmOutput) 
       Then
          Exit; { current state of the file is not known ... }

       Close(F)
    End;

    { We need to initialize our filevar functions w/o affecting }
    { existing files and with no knowledge of any file that we  }
    { can open in compatibility mode, so we'll perform a little }
    { slight of hand maneuver                            ...red }
    Move(TextRec(F).Name, s, Sizeof(s));       { Save file name }
    Assign(F, ''); Reset(F);   { initialize w/ redirected input }
    Move(s, TextRec(F).Name, Sizeof(s));       { Restore name   }

    Reg.AH := $3E;                  { Close file by handle      }
    Reg.BX := TextRec(F).Handle;
    MsDos(Reg);

    Reg.AH := $3D;                  { Open file by handle       }
    Reg.AL := Access;
    Reg.DS := Seg(s);
    Reg.DX := Ofs(s);
    MsDos(Reg);

    If Odd(Reg.Flags) Then
       TextRec(F).Mode := fmClosed  { DOS error, file not opened }
    Else Begin
       TextRec(F).Handle := Reg.AX;
       Open := TRUE;
    End;
END;



PROCEDURE OpenForUpdate(VAR F: Text);
{ =================================================================== }
{ Opens text file for Read/Write                                      }
{ =================================================================== }
VAR TmpF: TEXT;
    {$IFDEF VER40} i: Integer; {$ENDIF}

BEGIN
    {$I-}
    Append(F);
    {$IFDEF VER40}
       i := IOResult;
       If i <> 0 Then RunError(i);
    {$ELSE}
      If InOutRes <> 0 Then Exit;
    {$ENDIF}
    If TDout[0] = NIL Then
       Move(TextRec(F).OpenFunc, TDout, Sizeof(TDout));
    IF TDinp[0] = NIL Then Begin
       Assign(TmpF, StrPas(@TextRec(F).Name)); Reset(TmpF);
       {$IFDEF VER40}
          i := IOResult;
          If i <> 0 Then RunError(i);
       {$ELSE}
         If InOutRes <> 0 Then Exit;
       {$ENDIF}
       Move(TextRec(TmpF).OpenFunc, TDinp, Sizeof(TDinp));
       Close(TmpF);
    End;
    Move(TDinp, TextRec(F).OpenFunc, Sizeof(TDinp));
    TextRec(F).Mode := fmINPUT;
    Rewind(F);
    {$IFDEF IOCHK} {$I+} {$ENDIF}
END;


PROCEDURE CreateForUpdate(VAR F: Text);
{ =================================================================== }
{ Creates text file for Read/Write                                    }
{ =================================================================== }
VAR TmpF: TEXT;
BEGIN
    Rewrite(F); Close(F);
    OpenForUpdate(F);
    ResetForOutput(F);
END;


FUNCTION ShortSpecOf(Spec: String; Len: Integer): String;
{ =================================================================== }
VAR P: PathStr;
    D: DirStr;
    N: NameStr;
    E: ExtStr;
    S: DirStr;
    t: String[8];

BEGIN
    FSplit(FExpand(Spec), D, N, E);
    s := '';
    t := '';
    s := d + n + e;
    While (Length(s) > Len) and (Dcount('\', d) > 1) Do Begin
       d := BeforeLast('\', D);
       s := d + '\...\' + n + e;
    End;
    If Length(s) > Len Then s := AfterFirst('\', s); { Drop drive }
    If Length(s) > Len Then s := n + e;              { Drop ...\ }
    If Length(s) > Len Then s := n;                  { Drop ext   }
    ShortSpecOF := s;
END;


FUNCTION FileNameOf;
{ ==================================================================== }
VAR Path: DirStr;
    Name: NameStr;
    Ext : ExtStr;

BEGIN
    FSplit(FileSpec, Path, Name, Ext);
    FileNameOf := Name;
END;


FUNCTION FullTypeOf;
{ ==================================================================== }
VAR Path: DirStr;
    Name: NameStr;
    Ext : ExtStr;

BEGIN
    FSplit(FileSpec, Path, Name, Ext);
    FullTypeOf := Ext;
END;


FUNCTION FullNameOf;
{ ==================================================================== }
BEGIN
    FullnameOf := FileNameOf(FileSpec) + FullTypeOf(FileSpec);
END;


FUNCTION FileTypeOf;
{ ==================================================================== }
BEGIN
    FileTypeOf := AfterFirst('.', FullTypeOF(FileSpec));
END;


FUNCTION DriveOf(FileSpec: String): Integer;
{ ==================================================================== }
VAR S: String;
    i: Integer;
BEGIN
    i := Pos(':', FileSpec);
    If i <> 0 Then
       DriveOf := Ord(FileSpec[1]) and $1F
    Else Begin
       GetDir(0, s);
       DriveOf := Ord(s[1]) and $1F
    End;
END;


FUNCTION FullSpecOf(FileSpec: String): String;
{ ==================================================================== }
BEGIN
    FullSpecOf := FExpand(FileSpec);
END;


FUNCTION FileSpecOf(VAR Filevar): String;
{ ==================================================================== }
BEGIN
    FileSpecOf := StrPas(@TextRec(Filevar).Name);
END;


FUNCTION FullPathOf(FileSpec: String): String;
{ ==================================================================== }
VAR Path: DirStr;
    Name: NameStr;
    Ext : ExtStr;

BEGIN
    FSplit(FExpand(FileSpec), Path, Name, Ext);
    FullPathOf := Path;
END;


FUNCTION Exists(Fname: String): Boolean;
{ =================================================================== }
VAR  i : Word;
     {\s : Text; {}
BEGIN{Exists}
    i := FileAttrOf(Fname) and $80FF;
    Exists := (i <> 0) and (i and ($8000 + Directory + VolumeID) = 0);

   (* ---- replaced w/ FindFirst  ...red
   Exists := FALSE;    { Assume failure } {}
   Fname := Trim(Fname); {}
   If Fname <> '' Then Begin {}
      {$I-} Assign(F, Fname); Reset(F);
      {$IFDEF IOCHK} {$I+} {$ENDIF}
      If IOResult = 0 Then Begin
         Exists := TRUE;
         Close(F);
      End;
   End;
   --- *)

END{Exists};




FUNCTION FileAttrOf(Spec: String): Integer;
{ =================================================================== }
VAR  Entry: SearchRec;
     i: Integer;

BEGIN{FileAttrOf}

   i := 0;
   FindFirst(Spec, AnyFile, Entry);
   If DosError = 0 Then Begin
      i := $80 or Entry.Attr;
      FindNext(Entry);
      If DosError = 0 Then
         i := Entry.Attr Shl 8 + ($80 or i);
   End;
   FileAttrOf := i;

END{FileAttrOf};


PROCEDURE Erase{ (VAR F: Text) };
{ =================================================================== }
BEGIN
    {$I-}
    If TextRec(F).Mode <> fmClosed Then Begin
       Close(F); ClearIOResult;
    End;
    SYSTEM.Erase(F);
    ClearIOResult;
    {$IFDEF IOCHK} {$I+} {$ENDIF}
END;


PROCEDURE EraseFile({$IFDEF C}const{$ENDIF} Spec: String);
{ =================================================================== }
VAR F: File;
BEGIN
    {$I-}
    Assign(F, Spec);
    SYSTEM.Erase(F);
    ClearIOResult;
    {$IFDEF IOCHK} {$I+} {$ENDIF}
END;


PROCEDURE EraseAll(FileSpec: String);
{ =================================================================== }
VAR G: SearchRec;
BEGIN
    FindFirst(FileSpec,AnyFile,G);
    While DosError = 0 Do Begin
        EraseFile(FullPathOf(FileSpec) + G.Name);
        FindNext(G);
    End;
END;


PROCEDURE RemoveScratchDirectory({$IFDEF C}const{$ENDIF} Dir: String);
{ =================================================================== }
VAR Scratch: String;
BEGIN
    Scratch := Change('\\', '\', Dir + '\');
    EraseAll(Scratch + '*.*');
    Dec(Scratch[0]);
    {$I-}
    RmDir(Scratch);
    ClearIOResult;
    {$IFDEF IOCHK} {$I+} {$ENDIF}
END;


FUNCTION TempFileOf({$IFDEF C}const{$ENDIF} FileSpec: String): String;
{ =================================================================== }
VAR path: DirStr;
    name: NameStr;
    ext : ExtStr;
Begin
    FSplit(FileSpec, Path, Name, Ext);
    TempFileOf := Path + Name + '.$$$';
End;


PROCEDURE RollOver({$IFDEF C}const{$ENDIF} FileSpec: String);
{ =================================================================== }
VAR F              : File;
    Back : String;
    path : DirStr;
    name : NameStr;
    ext  : ExtStr;

BEGIN{RollOver}

    {$I-}
    FSplit(FileSpec, Path, Name, Ext);
    Back := Path + Name + '.BAK';
    EraseFile(Back);
    Assign(F, FileSpec);
    Rename(F, Back);
    ClearIOResult;
    Assign(F, TempFileOf(FileSpec));
    Rename(F, FileSpec);
    {$IFDEF IOCHK} {$I+} {$ENDIF}

END{RollOver};


const  CloseFile = $3E;
       DupHandle = $45;
       ForceDup  = $46;


PROCEDURE Redirect(VAR F : Text; Device: Word);
{ =================================================================== }
{ Redirects standard device to the specified file variable            }
{ =================================================================== }
VAR Regs: Registers;
BEGIN
    Regs.AH := DupHandle;
    Regs.BX := Device;
    MSDOS(Regs);
    If odd(Regs.Flags) Then RunError(Regs.AL);
    Move(Regs.AX,TextRec(F).UserData[1],2);  { Old handle }
    Move(Device, TextRec(F).UserData[3],2);  { Device No. }

    Regs.AH := ForceDup;
    Regs.BX := TextRec(F).Handle;
    Regs.CX := Device;
    MSDOS(Regs);
    If odd(Regs.Flags) Then RunError(Regs.AL);
END;


PROCEDURE UnDirect(VAR F: Text);
{ =================================================================== }
{ Restores standard device frmo the specified file variable           }
{ =================================================================== }
VAR Regs: Registers;
BEGIN
    Regs.AH := ForceDup;
    Move(TextRec(F).UserData[1],Regs.BX,2);   { Old Handle }
    Move(TextRec(F).UserData[3],Regs.CX,2);   { Device No. }
    MSDOS(Regs);

    Regs.AH := CloseFile;
    Move(TextRec(F).UserData[1],Regs.BX,2);   { Old Handle }
    MSDOS(Regs);
END;


CONST TempInp: ^Text = NIL;
      TempOut: ^Text = NIL;

PROCEDURE BeginRedirect(VAR Input, Output: Text);
{ =================================================================== }
BEGIN
    ReDirect(Input, StdIn);
    ReDirect(Output, StdOut);
    TempInp := @Input;
    TempOut := @Output;
END;


PROCEDURE EndRedirect;
{ =================================================================== }
BEGIN
    If TempInp <> NIL Then Begin
       UnDirect(TempInp^);
       UnDirect(TempOut^);
       TempInp := NIL;
       TempOut := NIL;
    End;
END;


FUNCTION IsDevice(VAR F): Boolean;
{ =================================================================== }
{$IFNDEF BASM}
VAR Reg: Registers;
BEGIN
    Reg.BX := TextRec(F).Handle;
    Reg.AX := $4400;
    MsDos(Reg);
    isDevice := Reg.DL and $80 <> 0;
{$ELSE}
Assembler;
ASM
    les   BX, [ F ]
    mov   BX, [ ES:BX.TextRec.Handle ]
    mov   AX, $4400
    int   $21
    shl   DL, 1
    sbb   AL, AL
{$ENDIF}
END;


FUNCTION MapFile(Source, Pattern: String): String;
{ ------------------------------------------------------------------- }
VAR sName, pName: NameStr;
    sExt,  pExt:  ExtStr;
    sDir,  pDir:  DirStr;
    i: Integer;
BEGIN
     Fsplit(Source, sDir, sName, sExt);
     sName := LSet(sName,  8);
     sExt  := LSet(sExt,  3);

     Fsplit(Pattern, pDir, pName, pExt);
     pName := LSet(pName,  8);
     pExt  := LSet(pExt,  3);

     pName := LSet(Trim(FileNameOf(Pattern)), 8);
     pExt  := LSet(Trim(FileTypeOf(Pattern)), 3);

     If Trim(pName) = '' Then
        pName := '*';

     pName := Change('*', '????????', pName);

     For i := 1 to 8 Do
         If pName[i] = '?' Then
            pName[i] := sName[i];

     If Trim(pExt) <> '' Then Begin
        pExt := Change('*', '???', pExt);

        For i := 1 to 3 Do
            If pExt[i] = '?' Then
               pExt[i] := sExt[i];
     End;

     If Pos('*', pDir) <> 0 Then
        pDir := sDir;

     If Pos('.', Pattern) = 0 Then
        MapFile := pDir + Trim(pName)
     Else MapFile := pDir + Trim(pName) + '.' + pExt;
END;


FUNCTION CopyFile(Source, Target: String): Boolean;
{ =================================================================== }
VAR Buf: POINTER;
    Siz: Word;
      k: Longint;
      i: Word;
    inpF,outF: FIlE;

LABEL Close1, Close2;
BEGIN
    {$I-}
    CopyFile := FALSE;  { Assume error }
    Assign(inpF, Source); Reset(inpF,1);
    If IOresult <> 0 Then Exit;

    Assign(outF, Target); Rewrite(outF,1);
    If IOresult <> 0 Then Goto Close1;

    k := FileSize(inpF);
    Siz := Min($4000, Min(k, MaxAvail));

    GetMem(Buf, Siz);
    {StatLevels;       { Snapshot currently used resources }{}

       While k > 0 Do Begin
          i := Min(Siz, k);
          BlockRead(inpF, Buf^, i);
          If IOresult <> 0 Then Goto Close2;
          BlockWrite(outF, Buf^, i);
          If IOResult <> 0 Then Goto Close2;
          Dec(k, i);
       End;

    CopyFile := TRUE;

Close2:   FreeMem(Buf, Siz);
          Close(outF);
Close1:   Close(inpF);

    {$IFDEF IOCHK} {$I+} {$ENDIF}
END;


Procedure SetBinaryMode(VAR F: Text);
{ ==================================================================== }
{$IFNDEF BASM}
VAR Reg: Registers;
Begin
    Reg.BX := TextRec(F).Handle;
    Reg.AX := $4400;
    MsDos(Reg);
    Reg.DL := Reg.DL or $20;
    Reg.DH := 0;
    Reg.AX := $4401;
    MsDos(Reg);
{$ELSE}
Assembler;
ASM
    les   BX, [ F ]
    mov   BX, [ ES:BX ]
    mov   AX, $4400
    int   21h
    or    DL, 20h
    xor   DH, DH
    mov   AX, $4401
    int   21h
{$ENDIF}
END;

{$F+}
FUNCTION TFDDnop(VAR DatF: Text): Integer; {$IFNDEF FAR} {$F-} {$ENDIF}
{ =================================================================== }
{                                                                     }
{ =================================================================== }
BEGIN  TFDDnop := 0;  END;

{$F+}
FUNCTION TFDDerr(VAR DatF: Text): Integer; {$IFNDEF FAR} {$F-} {$ENDIF}
{ =================================================================== }
{                                                                     }
{ =================================================================== }
BEGIN  TFDDerr := 1;  END;

{$F+}
FUNCTION VAR_TDinp(VAR DatF: Text): Integer; {$IFNDEF FAR} {$F-} {$ENDIF}
{ =================================================================== }
{                                                                     }
{ =================================================================== }
BEGIN
    If TextRec(DatF).Mode <> fmINPUT Then
       VAR_TDinp := 103
    Else Begin
       TExtRec(DatF).BufPos := 0;
       TExtRec(DatF).BufEnd := 0;
       VAR_TDinp := 0;
    End;
END;

{$F+}
FUNCTION VAR_TDopen(VAR Datf: Text): Integer; {$IFNDEF FAR} {$F-} {$ENDIF}
{ =================================================================== }
{ Open DatF w/input fixed to current BufSize                          }
{ =================================================================== }
BEGIN
    With TextRec(DatF) Do Begin
       If Mode <> fmINPUT Then
          RunError(101);
       Name[0]    := #0;
       Handle     := $FFFF;
       OpenFunc   := @VAR_TDopen;
       CloseFunc  := @TFDDnop;
       FlushFunc  := @TFDDnop;
       InOutFunc  := @VAR_TDinp;
       BufEnd     := BufSize;
       BufPos     := 0;
       VAR_TDopen := 0;
    End;
END;

{$F+}
FUNCTION TFDD_LFopen(VAR TextF: Text): Integer; {$IFNDEF FAR} {$F-} {$ENDIF}
{ =================================================================== }
{ Open TextF for LF only (#10) terminated lines                       }
{ =================================================================== }
BEGIN
    With TextRec(TextF) Do Begin
       If Mode <> fmINPUT Then
          RunError(101);
       {Name[0]     := #0;    {}
       {Handle      := $FFFF; {}
       OpenFunc    := @TFDD_LFopen;
       InOutFunc   := @TFDD_LFinp;
       BufEnd      := 0;
       BufPos      := 0;
       TFDD_LFopen := 0;
    End;
END;


PROCEDURE OpenVAR(VAR F: Text; VAR Buf; Size: Integer);
{ =================================================================== }
{ Prepares text file "f" to read from fixed buffer "Buf"              }
{ =================================================================== }
BEGIN
    With TextRec(F) Do Begin
        Mode := fmINPUT;
        BufPtr := @Buf;
        BufSize := Size;
    End;
    VAR_TDOpen(F);
END;


PROCEDURE OpenLF{(VAR F: Text; const FileSpec: String)} ;
{ =================================================================== }
{$IFDEF VER40}
VAR i: Integer;
{$ENDIF}
BEGIN
    {$I-}
    Assign(F, FileSpec);
    Reset(F);                                 { Pass error to caller  }
    TextRec(F).OpenFunc  := @TFDD_LFopen;     { Disable Reset/Rewrite }
    TextRec(F).InOutFunc := @TFDD_LFinp;      { Replace input routine }
    { Flush and Close are fine as the are }
    {$IFDEF VER40}
       i := IOResult;
       If i <> 0 Then RunError(i);
    {$ENDIF}
    {$IFDEF IOCHK} {$I+} {$ENDIF}
END;


PROCEDURE OpenString(VAR F: Text; VAR s: String);
{ =================================================================== }
BEGIN
    OpenVAR(F, s[1], Length(s));
END;


PROCEDURE OpenPChar(VAR F: Text; p: pChar);
{ =================================================================== }
BEGIN
    OpenVAR(F, p^, StrLen(p));
END;


PROCEDURE ResetTextBuf(VAR F: Text);
{ =================================================================== }
{ Reset text file buffer ...                                          }
{ =================================================================== }
BEGIN
    With TextRec(F) Do Begin
        BufPtr := @Buffer;
        BufSize := 128;
        BufPos := 0;
        BufEnd := 0;
    End;
END;


PROCEDURE GetTextBuf(VAR F: Text; BufSize: Word);
{ =================================================================== }
VAR Buf: Pointer;
    i: Longint;
BEGIN
    i := MaxAvail;

    While (BufSize > i) Do
          BufSize := BufSize shr 1;

    If i >= BufSize Then Begin
       GetMem(Buf, BufSize);
       SYSTEM.SetTextBuf(F, Buf^, BufSize);
    End;
END;


PROCEDURE FreeTextBuf(VAR F: Text);
{ =================================================================== }
{ Reset text file buffer ...                                          }
{ =================================================================== }
BEGIN
    If TextRec(F).BufPtr <> @TextRec(F).Buffer Then
       Freemem(TextRec(F).BufPtr, TextRec(F).BufSize);
    ResetTextBuf(F);
END;


const ExeDir: DirStr = '';
      TmpDir: DirStr = '';

Procedure ChDir(Directory: String);
{ ==================================================================== }
Begin
    If (LChar(Directory) = '\') and (CharAt(Directory, Length(Directory)-1) <> ':' ) Then
       Dec(Directory[0]);
    SYSTEM.ChDir(Directory);
End;


FUNCTION TmpPath: String;
{ ==================================================================== }
{ Returns the work directory (Env: 'TMP' or 'TEMP', Default, or 'C:\'  }
{ ==================================================================== }
VAR s: String;
    F: File;
BEGIN
    If TmpDir = '' Then Begin
       { Establish temporary scratch directory ... }
       s := GetEnv('TMP');
       If s = '' Then
          s := GetEnv('TEMP');
       If s = '' Then Begin
          {$I-}
          Assign(F, '$'); Rewrite(F);
          If IOResult <> 0 Then
             s := 'c:\'
          Else Begin
             GetDir(0, s);
             Close(F);
             SYSTEM.Erase(F);
          End;
          {$IFDEF IOCHK} {$I+} {$ENDIF}
       End Else
       If NOT(LChar(s) in [':', '\']) Then
          s := s + '\';

       TmpDir  := FullPathOf(s + '*.*');
    End;
    TmpPath := TmpDir;
END;


FUNCTION ExePath: String;
{ ==================================================================== }
{ Returns the directory containing the program file                    }
{ ==================================================================== }
BEGIN
    If ExeDir = '' Then Begin
       { Establish Exe Directory ... }
       ExeDir := ParamStr(0);
       If ExeDir <> '' Then
          ExeDir := FullPathOf(ExeDir);
    End;
    ExePath := ExeDir;
END;


FUNCTION SwapFile({$IFDEF C}const{$ENDIF} Name: String): String;
{ ==================================================================== }
{ Returns the full spec of TMPDIR + NAME + 'STATION' .SWP              }
{ ==================================================================== }
VAR s, t: String;
BEGIN
    t := Copy(Name, 1, 5)+Trim(GetEnv('STATION'))+'.SWP';
    SwapFile := TmpPath + t;
    If ExePath = '' Then
       { If ExePath is unknown, then search for exe using Name ... }
       ExeDir := FullPathOf(FSearch(Name+'.EXE', '.;'+GetEnv('PATH')));
End;

END.


