{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          TEMPLATE UNITS                   [x] Real mode
        | Template/Stream.pas              [x] Protected mode

  This template shows how create your own streams, derived directly
  from the parent stream object in EFKERNEL;

  This is a template unit, provided to make it easier for you to
  extend EFLIB for your own needs.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS TEMPLATE UNIT MAY FREELY BE USED, MODIFIED
  AND DISTRIBUTED IN YOUR EFLIB DEVELOPED APPLICATION.                    }

unit Template;


INTERFACE

uses EFKERNEL;

type pTemplateStream = ^tTemplateStream;
     tTemplateStream = object (tStream)

       { Template stream object. }

       public

         constructor Initialize;
         destructor  Intercept; virtual;

         procedure   Read (var Data; Count : word); virtual;
         procedure   Write (var Data; Count : word); virtual;

         procedure   Reset; virtual;
         procedure   Flush; virtual;
         procedure   Truncate; virtual;
         procedure   Seek (Where : longint); virtual;

         function    Size : longint; virtual;

         function    IsAllocated : boolean; virtual;
         function    IsReady : boolean; virtual;

     end;


IMPLEMENTATION

{ Initializes object }
constructor tTemplateStream.Initialize;
begin
     Inherited Initialize;
     { ... }
end;

{ Intercepts object }
destructor tTemplateStream.Intercept;
begin
     { ... }
     Inherited Intercept;
end;


procedure tTemplateStream.Read (var Data; Count : word);
begin
     { ... }
end;


procedure tTemplateStream.Write (var Data; Count : word);
begin
     { ... }
end;


procedure tTemplateStream.Reset;
begin
     Inherited Reset;
     { ... }
end;

procedure tTemplateStream.Flush;
begin
     { ... }
end;

procedure tTemplateStream.Truncate;
begin
     { This method should only be overridden if your stream
       permits truncation (ie. removal of all following data).
       The parent method generates an abstract method call error. }
end;


procedure tTemplateStream.Seek (Where : longint);
begin
     Inherited Seek (Where);

     { The inherited seek method automatically changes the
       logical position of the stream. You must change any
       physical position yourself (such as the position in
       a file). }

     { ... }
end;


function tTemplateStream.Size : longint;
begin
     { Return the size of this stream, ie. the length of
       the stream in bytes >= 0. }
     Size := 0;
end;


function tTemplateStream.IsAllocated : boolean;
begin
     { Return TRUE if this stream is operational, ie.
       initialized, allocated, non-empty etc. }
     IsAllocated := (Size > 0);
end;

function tTemplateStream.IsReady : boolean;
begin
     { Is the stream ready for write access, eg. file
       read-only marked? }
     IsReady := IsAllocated;
end;


end.