UNIT Drivers;

  {This UNIT was based on the original Borland DRIVERS.PAS program.
   But this UNIT was modified to be self-initializing for CGA, EGA
   and VGA drivers.

   If DOS Environment variables DRIVER and MODE are defined
   appropriately, the DeCodeDriverMode procedure in this unit
   can be called to override automatic driver detection, e.g.,

        DeCodeDriverMode (GetEnv('DRIVER'), GetEnv('MODE'),
                          VideoDriver, VideoMode);

   EFG, 11 October 1990.}


INTERFACE

  PROCEDURE DecodeDriverMode (DriverType,Resolution:  STRING;
                              VAR Driver,Mode:  INTEGER);

  PROCEDURE CGADriverProc;
  PROCEDURE EGAVGADriverProc;


IMPLEMENTATION
  USES Graph, DOS;

  VAR
    driver     :  INTEGER;
    AutoPointer:  Pointer;

  PROCEDURE Abort (Msg : string);
  BEGIN
    Writeln('Driver ',Msg, ':  Error', GraphErrorMsg(GraphResult));
    Halt (1)
  END {Abort};

  PROCEDURE InitDrivers;
    {Register all the drivers.}
  BEGIN
    IF   RegisterBGIdriver(@CGADriverProc) < 0
    THEN Abort('CGA');
    IF   RegisterBGIdriver(@EGAVGADriverProc) < 0
    THEN Abort('EGA/VGA')
  END {InitDrivers};

  PROCEDURE DecodeDriverMode (DriverType,Resolution:  STRING;
                              VAR Driver,Mode:  INTEGER);
    VAR i:  BYTE;
  BEGIN
    DetectGraph(Driver, Mode);
    IF   (LENGTH(DriverType) = 0) OR (LENGTH(Resolution) = 0)
    THEN EXIT;

    FOR i := 1 TO LENGTH(DriverType) DO
      DriverType[i] := UpCase( DriverType[i] );
    FOR i := 1 TO LENGTH(Resolution) DO
      Resolution[i] := UpCase( Resolution[i] );

    IF   DriverType = 'CGA'
    THEN BEGIN
      Driver := CGA;
      IF   (Resolution = '320X200A') OR   {default}
           (Resolution = '320x200')
      THEN Mode := CGAC0
      ELSE
        IF   Resolution = '320X200B'
        THEN Mode := CGAC1
        ELSE
          IF   Resolution = '320X200C'
          THEN Mode := CGAC2
          ELSE
            IF   Resolution = '320X200D'
            THEN Mode := CGAC3
            ELSE
              IF   Resolution = '640X200'
              THEN Mode := CGAHi
              ELSE Mode := CGAC0
    END
    ELSE
      IF   DriverType = 'EGA'
      THEN BEGIN
        Driver := EGA;
        IF   Resolution = '640X200'
        THEN Mode := EGALo
        ELSE Mode := EGAHi        {640X350 and default}
      END
      ELSE
        IF   DriverType = 'VGA'
        THEN BEGIN
          Driver := VGA;
          IF   Resolution = '640X200'
          THEN Mode := VGALo
          ELSE
            IF   Resolution = '640X350'
            THEN Mode := VGAMed
            ELSE Mode := VGAHi  {640X480 and default}
        END
        ELSE BEGIN
          Driver := Detect;
          Mode := 0
        END;
  END {DeCodeDriverMode};

  PROCEDURE CGADriverProc;
    EXTERNAL;
    {$L CGA.OBJ }

  PROCEDURE EGAVGADriverProc;
    EXTERNAL;
    {$L EGAVGA.OBJ }

BEGIN
  InitDrivers
END.
