{
  Prompts.Pas

  A BBSkit unit containing various prompts.

  Written by Steve Madsen
}

UNIT Prompts;

{$V-}

{********************************************************************}

INTERFACE

Uses BBSkit;

Type
  TPrompts = object(TBBS)
    CNorm      : Byte;
    CHighlight : Byte;

    CONSTRUCTOR Init;

    PROCEDURE ChangeColor(Color : Byte);
    PROCEDURE CRPrompt;
    FUNCTION Prompt(Strn : String) : Char;
    PROCEDURE SetHighlightColor(Fore, Back : Byte);
    PROCEDURE SetNormalColor(Fore, Back : Byte);
    FUNCTION YNPrompt(Default : Boolean) : Boolean;
  end;

{********************************************************************}

IMPLEMENTATION

Uses Util;

{--------------------------------------------------------------------}

CONSTRUCTOR TPrompts.Init;
 begin
   TBBS.Init;
   CNorm := $07;
   CHighlight := $0E;
 end;

{--------------------------------------------------------------------}

PROCEDURE TPrompts.ChangeColor(Color : Byte);
 begin
   ComWrite(EmuColor(Color AND $0F, Color SHR 4));
 end;

{--------------------------------------------------------------------}

PROCEDURE TPrompts.CRPrompt;
 Var
   St : String[1];

 begin
   ChangeColor(CNorm);
   ComWrite('Press ');
   ChangeColor(CHighlight);
   ComWrite('Enter');
   ChangeColor(CNorm);
   ComWrite(' to continue...');
   ComReadLn(St, 0);
 end;

{--------------------------------------------------------------------}

FUNCTION TPrompts.Prompt(Strn : String) : Char;
 Var
   Valid : String;
   Ch    : Char;
   Key   : Boolean;
   Index : Byte;

 begin
   Key := False;
   Valid := '';
   for Index := 1 to Length(Strn) do
    begin
      if (Strn[Index] = '~') then
       begin
         Key := not Key;
         if (Key) then
          begin
            if (Color) then
               ChangeColor(CHighlight)
            else
               ComWrite('[');
            Valid := Valid + Strn[Index + 1];
          end
         else
            if (Color) then
               ChangeColor(CNorm)
            else
               ComWrite(']');
       end
      else
         ComWrite(Strn[Index]);
    end;
   Valid := Upper(Valid);
   Repeat
     Ch := UpCase(ComReadKey);
   Until (Pos(Ch, Valid) > 0);
   Prompt := Ch;
 end;

{--------------------------------------------------------------------}

PROCEDURE TPrompts.SetHighlightColor(Fore, Back : Byte);
 begin
   CHighlight := (Back * 16) + Fore;
 end;

{--------------------------------------------------------------------}

PROCEDURE TPrompts.SetNormalColor(Fore, Back : Byte);
 begin
   CNorm := (Back * 16) + Fore;
 end;

{--------------------------------------------------------------------}

FUNCTION TPrompts.YNPrompt(Default : Boolean) : Boolean;
 Var
   Ch : Char;

 begin
   if (Default) then
    begin
      ChangeColor(CNorm);
      ComWrite('(');
      ChangeColor(CHighlight);
      ComWrite('Y');
      ChangeColor(CNorm);
      ComWrite('/n): ');
    end
   else
    begin
      ChangeColor(CNorm);
      ComWrite('(y/');
      ChangeColor(CHighlight);
      ComWrite('N');
      ChangeColor(CNorm);
      ComWrite('): ');
    end;
   Repeat
     Ch := UpCase(ComReadKey);
   Until (Ch = 'Y') or (Ch = 'N') or (Ch = #13) or (CarrierLost);
   if ((Default) and (Ch = #13)) or (Ch = 'Y') then
    begin
      ComWriteLn('Yes.');
      YNPrompt := True;
    end
   else
    begin
      ComWriteLn('No.');
      YNPrompt := False;
    end;
 end;

{********************************************************************}

END.
