(* This is a test program for the TSUNTF.TPU unit
   All rights reserved 19-Aug-89
   Updated 23-Sep-89, 21-Mar-90, 20-Sep-92, 23-Jan-93, 27-Jan-99
*)

uses Dos,
     FDelay,
     Crt,
     TSUNTF;

procedure LOGO;
begin
  writeln;
  writeln ('TSUNTF unit test by Prof. Timo Salmi, Wed 27-Jan-99');
  writeln ('University of Vaasa, Finland, ts@uwasa.fi');
{$IFDEF VER40}
  writeln ('TP version 4.0');
{$ENDIF}
{$IFDEF VER50}
  writeln ('TP version 5.0');
{$ENDIF}
{$IFDEF VER55}
  writeln ('TP version 5.5');
{$ENDIF}
{$IFDEF VER60}
  writeln ('TP version 6.0');
{$ENDIF}
{$IFDEF VER70}
  writeln ('TP version 7.0');
{$ENDIF}
  writeln;
  writeln ('....:....1....:....2....:....3....:....4....:....5....:....6....:....7....:....');
end;  (* logo *)

(* Input line-editing *)
procedure TEST1;
var sj     : string;
    prompt : string;
    tmp    : string;
begin
  prompt := 'Give your input> ';
  FillChar (tmp, SizeOf(tmp), '.');  { If you are wondering about these two, }
  tmp[0] := chr(Length(prompt));     { they just produce points to show where}
  repeat                             { we are.                               }
    EDRDLN (prompt, sj);
    writeln (tmp, sj);
  until sj = 'exit';
end;  (* test1 *)

(* Input line-editing with recall potential *)
procedure TEST2;
var sj     : string;
    old    : string;
    prompt : string;
begin
  prompt := 'Give your input> ';
  old := '';
  repeat
    EDREADLN (prompt, old, sj);
    writeln (sj);
    old := sj;
  until sj = 'exit';
end;  (* test2 *)

(* Iput line-editing with recall and break potential *)
procedure TEST3;
var sj     : string;
    old    : string;
    prompt : string;
    tmp    : string;
    BreakPressed : boolean;
begin
  prompt := 'Give your input> ';
  old := '';
  repeat
    EDREABLN (prompt, old, 79, sj, BreakPressed);
    writeln (sj);
    old := sj;
  until BreakPressed;   {Press ctrl-c or break}
  writeln ('Break was pressed');
end;  (* test3 *)

(* Test input line-editing with recall and pre-fill potential.
   Important, you must always assign a value to the PrefillString
   before invoking this routine. Else you will have a random default
   with unexpected results *)
procedure TEST4;
var sj      : string;
    old     : string;
    prompt  : string;
    prefill : string;
begin
  prompt := 'Give your input> ';
  prefill := 'Testing for the prefill';
  old := prefill;
  repeat
    EDRDEFLN (prompt, old, prefill, sj);
    prefill := '';
    writeln (sj);
    if sj <> '' then old := sj;
  until sj = 'exit';
end;  (* test4 *)

(* Test input line-editing with recall and pre-fill potential.
   Important, you must always assign a value to the PrefillString
   before invoking this routine. Else you will have a random default
   with unexpected results *)
procedure TEST5;
var sj      : string;
    old     : string;
    prompt  : string;
    prefill : string;
    BreakPressed : boolean;
begin
  prompt := 'Give your input> ';
  prefill := 'Testing for the prefill';
  old := prefill;
  repeat
    EDRDEBLN (prompt, old, prefill, 79, sj, BreakPressed);
    prefill := '';
    writeln (sj);
    if sj <> '' then old := sj;
  until BreakPressed;   {Press ctrl-c or break}
  writeln ('Break was pressed');
end;  (* test5 *)

(* Main program *)
begin
  ClrScr;
  LOGO;
  { TEST1; }
  { TEST2; }
  { TEST3; }
  TEST4;
  { TEST5; }
end.  (* tsuntf.tst *)
