; Be WARNED. This code worked on MY PC for the purposes I intended
; I do not accept responsibility for any damage direct or consequential
; form the use of this software or modified versions of it.
;
; You use this software AT YOUR OWN RISK
;
; Peter Waltenberg, Christchurch New Zealand
;
;  On the other hand I'd like all the credit if it's useful, so I'd
;  appreciate my name staying in here.
;
;
; Machine code for slow down a PC to a crawl program
; Companion 'C' routine places the machine in single step mode
; This slows a 386SX-25 down to about 1/3 XT speed
; 40MHz 486DLC -> 0.9 XT
; 50MHz 486DX  -> 1.2 XT
;
; This program was written to allow me to use an Eprom Programmer with
; software written in the XT days on my '386, as software timing loops
; were used I needed cycle by cycle slowdown of the processor, not
; just chunks of time removed
;
; (
;       In my case setting up the trap interrupt and re-enabling it on
;       each int10h (video) call was enough... but some cases may be tougher
; )
;
; SURPRISE ... it worked
;
; It even worked in a single DOS window under Windows 3.1 Enhanced mode
;
; (
;       and it made one of my co-workers wonder why WIN3.1 took 5 minutes to
;       start up on his shiny new 50MHz 486 DX :>
; )
;
; In an ideal world setting the TRAP FLAG (TF) should be enough
; but some routines play with the flag register directly (Clearing TF)
; and you may not want the processor slowed down in ALL routines
; so the code below provides a do it yourself kit for tweaking things
;
;
; Interrupt entry that allow the underlying interrupt to execute at (near)
; full speed - int21h is a good choice
;
FASTENTRY MACRO
         push ax
         pushf
         pop  ax
         and  ax,0efh   ; clear trap flag
         push ax
         popf
         pop  ax
         ENDM
;
; Interrupt trap that executes the interrupt code slowly as well
; possibly int10h if slow video is desired
;
SLOWENTRY MACRO
          ENDM
;
; Complicated case like int21h where the routine plays with the stack to allow
; it to return with flags changed. We have to grab the current flags
; and copy them to our returned flags
;
SLOW_RETURN_FLAGS MACRO vector

         pushf
         db  09ah
vector   dw 0,0
         push   bp      ;grab stack frame
         mov    bp,sp
         push   ax      ; save ax
         pushf          ; copy flags to ax
         pop  ax
         or   ax,0100h  ; set trap flag but keep other bits as returned
         mov   word ptr[bp+6],ax   ; modify the returned flags
         pop   ax       ; restore ax
         pop  bp        ; restore bp
         iret           ; do trapped return

         ENDM
;
; Simple interrupt return (like int10h) where the routine does not
; play with the stack to return data in the flags
;
SLOW_RETURN_NOFLAGS MACRO vector
          pushf
          db   09ah
vector    dw   0,0
          push  bp
          mov   bp,sp
          or   word ptr[bp+6],0100h     ; set trap flag in returned flags
          pop  bp
          iret

          ENDM
;
; Macro to generate code to copy 'C' addressable vectors to inline self modifying code
;
COPYVECTOR MACRO vect,_vect
        mov   ax,[_vect]
        mov   [cs:vect],ax
        mov   ax,[_vect+2]
        mov   cs:[vect+2],ax
        ENDM
;
; Macro to generate 'C' addressable vectors
;
ADD_C_VECTOR MACRO vect
vect        dw 0,0
        ENDM
;
; You have to define both the vector table for the old int vectors
; and the entry points of the new routines as public
;
public _fslowit,__setup
public _int21vec,_int16vec,_int10vec,_int13vec,_int10,_int13,_int16,_int21
;
; Set up a data segment 'C' will address and save our old int vectors in it
;
DGROUP	group	_DATA,_BSS
;
; DATA segment is accessable from 'C' without segment fixup problems
; so the 'C' program sets these up and calls __setup which mods the
; self modifying code
; Note that extra entries here are just not used or called
; You get a link error if you miss something important
;
_DATA	segment word public 'DATA'
ADD_C_VECTOR _int10vec
ADD_C_VECTOR _int13vec
ADD_C_VECTOR _int16vec
ADD_C_VECTOR _int21vec
_DATA	ends
_BSS	segment word public 'BSS'
_BSS	ends
;
; Program segment
;
CODE segment byte public 'CODE'
     assume cs:CODE,ds:DGROUP,es:nothing
;
; Some of the PC's interrupts turn TF back off this traps
; the necessary ints (int 10 in my case
; and turns TF ON again at the end
; note that in some cases it may pay to turn TF OFF on int entry
;
; as it turned out traping int10h was sufficient for my applications
;
; Define the interrupts we treat specially, either to crank the CPU up
; on entry and back down on exit
;
; or just down on exit 'cos they crank themselves up
;
_int10   proc far
         FASTENTRY
         SLOW_RETURN_NOFLAGS int10vec
         endp


_int13   proc far
         FASTENTRY
         SLOW_RETURN_NOFLAGS int13vec
         endp

_int16   proc far
         FASTENTRY
         SLOW_RETURN_NOFLAGS int16vec
         endp
;
; Note the code for int21h below
; the interrupt routine plays with the stack and APPEARS to do a far retn
; rather than an iret so that the flags can be modified for return values
;
; we also speed up the DOS stuff by turning single stepping off here
;

_int21   proc far
         FASTENTRY
         SLOW_RETURN_FLAGS int21vec
         endp
;
; Setup mod's the self modifying code sections by copying the table 'C'
; has set up
; Note that this is lot bit of a kludge.
;
; Extra (unused entries here do no harm) , routine is never called
; Missed entries will do an int0 and crash the machine
;
__setup   proc  far
        COPYVECTOR int10vec,_int10vec
        COPYVECTOR int13vec,_int13vec
        COPYVECTOR int16vec,_int16vec
        COPYVECTOR int21vec,_int21vec
        ret
        endp
;
; Guts & feathers, this seemed SOOO easy when I first looked at it
; This is the single step routine
; note that TF is cleared on each call so we need to reset it
;
; This SEEMS to be the minimum code- if you need it slower (SEXIUM perhaps :)
; pads it with nop's or use the cx loop commented out
;
;
_fslowit proc far
;      push cx
;      mov  cx,1
;      loop $
;      pop  cx

       iret

       endp
CODE   ends
       end
