static char author[] = {"\x1bPeter Waltenberg, Christchurch New Zealand"};
static char what[] = {__TIME__ __DATE__ __FILE__};
static char Email[] = {"Email:Internet PeterW@tutu.chch.cri.nz"};
/*
   DISCLAIMER
   You use and or modify this software at your own risk.
   I accept no responsibility for any damge direct or consequential
   caused by this software or modified versions of it

   However if it's of any use I at least expect the credit for this so
   be nice and leave my name in the source. (please)
*/
/*
   PURPOSE
   This software was written to allow me to use an EPROM programmer
   with software written for a PC XT in my 386 SX-25. The software
   contained hardwired timing delays and a speed adjust algorithm which
   couln't cope with a 386.
   I needed a routine which slowed down a PC on a cycle by cycle basis
   rather than stealing CPU time in chunks.
*/
/*
   HOW ITS DONE
   This program slows the PC down by keeping the CPU in single step mode.
   (and this wasn't as easy as I thought it would be)

   This is too slow on a 386SX-25 (1/3 XT speed) but usable
   A 486-50 comes out at around 1.2XT speed

   The source is supplied so you can tweak things if you need to.

   Note that various things in a PC will drop the CPU out of single step
   mode.

   In my case all I needed to 'fix' was int10h , but I've thrown in the patch
   for 'fix' ing int21h as well. (Which is completely different)
*/
/*
   USAGE
   slow progname  (no parameters to progname passed )
   will run progname in slow mode then return
   in fast mode when progname terminates

   slow (no paramteres at all)
   will spawn command.com, type exit to return to normal operation
*/
/*
    UNEXPECTED THINGS
    this works in a DOS window in WIN3.1 enhanced mode.
    (I didn't believe it when I saw it)
    If run before WIN3.1 it slows it ALL down
    ( And I believed this even less)
*/
/*
    COMPILING
    Compile under LARGE model, you need to alter both SS.ASM and SLOW.C
    if you add extra interrupt traps
*/

#include "dos.h"
/* define what a pointer to an interrupt handler looks like */

typedef void interrupt (far *ISR)();

/* externals */
void interrupt fslowit(); /* single step interrupt handler */
int far _setup(void);     /* routine to generate self modifying code inline */
/* UNCLEAN UNCLEAN ..................... (go sit on a CONST segment) */
void interrupt int10();
void interrupt int13();
void interrupt int16();
void interrupt int21();

extern ISR int10vec,int13vec,int16vec,int21vec;


ISR oldvec;  /* place to save our old single step routine */




main(int argc,char *argv[])
{
        oldvec = getvect(1); /* old single step int */
        setvect(0x01,&fslowit);   /* new single step int */
        int10vec = getvect(0x10);  /* replace int10h */
        setvect(0x10,&int10);
/*
        int13vec = getvect(0x13); /* these MAY NOT WORK !!!!! */
        setvect(0x13,&int13);        /* check doc's to see if int10h or int21h style is needed */
        int16vec = getvect(0x16);
        setvect(0x16,&int16);
*/
        int21vec = getvect(0x21); /* replace int21h  (not needed , I'm just showing how clever I am ) */
        setvect(0x21,&int21);

        _setup();                  /* generate int handlers */
                                   /* note: need old int vectors found above FIRST */

        asm  pushf                 /* shove it ...... */
        asm  pop ax
        asm  or  ah,1  /* set trap flag */
        asm  push ax
        asm  popf                  /* into single step mode */
        /* slowly shell out */
        if(argc <= 1)  system("command");
        else system(argv[1]);

        asm  pushf                 /* stop single stepping */
        asm  pop ax
        asm  and ah,0x0e  /* clear trap flag */
        asm  push ax
        asm  popf                  /* AHHHHHHHHHHHHHHhh */
        setvect(1,oldvec);         /* restore old single step int */
        setvect(0x10,int10vec);    /* and the old int10h */
/*
        setvect(0x13,int13vec);
        setvect(0x16,int16vec);
*/
        setvect(0x21,int21vec);    /* and my old friend DOS services */
                                   /* with friends like this who needs ..... */

        return(0);                 /* more muffle the compiler crud */
}


