
; Store interrupt vector
STOVECT        MACRO  INTNO,WHERE
               MOV    AX,3500H OR INTNO
               INT    21H
               MOV    WHERE,BX
               MOV    CS:[WHERE+2],ES
               ENDM

; set interrupt vector
SETVECT        MACRO  INTNO,SUBR
               CLI
               MOV    AX,2500H OR INTNO
               MOV    DX,OFFSET CS:SUBR
               INT    21H
               STI
               ENDM

; reset interrupt vector
RESETVECT      MACRO  INTNO,FROM
               CLI
               PUSH   DS
               MOV    AX,2500H OR INTNO
               LDS    DX,DWORD PTR CS:[FROM]
               INT    21H
               POP    DS
               STI
               ENDM

; compare interrupt vector
CMPVECT        MACRO  INTNO, WHERE, FAIL
               LOCAL  C1,C2
               MOV    AX,3500H OR INTNO
               INT    21H
               CMP    BX,OFFSET CS:WHERE
               JZ     C2
C1:
               JMP    FAIL
C2:
               MOV    BX,CS
               MOV    AX,ES
               CMP    AX,BX
               JNZ    C1
               ENDM

;*******************************************************************
;               macro Define Area
;
;*******************************************************************
.push           macro   r0,r1,r2,r3,r4,r5,r6,r7,r8,r9,r10
  irp $reg,<r0,r1,r2,r3,r4,r5,r6,r7,r8,r9>
    IFB <$reg>
      exitm
    ELSEIFIDNI <$reg>,<FLAGS>
                pushf
    ELSE
                push    $reg
    ENDIF
  endm
endm

.pop            macro   r0,r1,r2,r3,r4,r5,r6,r7,r8,r9,r10
  irp $reg,<r9,r8,r7,r6,r5,r4,r3,r2,r1,r0>
    IFNB <$reg>
      IFIDNI <$reg>,<FLAGS>
                popf
      ELSE
                pop     $reg
      ENDIF
    ENDIF
  endm
endm

