
; **************************************************************
; *             tsrint09
; *
; * Description : keyboard interrupt
; *
; *
; *
; **************************************************************
tsrint09        proc    far

                .push   ax                      ;

                in      al,060h                 ;
                ;-------------------------------
                ; check ESC pressed
                inc     cs:EscPress0            ;
                cmp     al,01h                  ;ESC been pressed ?
                jz      tsrn9_000               ;yes
                mov     cs:EscPress0,0          ;no,
                ;-------------------------------
                ; don't do anything if stopped, poped, not TSR or
                ; RING not eq 0
tsrn9_000:      cmp     cs:ComState,COMM_CONN   ;
                jz      tsrn9_001               ;
                cmp     cs:Arg_func,0           ;TSR ?
                jnz     tsrn9_001               ;
                cmp     cs:ComRing,0            ;auto answer ?
                jnz     tsrn9_001               ;yes, don't need hotkey
                cmp     cs:TsrStoped,1          ;
                jz      tsrn9_001               ;
                cmp     cs:TsrPoped,1           ;TSR is running ?
                jz      tsrn9_001               ;yes, quit
                cmp     cs:ComState,COMM_IDLE   ;
                jnz     tsrn9_001               ;
                ;-------------------------------
                ; check hotkey
                cmp     al,cs:HotScan0          ;a hotkey scan code ?
                jnz     tsrn9_001               ;no.
                ;-------------------------------
                push    es                      ;
                xor     ax,ax                   ;
                mov     es,ax                   ;
                mov     al,es:[417h]            ;
                pop     es                      ;
                and     al,cs:ShiftMsk0         ;
                cmp     al,cs:ShiftMsk0         ;
                jnz     tsrn9_001               ;
                in      al,61h                  ;eat keystroke and set flag
                mov     ah,al                   ;
                or      al,80h                  ;
                out     61h,al                  ;
                mov     al,ah                   ;
                out     61h,al                  ;
                mov     al,020h                 ;ack hw interrupt
                out     020h,al                 ;
                mov     cs:TsrPopReq,1          ;
                mov     cs:PopUpState,POPUP_ATA ;
                jmp     tsrn9_ret               ;
                ;-------------------------------
tsrn9_001:      pushf                           ;
                db      09ah                    ;call
host09_o        dw      ?,?                     ;
tsrn9_ret:      .pop    ax                      ;
                iret                            ;

tsrint09        endp

; **************************************************************
; *             tsrnt10
; *
; * Description : videoio flag
; *
; *
; *
; **************************************************************
tsrint10        proc    far

                mov     cs:VideoBusy,1          ;
                pushf                           ;
                db      09ah                    ;
host10_o        dw      ?,?                     ;
                mov     cs:VideoBusy,0          ;
                iret

tsrint10        endp

; **************************************************************
; *             tsrint13
; *
; * Description : diskio flag
; *
; *
; *
; **************************************************************
tsrint13        proc    far

                mov     cs:DiskBusy,1           ;
                pushf                           ;
                db      09ah                    ;
host13_o        dw      ?,?                     ;
                mov     cs:DiskBusy,0           ;
                ret     2                       ;retur and pop flag

tsrint13        endp

; **********************************************************************
; *             tsrint1b
; *
; * Description :
; *
; *
; *
; **********************************************************************
host1b_o        dw      ?,?                     ;
tsrint1b        proc    far
                iret
tsrint1b        endp

; **********************************************************************
; *             tsrint1c
; *
; * Description :
; *
; *
; *
; **********************************************************************
tsrint1c        proc    far

                ;------ call old timer routine
                pushf                           ;
                db      09ah                    ;
host1c_o        dw      ?,?                     ;
                ;-------------------------------
                dec     cs:TickCnt              ;
                jg      zint1c_001              ;
                mov     cs:TickCnt,18           ;maintain one second
                inc     cs:TickSec              ;
                cmp     cs:TickSec,60           ;
                jl      zint1c_001              ;
                inc     cs:TickMin              ;
                cmp     cs:TickMin,60           ;
                jl      zint1c_000              ;
                mov     cs:TickMin,0            ;
zint1c_000:     mov     cs:TickSec,0            ;
                ;-------------------------------
                ; new timer interrupt
zint1c_001:     cmp     cs:TimeTick00,0         ;
                jz      tsrint1c_000            ;
                dec     cs:TimeTick00           ;
tsrint1c_000:   cmp     cs:TimeTick2,0          ;used for the thruput display
                jz      tsrint1c_001            ;
                dec     cs:TimeTick2            ;
tsrint1c_001:   cmp     cs:PopUpState,POPUP_NONE
                jnz     irqok1                  ;
                .push   ax,dx                   ;
                mov     dx,cs:ComIER            ;9
                in      al,dx                   ;
                test    al,1                    ;
                jnz     irqok0                  ;
                mov     cs:TsrPopReq,1          ;
                mov     cs:PopUpState,POPUP_INT
                        ;-----------------------
irqok0:         .pop    ax,dx                   ;
irqok1:         cmp     cs:TimeTick1,0          ;
                jz      tsrint1c_002            ;
                dec     cs:TimeTick1            ;
                test    cs:TimeTick1,0Fh        ;
                jnz     tsrint1c_002            ;
               ;cmp     cs:TsrStoped,0          ;
               ;jnz     tsrint1c_002            ;
                .push   ax,cx,si,di,es,ds       ;
                push    cs                      ;
                pop     ds                      ;
                mov     es,cs:TsrVidseg         ;
                mov     di,cs:MsgPassPos        ;
                mov     cx,23                   ;
                lea     si,cs:MsgPassStr        ;
                mov     ah,cs:MsgPassAttr       ;CYAN+LIGHTRED
tsrint1c_0:     lodsb                           ;
                cmp     al,0                    ;
                jz      tsrint1c_1              ;
                stosw                           ;
                loop    tsrint1c_0              ;
                jmp     tsrint1c_2              ;
tsrint1c_1:     jcxz    tsrint1c_2              ;
                mov     al,' '                  ;
                rep     stosw                   ;
tsrint1c_2:     .pop    ax,cx,si,di,es,ds       ;
tsrint1c_002:   inc     cs:Ringtime             ;
                cmp     cs:Ringtime,20*18       ;
                jb      tsrint1c_003            ;
                mov     cs:Ringtime,0           ;
                mov     cs:Ringcnt0,0           ;
                mov     cs:Ringcnt1,0           ;
                ;-------------------------------
tsrint1c_003:   cmp     cs:TsrStoped,1          ;stopped ?
                jz      tsrint1c_ret            ;yes,
                cmp     cs:TsrPoped,1           ;poped ?
                jz      tsrint1c_ret            ;yes,
                cmp     cs:ComState,COMM_IDLE   ;
                jz      tsrint1c_004            ;
                cmp     cs:TimerCom,0           ;
                jz      tsrint1c_004            ;
                dec     cs:TimerCom             ;
                jnz     tsrint1c_004            ;
?tsr:           mov     cs:TsrPopReq,1          ;
                mov     cs:PopUpState,POPUP_DISC
tsrint1c_004:   cmp     cs:TsrPopReq,0          ;
                jz      tsrint1c_ret            ;
                call    chktsrpop               ;
                jc      tsrint1c_ret            ;
                mov     cs:TsrPopReq,0          ;
                push    ax                      ;
                mov     al,20h                  ;
                out     20h,al                  ;
                pop     ax                      ;
                sti                             ;
                call    Go_Popup                ;
tsrint1c_ret:   iret                            ;

tsrint1c        endp

; **********************************************************************
; *             tsrint21
; *
; * Description :
; *
; *
; *
; **********************************************************************
tsrint21        proc    far

                pushf                           ;
                cmp     cs:TsrPopReq,0          ;
                jz      tsrint21_old            ;
                cmp     cs:TsrStoped,1          ;stopped ?
                jz      tsrint21_old            ;yes
                cmp     ah,62h                  ;
                ja      tsrint21_old            ;
                call    chktsrpop               ;
                jc      tsrint21_old            ;
                sti                             ;
                call    Go_Popup                ;
tsrint21_old:   popf                            ;
                db      0eah                    ;
host21_o        dw      ?,?                     ;

tsrint21        endp


; **********************************************************************
; *             tsrint23
; *
; * Description :
; *
; *
; *
; **********************************************************************
host23_o        dw      ?,?                     ;
tsrint23        proc    far
                iret
tsrint23        endp


; **********************************************************************
; *             tsrint24
; *
; * Description :
; *
; *
; *
; **********************************************************************
host24_o        dw      ?,?                     ;
tsrint24        proc    far
                xor     al,al
                iret
tsrint24        endp

; **************************************************************
; *             tsrint25
; *
; * Description : absolute disk sector read
; *
; *
; *
; **************************************************************
tsrint25        proc    far

                mov     cs:AbsRdBusy,1          ;
                db      09ah                    ;
host25_o        dw      ?,?                     ;
                mov     cs:AbsRdBusy,0          ;
                ret                             ;retur and pop flag

tsrint25        endp


; **************************************************************
; *             tsrint26
; *
; * Description : absolute disk sector write
; *
; *
; *
; **************************************************************
tsrint26        proc    far

                mov     cs:AbsWrBusy,1          ;
                db      09ah                    ;
host26_o        dw      ?,?                     ;
                mov     cs:AbsWrBusy,0          ;
                ret                             ;retur and pop flag

tsrint26        endp

; **************************************************************
; *             tsrint28
; *
; * Description :   This function
; *
; *
; *
; **************************************************************
tsrint28        proc    far

                pushf                           ;
                db      09ah                    ;
host28_o        dw      ?,?                     ;
                cmp     cs:TsrPopReq,0          ;
                jz      tsrint28_000            ;
                cmp     cs:TsrStoped,0          ;stopped ?
                jnz     tsrint28_000            ;yes
                call    chktsrpop               ;
                jc      tsrint28_000            ;
                mov     cs:TsrPopReq,0          ;
                sti                             ;
                call    Go_Popup                ;
tsrint28_000:   iret

tsrint28        endp

; **********************************************************************
; *             tsrint2a
; *
; * Description :
; *
; *
; *
; **********************************************************************
tsrint2a        proc    far

                push    ax                      ;
                and     ax,0ff00h               ;
                cmp     ax,8000h                ;
                jnz     tsrint2a_000            ;
                inc     cs:DosCrit              ;
                jmp     tsrint2a_002            ;
tsrint2a_000:   cmp     ax,8100h                ;
                jz      tsrint2a_001            ;
                cmp     ax,8200h                ;
                jnz     tsrint2a_002            ;
tsrint2a_001:   cmp     cs:DosCrit,0            ;
                jz      tsrint2a_002            ;
                dec     cs:DosCrit              ;
tsrint2a_002:   pop     ax                      ;
                db      0eah                    ;jmp far old2a
host2a_o        dw      ?,?                     ;

tsrint2a        endp



; **************************************************************
; *             tsrint2f
; *
; * Description :   This function
; *
; *
; *
; **************************************************************
tsrint2f        proc    far

                cmp     ah,cs:TsrSig            ;my signature ?
                jz      tsrint2f_000            ;yes,
                db      0eah                    ;jmp
host2f_o        dw      ?,?                     ;
                ;--------------------------------
                ; al=0 -> check if installed
                ; al=1 -> uninstall
                ; al=2 -> TSR go
                ; al=3 -> TSR stop
tsrint2f_000:   or      al,al                   ;
                jnz     tsrint2f_001            ;
                mov     ah,cs:TsrStoped         ;
                mov     al,'Z'                  ;
                iret                            ;

                ; uninstall TSR
tsrint2f_001:   dec     al                      ; AL=1 set key codes
                jnz     tsrint2f_002            ;
                sti                             ;
                call    KillTsr                 ;
                jnc     tsrint2f_ret            ;
                mov     al,1                    ;
tsrint2f_ret:   iret                            ;

                ; check for the reset stop command
tsrint2f_002:   dec     al                      ; AL=2 reset stopped flag
                jnz     tsrint2f_003            ;
                mov     cs:TsrStoped,0          ;
                iret                            ;

                ; check for the set stop command
tsrint2f_003:   dec     al                      ; AL=3 set stopped flag
                jnz     tsrint2f_ret            ;
                mov     cs:TsrStoped,1          ;
                iret

tsrint2f        endp


; **************************************************************
; *             chktsrpop
; *
; * Description :   This function
; *
; *
; *
; **************************************************************
chktsrpop       proc    near

                .push   ax,es                   ;
                xor     ax,ax                   ;check for PrnScr
                mov     es,ax                   ;
                mov     al,es:[500h]            ;
                cmp     al,1                    ;
                jz      pop_no                  ;can not popup
                mov     al,0bh                  ;OCW3, read ISR
                out     20h,al                  ;
                jmp     ?next                   ;
?next:          in      al,20h                  ;
                or      al,cs:TsrPoped          ;poped ?
                or      al,cs:VideoBusy         ;int 10
                or      al,cs:DiskBusy          ;int 13
                or      al,cs:AbsRdBusy         ;int 25
                or      al,cs:AbsWrBusy         ;int 26
                or      al,cs:DosCrit           ;unsafe ?
                jnz     pop_no                  ;
                clc                             ;
                jmp     chktsrpop_ret           ;
pop_no:         stc                             ;
chktsrpop_ret:  .pop    ax,es                   ;
                ret

chktsrpop       endp

