

ZlogFpth0       db      81      dup(0)                  ;
logfname        db      'rcvfax.log',0                  ;
Logfpth         db      80      dup(0)          ;
LogHead0        db      ''
                db      'ͻ',13,10
                db      '  DATE  TIME   FILE      REMOTE F'
                db      'AX NUMBER     SPEEDELAPSE RESULT ',13,10
                db      ''
                db      'Ķ',13,10
LogTail0        db      0

LogHead1        db      ''                             ;
LogDate0        dw      '00'                            ;
                db      '-'                             ;
LogDate1        dw      '00'                            ;
                db      '-'                             ;
LogDate2        dw      '00'                            ;
                db      ''                             ;
LogTime0        dw      '00'                            ;
                db      ':'                             ;
LogTime1        dw      '00'                            ;
                db      ''                             ;
filename        db      '?????'                         ;
fileext         db      '.'                             ;
fileext0        db      '0'                             ;
fileext1        db      '0'                             ;
fileext2        db      '0'                             ;
                db      ''                             ;
LogFaxnum       db      25      dup(' ')                ;
                db      ''                             ;
LogSpeed        db       5      dup(' ')                ;
                db      ''                             ;
LogMin          dw      0                               ;
                db      ':'                             ;
LogSec          dw      0                               ;
                db      ' '                             ;
                db      ''                             ;
                db      ' '                             ;
LogResult       db      6       dup(' ')                ;
                db      ' '                             ;
                db      '',13,10                       ;
LogTail1        db      0                               ;

MsgStr0         db      'Answering ...',0               ;
MsgStr1         db      'Receiving Page '               ;
MsgPage         dw      0                               ;
                db      0                               ;
MsgErrStr       db      ' Fail to receive',0            ;
MsgConnStr      db      ' Connect OK',0                ;
MsgOkStr        db      'Save to File '                 ;
Msgfname        db      10      dup(0)                  ;
MsgPassStr      db      30      dup(0)                  ;


ErrStrOK        db      'OK    '                        ;
ErrStrUSER      db      'USRABT'                        ;
ErrStrCOM       db      'COMERR'                        ;
ErrStrFAIL      db      'FAIL  '                        ;

MonthStr        db      'Jan','Feb','Mar','Apr','May','Jun','Jul','Aug'
                db      'Sep','Oct','Nov','Dec'

FaxHead         db      'ZyXEL',0               ;
head_facid      dw      'Z'                     ;factory ID
head_version    dw      02h                     ;Version
head_pbits      dw      0                       ;scan line length
head_pages      dw      0                       ;total pages
head_kline      dw      0                       ;resolution
pbits           dw      1728,2048,2432          ;

FaxAnswer       db      0                       ;has been answered
tmp_irq         db      0                       ;

                ;------ 128 bytes --------------
logbuf_year0    dw      0                       ;
logbuf_date0    dw      0                       ;
logbuf_time0    dw      0                       ;
ConnMin0        db      0                       ;connect minutes
ConnSec0        db      0                       ;connect seconds
ConnSpeed0      db      0                       ;2400, 4800, 7200, 9600, 12000,
                                                ;14400.
ConnPage0       db      0                       ;A4, B4, A3
ConnCode0       db      0                       ;1-DN, 1-DH, 2-DN, 2-DH.
ConnDir0        db      1                       ;0-Tranmit, 1-Receive
ErrLvl0         dw      0                       ;
logbuf_fname0   db      80      dup(0)          ;
logbuf_faxnum0  db      25      dup(0)          ;
                db      9       dup(0)          ;
sch_header      db      'ZyXEL',1                       ;version and date
                dw      0,0,0                           ;
SchRecCnt       dw      0,0                             ;
Schfh           dw      0                               ;

; **************************************************************
; *             MainFunc
; *
; **************************************************************
public          MainFunc
MainFunc        proc    near

                mov     ax,cs                   ;
                mov     ds,ax                   ;
                mov     es,ax                   ;
                ;-------------------------------
                cmp     cs:PopUpState,POPUP_ATA ;send 'ata' to answer this
                jnz     mainfunc_000            ;call
                mov     cs:ErrLvl0,0            ;reset error level
                cmp     cs:TsrStoped,1          ;fore ground ?
                jz      mainfunc_0              ;yes
                call    SetSpeed                ;
                mov     dx,cs:ComLCR            ;
                mov     al,03h                  ;set parity ...
                out     dx,al                   ;
                call    ClearCom                ;
mainfunc_0:     call    InitModem               ;
                jc      ?m4                     ;abort
                lea     si,cs:AnsStr            ;send ATA
                mov     ax,9                    ;
                call    SendStr                 ;
                mov     cx,15                   ;
                lea     di,cs:MsgPassStr        ;
                lea     si,cs:MsgStr0           ;
                rep     movsb                   ;
                mov     cs:TimeTick1,16*32+1    ;
                call    sound                   ;
                mov     cs:FaxAnswer,1          ;
                clc                             ;
                jmp     mainfunc_ret            ;
                ;-------------------------------
                ; File Open ?
mainfunc_000:   cmp     cs:PopUpState,POPUP_OPEN;
                jnz     mainfunc_001            ;
                mov     cx,12                   ;
                lea     di,cs:MsgPassStr        ;
                lea     si,cs:MsgConnStr        ;
                rep     movsb                   ;
                mov     cs:TimeTick1,16*10+1    ;
                call    OpenFile                ;
?m4:            jmp     mainfunc_004            ;
                ;-------------------------------
                ; Reset Modem ?
mainfunc_001:   cmp     cs:PopUpState,POPUP_RESET
                jnz     mainfunc_002            ;
                cmp     cs:FaxAnswer,1          ;has been answer ?
                jnz     ?m4                     ;no.
                call    InitModem               ;
                jc      ?m4                     ;abort
                mov     cx,17                   ;
                lea     di,cs:MsgPassStr        ;
                lea     si,cs:MsgErrStr         ;
                rep     movsb                   ;
                mov     cs:TimeTick1,16*1+1     ;
                call    sound                   ;
                jmp     mainfunc_004            ;
                ;-------------------------------
                ; Buffer full ?
mainfunc_002:   cmp     cs:PopUpState,POPUP_INT ;
                jnz     mainfunc_005            ;
                mov     cs:FaxAnswer,0          ;
                call    ClearCom                ;
                jmp     mainfunc_004            ;
                ;-------------------------------
                ; Buffer full ?
mainfunc_005:   cmp     cs:PopUpState,POPUP_NONE;
                jz      ?m4                     ;
                mov     ax,cs:head_pages        ;
                inc     ax                      ;
                aam                             ;
                or      ax,3030h                ;
                xchg    al,ah                   ;
                mov     cs:MsgPage,ax           ;
                mov     cx,18                   ;
                lea     di,cs:MsgPassStr        ;
                lea     si,cs:MsgStr1           ;
                rep     movsb                   ;
                mov     cs:TimeTick1,16*70+1    ;
                cli                             ;
                mov     dx,cs:comrdbase         ;
                mov     cs:comrdhead,dx         ;
                mov     cx,cs:comrdcnt          ;
                mov     cs:comrdcnt,0           ;
                mov     bx,cs:Comrdfh           ;
                mov     ah,cs:IrqMsk            ;al=irq maskn
                in      al,21h                  ;
                mov     cs:tmp_irq,al           ;
                not     ah                      ;
                or      al,ah                   ;
                out     21h,al                  ;
                mov     ah,40h                  ;write to disk
                int     21h                     ;
                mov     al,cs:tmp_irq           ;
                out     21h,al                  ;
                sti                             ;enable interrupt
                cmp     cs:PopUpState,POPUP_DISC;
                jz      mainfunc_006            ;
mainfunc_004:   mov     al,0bh                  ;yes, high RTS, high DTR
                mov     dx,cs:ComMCR            ;MCR
                out     dx,al                   ;RTS high
mainfunc_ret:   mov     cs:PopUpState,POPUP_NONE;
                ret
                ;-------------------------------
                ; close file
mainfunc_006:   cmp     cs:Comrdfh,0            ;has been open ?
                jle     mainfunc_003            ;
                mov     cx,9                    ;
                lea     di,cs:Msgfname          ;
                lea     si,cs:filename          ;
                rep     movsb                   ;
                mov     cx,30                   ;
                lea     di,cs:MsgPassStr        ;
                lea     si,cs:MsgOkStr          ;
                rep     movsb                   ;
                mov     cs:TimeTick1,16*25+1    ;
                call    sound                   ;
                mov     bx,cs:Comrdfh           ;flush to disk
                xor     cx,cx                   ;
                xor     dx,dx                   ;
                mov     ax,4200h                ;
                int     21h                     ;
                mov     cx,16                   ;
                lea     dx,cs:FaxHead           ;
                mov     ah,40h                  ;
                int     21h                     ;
                mov     ah,3eh                  ;
                int     21h                     ;
                mov     cs:Comrdfh,-1           ;
                ;-------------------------------
mainfunc_003:   call    PutLog                  ;
                mov     dx,cs:ComMCR            ;lower the DTR
                mov     al,0ah                  ;
                out     dx,al                   ;
                mov     cs:TimeTick00,4         ;1/9 second
?m1:           ;mov     dx,cs:ComMSR            ;
               ;in      al,dx                   ;
               ;test    al,80h                  ;wait for DCD off
               ;jz      ?m2                     ;
                cmp     cs:TimeTick00,0         ;
                jnz     ?m1                     ;
?m2:            mov     cs:ComState,COMM_IDLE   ;
                mov     cs:FaxAnswer,0          ;
                push    ErrLvl0                 ;
                call    InitModem               ;
                pop     ErrLvl0                 ;
                jmp     mainfunc_004            ;

MainFunc        endp



; **************************************************************
;               InitModem
;
;
; **************************************************************
InitModem       proc    near

                cmp     ds:Comrdfh,5            ;
                jle     initm_000               ;
                mov     bx,ds:Comrdfh           ;close file
                mov     ah,3eh                  ;
                int     21h                     ;
                mov     cs:Comrdfh,-1           ;
                ;-------------------------------
initm_000:      mov     ax,18*3                 ;
                lea     si,ds:InitStr0          ;send initial command
                call    SendCmd                 ;
                jc      initm_ret               ;abort
                mov     ax,18*3                 ;
                lea     si,ds:ModeStr1          ;send initial command
                call    SendCmd                 ;
                jc      initm_ret               ;abort
                mov     ds:debugl,0             ;
                mov     ds:debugh,0             ;
                clc                             ;
initm_ret:      ret                             ;


InitModem       endp


; **************************************************************
; *             OpenFile
; *
; **************************************************************
OpenFile        proc    near

                mov     ax,cs                   ;
                mov     es,ax                   ;
                ;-------------------------------
                mov     ah,2ch                  ;
                int     21h                     ;
                mov     cs:logbuf_time0,cx      ;
                mov     al,ch                   ;
                aam                             ;
                xchg    al,ah                   ;
                or      ax,3030h                ;
                mov     cs:LogTime0,ax          ;
                mov     al,cl                   ;
                aam                             ;
                xchg    al,ah                   ;
                or      ax,3030h                ;
                mov     cs:LogTime1,ax          ;
                ;-------------------------------
                mov     ah,2ah                  ;get date
                int     21h                     ;
                mov     cs:logbuf_year0,cx      ;
                mov     cs:logbuf_date0,dx      ;
                mov     al,dh                   ;
                aam                             ;
                xchg    al,ah                   ;
                or      ax,3030h                ;
                mov     cs:LogDate0,ax          ;month
                mov     al,dl                   ;
                aam                             ;
                xchg    al,ah                   ;
                or      ax,3030h                ;
                mov     cs:LogDate1,ax          ;date
                mov     ax,cx                   ;
                sub     ax,1900                 ;
                aam                             ;
                xchg    al,ah                   ;
                or      ax,3030h                ;
                mov     cs:LogDate2,ax          ;year
                        ;-----------------------
                dec     dh                      ;
                mov     al,dh                   ;
                mov     cx,3                    ;
                mul     cl                      ;
                lea     si,cs:MonthStr          ;
                add     si,ax                   ;
                lea     di,cs:filename          ;
                rep     movsb                   ;move the month string
                mov     al,dl                   ;
                aam                             ;
                or      ax,3030h                ;
                xchg    al,ah                   ;
                stosw                           ;move the date string
                mov     cs:fileext,'.'          ;
                mov     cs:fileext0,'0'         ;
                mov     cs:fileext1,'0'         ;
                mov     cs:fileext2,'0'         ;
                ;-------------------------------
openfile_000:   lea     di,cs:Comrdfpth         ;
                add     di,cs:Comfpthcnt        ;
                lea     si,cs:filename          ;
                mov     cx,9                    ;
                rep     movsb                   ;
                mov     byte ptr es:[di],0      ;
                cli                             ;
                mov     ah,cs:IrqMsk            ;al=irq maskn, disable COM int
                in      al,21h                  ;
                mov     cs:tmp_irq,al           ;
                not     ah                      ;
                or      al,ah                   ;
                out     21h,al                  ;
                lea     dx,cs:Comrdfpth         ;open file
                mov     ah,5bh                  ;
                mov     cx,0                    ;
                int     21h                     ;
                xchg    cs:tmp_irq,al           ;
                out     21h,al                  ;
                xchg    cs:tmp_irq,al           ;
                sti                             ;enable interrupt
                jnc     openfile_001            ;
                cmp     ax,50h                  ;
                jnz     openfile_err            ;
                inc     cs:fileext2             ;
                cmp     cs:fileext2,'9'         ;
                jle     openfile_000            ;
                mov     cs:fileext2,'0'         ;
                inc     cs:fileext1             ;
                cmp     cs:fileext1,'9'         ;
                jle     openfile_000            ;
                mov     cs:fileext1,'0'         ;
                inc     cs:fileext0             ;
                cmp     cs:fileext0,'9'         ;
                jle     openfile_000            ;
                mov     cs:fileext0,'0'         ;
                jmp     openfile_000            ;
openfile_err:   stc                             ;
                jmp     openfile_ret            ;
                ;-------------------------------
openfile_001:   mov     cs:Comrdfh,ax           ;
                cli                             ;
                call    CheckLog                ;
                mov     ah,cs:IrqMsk            ;al=irq maskn
                in      al,21h                  ;
                mov     cs:tmp_irq,al           ;
                not     ah                      ;
                or      al,ah                   ;
                out     21h,al                  ;
                mov     bx,cs:Comrdfh           ;
                mov     cx,16                   ;
                lea     dx,cs:FaxHead           ;
                mov     ah,40h                  ;
                int     21h                     ;
                mov     al,cs:tmp_irq           ;
                out     21h,al                  ;
                xor     ax,ax                   ;
openfile_ret:   mov     cs:ErrLvl0,ax           ;
                sti                             ;enable interrupt
                ret                             ;

OpenFile        endp



; **************************************************************
; *             CheckLog
; *
; **************************************************************
CheckLog        proc    near

                mov     cs:TickCnt,18           ;
                mov     cs:TickSec,0            ;
                mov     cs:TickMin,0            ;
                mov     cs:head_pages,0         ;head_pages
                mov     cx,4                    ;
                lea     si,cs:ConnMsg           ;
                lea     di,cs:LogSpeed          ;speed
                rep     movsb                   ;
                mov     ConnSpeed0,0            ;
                cmp     ConnMsg,'2'             ;
                jz      Checklog_000            ;
                inc     ConnSpeed0              ;
                cmp     ConnMsg,'4'             ;
                jz      Checklog_000            ;
                inc     ConnSpeed0              ;
                cmp     ConnMsg,'7'             ;
                jz      Checklog_000            ;
                inc     ConnSpeed0              ;
                cmp     ConnMsg,'9'             ;
                jz      Checklog_000            ;
                mov     byte ptr ds:[di],'0'    ;
                inc     ConnSpeed0              ;
                cmp     [ConnMsg+1],'2'         ;
                jz      Checklog_000            ;
                inc     ConnSpeed0              ;
Checklog_000:   mov     al,ds:[si+1]            ;kline
                mov     ah,ds:[si+3]            ;
                lea     bx,ds:rcvrtc_2d         ;
                cmp     ah,'1'                  ;
                jz      Checklog_003            ;
                lea     bx,ds:rcvrtc_1d         ;
Checklog_003:   mov     ds:rtcbase,bx           ;
                mov     ds:rtchead,bx           ;
                sub     ax,3030h                ;
                shl     ah,1                    ;
                add     al,ah                   ;
                xor     ah,ah                   ;
                mov     ds:head_kline,ax        ;
                mov     ConnCode0,al            ;
                xor     bx,bx                   ;pbits
                mov     bl,ds:[si+5]            ;
                sub     bl,'0'                  ;
                mov     ConnPage0,bl            ;
                shl     bx,1                    ;
                add     bx,offset ds:pbits      ;
                mov     bx,ds:[bx]              ;
                mov     ds:head_pbits,bx        ;
                add     si,11                   ;
                mov     cx,24                   ;move fax number
                lea     di,ds:LogFaxnum         ;
                mov     al,' '                  ;
                rep     stosb                   ;
                mov     cx,24                   ;
                lea     bx,ds:LogFaxnum         ;
                lea     di,ds:logbuf_faxnum0    ;
Checklog_001:   lodsb                           ;
                cmp     al,0                    ;
                jz      Checklog_002            ;
                stosb                           ;
                mov     cs:[bx],al              ;
                inc     bx                      ;
                loop    Checklog_001            ;
Checklog_002:   lea     si,ds:Comrdfpth         ;open file
                lea     di,logbuf_fname0        ;
                mov     cx,79                   ;
                rep     movsb                   ;
                xor     ax,ax                   ;
                ret

CheckLog        endp


; **************************************************************
; *             PutLog
; *
; **************************************************************
public          PutLog
PutLog          proc    near

                mov     ax,cs                   ;
                mov     es,ax                   ;
                ;-------------------------------
                mov     al,cs:TickSec           ;
                mov     ConnSec0,al             ;
                aam                             ;
                xchg    al,ah                   ;
                or      ax,3030h                ;
                mov     LogSec,ax               ;
                mov     al,cs:TickMin           ;
                mov     ConnMin0,al             ;
                aam                             ;
                xchg    al,ah                   ;
                or      ax,3030h                ;
                mov     LogMin,ax               ;
                ;-------------------------------
                lea     si,ErrStrOK             ;
                cmp     ErrLvl0,ERR_NONE        ;
                jz      putlog_006              ;
                lea     si,ErrStrUSER           ;
                cmp     ErrLvl0,ERR_USRABT      ;
                jz      putlog_006              ;
                lea     si,ErrStrCOM            ;
                cmp     ErrLvl0,ERR_COMERR      ;
                jz      putlog_006              ;
                lea     si,ErrStrFAIL           ;
putlog_006:     mov     cx,6                    ;
                lea     di,LogResult            ;
                rep     movsb                   ;
                ;-------------------------------
                lea     di,ds:Logfpth           ;
                add     di,ds:Comfpthcnt        ;
                lea     si,ds:logfname          ;
                mov     cx,10                   ;
                rep     movsb                   ;
                lea     dx,ds:Logfpth           ;open file
                mov     ax,3d02h                ;
                int     21h                     ;
                mov     bx,ax                   ;
                jc      putlog_001              ;
                mov     ax,4202h                ;move to end of file
                xor     cx,cx                   ;
                xor     dx,dx                   ;
                int     21h                     ;
                jmp     putlog_002              ;
putlog_001:     mov     ah,3ch                  ;creat the log file
                xor     cx,cx                   ;
                int     21h                     ;
                mov     bx,ax                   ;
                mov     cx,offset cs:LogTail0-offset cs:LogHead0
                lea     dx,cs:LogHead0          ;
                mov     ah,40h                  ;
                int     21h                     ;
putlog_002:     mov     cx,offset LogTail1-offset LogHead1
                lea     dx,cs:LogHead1          ;
                mov     ah,40h                  ;
                int     21h                     ;
                mov     ah,3eh                  ;
                int     21h                     ;
                ;--------------------------------
                lea     dx,ZlogFpth0            ;
                mov     ax,3d02h                ;
                int     21h                     ;
                jc      putlog_003              ;
                mov     bx,ax                   ;
                lea     dx,sch_header           ;
                mov     ah,3fh                  ;read from file
                mov     cx,16                   ;
                int     21h                     ;
                jmp     putlog_004              ;
putlog_003:     xor     cx,cx                   ;creat the file
                lea     dx,ZlogFpth0            ;
                mov     ah,3ch                  ;
                int     21h                     ;
                jc      putlog_005              ;
                mov     bx,ax                   ;
                mov     SchRecCnt,0             ;
                lea     dx,sch_header           ;
                mov     cx,16                   ;
                mov     ah,40h                  ;
                int     21h                     ;
putlog_004:     mov     Schfh,bx                ;
                mov     ax,SchRecCnt            ;
                inc     SchRecCnt               ;
                call    SchMoveTo               ;
                mov     cx,128                  ;
                mov     bx,Schfh                ;
                lea     dx,logbuf_year0         ;
                mov     ah,40h                  ;
                int     21h                     ;
                xor     dx,dx                   ;
                xor     cx,cx                   ;
                mov     ax,4200h                ;
                int     21h                     ;
                lea     dx,sch_header           ;
                mov     cx,16                   ;
                mov     ah,40h                  ;
                int     21h                     ;
                mov     ah,3eh                  ;
                int     21h                     ;
                ;-------------------------------
putlog_005:     mov     al,'?'                  ;
                mov     cx,9                    ;
                lea     di,cs:filename          ;
                rep     stosb                   ;
                mov     cx,5                    ;
                lea     di,cs:LogSpeed          ;
                mov     al,' '                  ;
                rep     stosb                   ;
                ret

PutLog          endp



;***************************************************************************
;
;***************************************************************************
SchMoveTo       proc    near

                mov     bx,128                  ;
                mul     bx                      ;
                add     ax,16                   ;
                adc     dx,0                    ;
                mov     cx,dx                   ;
                mov     dx,ax                   ;
                mov     ax,4200h                ;
                mov     bx,Schfh                ;
                int     21h                     ;
                ret                             ;

SchMoveTo       endp



; **************************************************************
; *             Sound
; *
; **************************************************************
sound           proc    near

                .push   ax,bx,cx,dx,di
                mov     cx,5
                mov     bx,1
                mov     di,1000                 ;from Zortech C++
sound_loop:     .push   bx,cx                   ;
                ;-------------------------------
                ; tone begin
                mov     al,0b6h                 ;program timer
                out     43h,al                  ;
                mov     dx,14h                  ;frequency = dx:ax / di
                mov     ax,4f38h                ;
                div     di                      ;
                out     42h,al                  ;
                mov     al,ah                   ;
                out     42h,al                  ;
                ;--------------------------------
                in      al,61h                  ;
                mov     ah,al                   ;
                or      al,3                    ;set bit 0, 1
                out     61h,al                  ;Enable Speaker
swait:          mov     cx,2801+1000            ;
spkron:         loop    spkron                  ;
                dec     bx                      ;
                jnz     swait                   ;
                mov     al,ah                   ;
                out     61h,al                  ;Disable Speaker
                .pop    bx,cx                   ;
                add     di,10
                inc     bx
                loop    sound_loop              ;

                .pop    ax,bx,cx,dx,di

                ret


sound           endp
