/* winbuf.c - buffer for contents of part of the screen
 * Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

#include <stdlib.h>
#include <string.h>
#include "winbuf.h"
#include "minitrue.h"
#include "console.h"

enum { MAX_WINDOWS = 8 };
static Window Windows[MAX_WINDOWS];
static int WinBuf_i;
static int Screen_rows, Screen_cols;

Window *WinBuf_Init(int buf_rows)
{
    Window *win_ptr   = &Windows[WinBuf_i];
    Screen_rows       = Console_Rows();
    Screen_cols       = Console_Cols();
    win_ptr->buf_rows = buf_rows;
    win_ptr->len      = buf_rows * Screen_cols;
    win_ptr->buf      = x_farmalloc(win_ptr->len * sizeof(CharAttr));
    ++WinBuf_i;
    return win_ptr;
}

int WinBuf_nrows(Window *win_ptr) { return win_ptr->buf_rows; }

ScreenPtr WinBuf_row(Window *win_ptr, int buf_row)
{
    return ( (buf_row < win_ptr->buf_rows)
            ? &win_ptr->buf[Screen_cols * buf_row]
            : NULL);
}

void WinBuf_copy(Window *dest, Window *src)
{
    int len = miN(src->len, dest->len);
    _fmemcpy(dest->buf, src->buf, sizeof(CharAttr) * len);
}

/* When screen resized, resize all the window buffers, if buffers have
 * more lines than screen, keep the # of offscreen lines constant */
void WinBuf_Resize_all(void)
{
    int win_i, new_rows = Console_Rows(), new_cols = Console_Cols();
    if(new_rows != Screen_rows || new_cols != Screen_cols)
    {   for(win_i = 0; win_i < WinBuf_i; ++win_i)
        {   int extra_rows = Windows[win_i].buf_rows - Screen_rows, new_len;
            if(extra_rows > 0)
                Windows[win_i].buf_rows = new_rows + extra_rows;
            new_len = sizeof(CharAttr) * new_cols * Windows[win_i].buf_rows;
            Windows[win_i].buf = x_farrealloc(Windows[win_i].buf, new_len);
        }
        Screen_rows = new_rows;
        Screen_cols = new_cols;
    }
}

void WinBuf_Kill(void)
{
    int win_i;
    for(win_i = 0; win_i < WinBuf_i; ++win_i)
        farfree(Windows[win_i].buf);
}
