/* Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

#ifndef WILDCARD_H
#define WILDCARD_H
/* Byte code structure for shell pattern */
typedef struct wc
{   int tag;
    void *data;    /* points to either string or set */
    int len;       /* string length if string, 1 if set */
    char *loc;     /* location of string or set */
    int backtrack; /* index of where to backtrack to if match not successful */
    char * (* func)(struct wc *, char *);/* points to func used to match data*/
} WildCard;

WildCard *WildCard_init(char *pattern, int case_sense, int recurse);
int WildCard_match(WildCard *wc_start, char *path_ptr);
int WildCard_Is(const char *str);
void WildCard_kill(WildCard *wc_ptr);
#endif /* WILDCARD_H */
