static char far Tutorial_text[] =
"\n\
     //\\   //\\        ==========                       Version 2.0.2\n\
    //  \\ //  \\ o .==_ o   \\ .==_ \\  \\ .==_              (Alpha #3)\n\
   //    //    \\ \\ \\  \\ \\   \\ \\    \\  \\ \\__)             1999/12/21\n\
  //    //      \\ \\ \\  \\ \\   \\ \\    `=/\\ \\__=\n\
                                               http://www.pagesz.net/~minitrue\n\
      Copyright (C) 1995-99 Andrew B. Pipkin         minitrue@pagesz.net\n\
      Released under the GNU Public License\n\
\n\
\n\
==============================================================================\n\
\n\
\n\
Textviewer Commands\n\
\n\
Movement Commands\n\
\n\
    <SPACE>, <PAGE DOWN>  Move down one page\n\
      Control-v\n\
    b, <PAGE UP>          Move up one page\n\
    <DOWN ARROW>          Move down one line (accelerated)\n\
    v                     Move down one line (non-accelerated)\n\
    <UP ARROW>            Move up one line (accelerated)\n\
    f                     Move up one line (non-accelerated)\n\
    <HOME>, ^             Move to start of file\n\
    <END>, $              Move to end of file\n\
    g                     Move to line number in file\n\
    @                     Move to address in file\n\
    %                     Move to percentage into file\n\
    h                     Move to current found string\n\
    j, Control-n          Move cursor down one line\n\
    k, Control-p          Move cursor up one line\n\
    >, +                  Move to next file\n\
    D                     Move to next file in a directory outside the\n\
                            current one\n\
    Control-d             Move to next file in a directory outside the\n\
                            current one and its subdirectories\n\
\n\
Searching Commands\n\
\n\
    n, <RIGHT ARROW>      Move to next matching string\n\
    N                     Move to next instance of current string\n\
    p, <LEFT ARROW>       Move to previously found string\n\
    P                     Move to previous instance of current string\n\
    c                     Have next search begin at bottom of screen\n\
    C                     Have next search begin at bottom of screen and\n\
                            make all replacements to bottom of screen\n\
    .                     Toggle between moving automatically to next\n\
                            file and requiring pressing > to move to\n\
                            next file\n\
    /                     Enter string to search for. The search for the new\n\
                            string will begin after the most recently found\n\
                            string.\n\
\n\
Replacement Commands\n\
\n\
    n                     Do not replace and move to next string\n\
    y                     Replace and move to next string\n\
    Y                     Replace without moving to next string\n\
    s                     Enter substitute replacement text\n\
    S                     Enter substitute replacement which will\n\
                            become the default replacement for the string\n\
    A                     Automatically replace all subsequent instances\n\
                            of this string in this file\n\
    Control-a             Automatically replace all subsequent instances\n\
                            of this string in all files\n\
\n\
Miscellaneous Commands\n\
\n\
    q                     Quit program (restore original screen if possible)\n\
    Q                     Quit program (do not restore original screen)\n\
    Control-c, <ESC>      Abort program, abandoning whatever changes have\n\
     (<ESC> must be typed   been made in the current file\n\
     twice in UNIX)\n\
    <TAB>                 Toggle between text and hexadecimal viewing modes\n\
    Control-l             Rewrite screen\n\
    #                     Count number of lines in file if unknown\n\
    ;                     Toggle cursor location between file and status line\n\
    H                     Toggle highlighting\n\
    W                     Write region from top of screen to line containing\n\
                            cursor to a file\n\
    Control-w             Save file in its current state to another file\n\
    \?                     Show help file\n\
\n\
\n\
Text Entry Commands\n\
\n\
    <LEFT ARROW>, Control-b     Move cursor to left\n\
    <RIGHT ARROW>, Control-f    Move cursor to right\n\
    <BACKSPACE>, Control-h      Move cursor to left, deleting character\n\
                                  originally before cursor\n\
    <DELETE>, Control-d         Delete character under cursor\n\
    <HOME>, Control-a           Move to start of typed text\n\
    <END>, Control-e            Move to end of typed text\n\
    Control-u                   Erase all text\n\
    Control-k                   Erase text from cursor to end\n\
    <ESC>, Control-g            Cancel command\n\
      (<ESC> must be pressed\n\
      twice in UNIX)\n\
\n\
\n\
Terminating Program Execution\n\
\n\
    To stop MiniTrue from running while it is searching, press Control-C.\n\
    (Use Control-Break for the 32-bit DOS version).\n\
\n\
\n\
Introduction\n\
\n\
    MiniTrue is a versatile utility which combines a fast and powerful\n\
    search/replace functionality with a full-featured textviewer, enabling\n\
    quick and efficient browsing, searching and/or modification of a large\n\
    number of files. MiniTrue can operate interactively and prompt to see if\n\
    a replacement should be made or it can make all desired substitutions\n\
    automatically. MiniTrue can also print out matching lines in the manner\n\
    of the utility grep. If no strings to search for are present, MiniTrue\n\
    functions like the pager program less.\n\
\n\
    Version 2.0 offers many improvements over version 1.5. The source has\n\
    been completely rewritten, making possible ports to Linux and 32-bit DOS\n\
    which do not suffer from the memory limitations of the original version.\n\
    Extended regular expressions are supported and much more functionality\n\
    has been added to the text viewer. Many additional improvements have been\n\
    made. The source code is now available to the public. The new features do\n\
    not compromise the speed and flexibility of the original version.\n\
\n\
    The name of the program is the shorthand form of Ministry of Truth, which\n\
    in George Orwell\'s _1984_ was the name of the bureaucracy responsible for\n\
    perpetually revising historical documents. Many revisions just involved\n\
    the replacement of one word with another, such as the substitution of\n\
    the previous enemy state with the current enemy.\n\
\n\
    MiniTrue is released as free software and without any warranties express\n\
    or implied, including but not limited to, any warranty for\n\
    merchantability or fitness for a particular purpose. See the file COPYING\n\
    included with the MiniTrue distribution for more information about the\n\
    warranty and license.\n\
\n\
\n\
Invoking MiniTrue\n\
\n\
    The general format of a MiniTrue command line is as follows:\n\
\n\
        mtr <OPTIONS> <FILES> - <STRINGS>\n\
\n\
        The first group of arguments determines which program options will be\n\
        enabled. The second lists the files which are to be scanned. The\n\
        final group contains the strings which are to be searched for and\n\
        their replacements. The - is used to separate the filenames and\n\
        strings. If the - is omitted, the first argument after the options is\n\
        treated as a filename with the remainder considered strings.\n\
\n\
        -- can be used as a separator, which will reverse the positions of\n\
        the files and strings, making the command line:\n\
\n\
        mtr <OPTIONS> <STRINGS> -- <FILES>\n\
\n\
        Reversing the position of the strings and files enables interaction\n\
        with programs such as xargs which assume that the filenames will be\n\
        the final part of a command line.\n\
\n\
        Piping standard input into MiniTrue, as in dir | mtr, results in\n\
        standard input being scanned as if it were a file (unless the -@ or\n\
        -i cause standard input to be treated as a list of filenames or\n\
        strings). If standard input is scanned as a file, and neither - nor\n\
        -- is present on the command line, all arguments which are not\n\
        options are considered strings.\n\
\n\
        Strings on the command line have the following format (Square brackets\n\
        indicate something is optional):\n\
\n\
        FIND1 [= REPLACE1 ] [ FIND2 [= REPLACE 2] ] [ FIND3 [= REPLACE3 ]] ... \n\
\n\
        The text matched by the FIND strings will be displayed in the\n\
        textviewer (or written to standard output if the -o option is used).\n\
        If the find string is followed by a = which is preceded and followed\n\
        by at least one space, a prompt will be displayed asking whether the\n\
        matched text should be replaced by the string following the =. If no\n\
        string follows the final =, the string preceding it will be be\n\
        deleted. Deletion can also be obtained by using a replacement string\n\
        of \\z.\n\
\n\
        More than 3 find/replace pairs can be used. Strings which contain\n\
        spaces must be enclosed in quotes. If no strings are present on the\n\
        command line, MiniTrue will display all files in the text viewer.\n\
\n\
Options\n\
\n\
    Default Options\n\
\n\
        Case insensitivity, regular expressions and making numbered backup\n\
        files are the original preset options. These options can be disabled\n\
        by using -c-, -x- and -b- respectively.\n\
\n\
\n\
    Setting Default Options\n\
\n\
        The default settings can be stored in the $MINITRUE environment\n\
        variable. The contents of the $MINITRUE variable is processed as if\n\
        it is the first argument on the command line. The $MINITRUE\n\
        environment variable is set in the following manner in various\n\
        operating systems:\n\
\n\
            set MINITRUE=-nq                DOS\n\
            MINITRUE=-nq; export MINITRUE   UNIX Bourne shell or bash\n\
            setenv UNZIP -nq                UNIX C shell\n\
\n\
        The $MINITRUE environment variable can contain more than one option\n\
        if it is enclosed in quotes, like MINITRUE=\"-@:files.lst -nq\".\n\
\n\
        It is also possible to alter the default options by changing\n\
        DEFAULT_FLAGS in the file minitrue.h and recompiling. To disable a\n\
        default option, follow the character of the option with a -, as in\n\
        -c-.\n\
\n\
\n\
    Setting Default Parameters\n\
\n\
        It is possible to set default parameters for an option without making\n\
        that option enabled by default. To set default parameters, insert a -\n\
        between the option and its parameters. To make printing line numbers\n\
        the default behavior if the -o option is invoked without making -o\n\
        the default, put -o-# in the $MINITRUE environment variable. If a\n\
        command line option has any parameters, then the default parameters\n\
        will not be used. To use an option which has default parameters\n\
        without any parameters, it is necessary to first clear the default\n\
        parameters, as in -o- -o.\n\
\n\
\n\
    Parameter Syntax\n\
\n\
        Parameters which are enclosed in square brackets are optional.\n\
        Parameter names in upper case preceded by a # represent numbers while\n\
        upper-case parameter names without a # indicate text parameters.\n\
\n\
        Options can be combined as long as they do not have a text parameter.\n\
        -a -c -e can be replaced with -ace. If an option does have a text\n\
        parameter, subsequent options must have their own -. If -b:.bakt4\n\
        is used, the tab size will not be set. Either -b:.bak -t4 or -t4b:.bak\n\
        should be used to change the tab size to 4.\n\
\n\
\n\
    Options list\n\
\n\
    -a  search All files\n\
\n\
        The normal behavior of wildcard expansion and subdirectory recursion\n\
        is to skip all files which are considered hidden by the operating\n\
        system. In UNIX, files which begin with a dot are considered hidden,\n\
        while in DOS, hidden files have the hidden attribute set. If the -a\n\
        option is used, then those files will not be skipped when directories\n\
        are scanned. Hidden individual files listed on the command line will\n\
        always be scanned regardless of whether the -a option is used.\n\
\n\
\n\
    -b[+]:EXT  make Backup files\n\
\n\
        If the -b option is used and modifications are made to files, then\n\
        the original version of the file is saved with the extension EXT\n\
        appended to its filename. If a + follows -b, then the original file\n\
        is left unchanged while the altered version is saved with the\n\
        extension.\n\
\n\
        If * is embedded in the extension, then the * will be replaced with a\n\
        number that will guarantee that the backup filename is unique. This\n\
        will insure that MiniTrue will never overwrite any existing files\n\
        (including backups).  Putting multiple *\'s together will cause the\n\
        backup number to have at least as many digits as *\'s are present,\n\
        padding with 0\'s if necessary.\n\
\n\
        If the backup extension is preceded by .. then the backup extension\n\
        will replace the original filename\'s extension instead of being\n\
        appended to it.\n\
\n\
\n\
    -c[+][~]  Case insensitivity\n\
\n\
        If the -c option is used, then searches will be conducted in a\n\
        case-insensitive manner. The two parameters determine how case is\n\
        matched in a replacement. If -c+ is used, then the case of each\n\
        character in the replacement will match the case of the corresponding\n\
        character in the found string. -c~ will match case only in the\n\
        initial characters of the strings.\n\
\n\
\n\
    -d  preserve original file Datestamp\n\
\n\
        Normally, if a file is modified the file\'s date/time is changed to\n\
        the current time. Using the -d option will preserve a modified file\'s\n\
        original date/time stamp.\n\
\n\
\n\
    -e[+]  ignore file Errors\n\
\n\
        The -e option will suppress error messages when a file cannot be\n\
        opened or read. Using -e+ will suppress file write errors as well.\n\
\n\
\n\
    -f[+]  control line Folding\n\
\n\
        Normally lines which are longer than the screen length are wrapped\n\
        around to the next screen line. -f will prevent line-wrapping from\n\
        occurring between two characters which are defined as members of the\n\
        word set (by the -w option), so words will not be divided between\n\
        different screen lines. -f+ will prevent line wrapping completely,\n\
        with lines longer than the screen length being truncated.\n\
\n\
\n\
    -h  Hex mode\n\
\n\
        -h will cause MiniTrue to begin with the hex viewer.\n\
\n\
\n\
    -i[+][:FILENAME]  read strings from Input file\n\
\n\
        The -i option allows strings to be read from a file. The strings in\n\
        the file are treated as if they follow the strings on the command\n\
        line. Strings which contain a space or other whitespace character\n\
        such as a tab or newline must be enclosed in \". A # in the file\n\
        begins a comment, with the remainder of the line following the #\n\
        being ignored. If :FILENAME is not present, strings will be read from\n\
        standard input.\n\
\n\
        The + parameter is intended to be facilitate the ability of UNIX to\n\
        automatically invoke an interpreter for a file if the file begins\n\
        with #!. If the first line of a string input file is\n\
\n\
        #! mtr -<options>i+\n\
\n\
        and the file is made executable with chmod, typing the name of the\n\
        string file (along with the files it is to operate on) will\n\
        automatically invoke MiniTrue. Using -i+ makes the following argument\n\
        the name of the string input file and causes all non-option arguments\n\
        to be treated as filenames.\n\
\n\
\n\
    -k  Keep statistics\n\
\n\
        A report listing the number of matches will be printed when the\n\
        program is finished if -k is used. The number of matches found for\n\
        each file and each string will be listed.\n\
\n\
\n\
    -l[:LOGFILE]  generate Log file\n\
\n\
        Using -l will generate a log file which will record the file and line\n\
        number of all matches and the replacement string if a substitution is\n\
        made. If :LOGFILE is not present, the information will be written to\n\
        the file minitrue.log. If a log file already exists, the new data\n\
        will be appended to it.\n\
\n\
\n\
    -m[+]#MARGIN[:#MINJUMP]\n\
\n\
        The first parameter of -m determines the positions of matches on the\n\
        screen. If + is not present, the screen will be generated so that\n\
        #MARGIN lines are positioned between the top of the screen and the\n\
        match. +#MARGIN will place #MARGIN lines between the bottom of the\n\
        screen and the match. Matches will appear in the center of the screen\n\
        if the -m option is not present.\n\
\n\
        The second parameter controls when the start of the screen jumps to a\n\
        different location when a new match is found. If #MINJUMP is present,\n\
        the screen start will not change if the new match is at most #MINJUMP\n\
        lines away from the line the cursor is on and the new match is\n\
        located within the current screen. Setting #MINJUMP to 0 will result\n\
        in changing the screen start with each match. The default is to not\n\
        jump as long as the new match is found on the current screen.\n\
\n\
\n\
    -n  No prompting\n\
\n\
        Using -n results in all replacements being made automatically and\n\
        suppresses display of the found text.\n\
\n\
\n\
    -o[#][~][^][/][+][$][#CONTEXT[:#TRAIL]]  write matches to standard Output\n\
\n\
        The -o option will cause MiniTrue to behave like the utility grep.\n\
        Matches and their surrounding context will be written to standard\n\
        output instead of being displayed in the textviewer. Replacements\n\
        will be made automatically in the text which is written to standard\n\
        output. The parameters for the -o option are;\n\
\n\
        #   Number lines\n\
\n\
        ~   Print non-matching lines instead of matching lines\n\
\n\
        ^   Normally the filename is printed before the start of the lines if\n\
            more than one file is searched and not written if a single file\n\
            is scanned. Using ^ will invert this behavior, not printing\n\
            filenames when multiple files are used and showing the filename\n\
            for a single file.\n\
\n\
        /   Do not print matches and only print filenames where matches\n\
            occur. If ~ is used, print filenames where matches do not occur.\n\
\n\
        +   Print both matching and non-matching lines, causing MiniTrue\n\
            to behave like the cat utility. If # is used in conjuction with\n\
            +, MiniTrue will operate like a line-numbering utility.\n\
\n\
        $   Do not print any context, just write the matching strings to\n\
            standard output. If ~ is used with $, the entire file is printed\n\
            with the exeception of the matches.\n\
\n\
        #CONTEXT[:TRAIL] Usually the only context printed is the line a\n\
            match occurs on. Using #CONTEXT will result in #CONTEXT lines\n\
            before the match being printed. If :#TRAIL is present, #TRAIL\n\
            lines after the match will be displayed, otherwise #CONTEXT\n\
            lines of trailing context will be printed.\n\
\n\
\n\
    -p:PRINT_SET  define the set of Printing characters\n\
\n\
        The -p option determines which characters are displayed in the\n\
        textviewer. PRINT_SET has the same syntax as a regular expression\n\
        set. Characters which are not found in PRINT_SET are not displayed by\n\
        the textviewer.\n\
\n\
\n\
    -q  Quiet mode\n\
\n\
        -q will prevent anything from being written to the screen until a\n\
        match is found. The filename currently being scanned will not be\n\
        displayed in the status line.\n\
\n\
\n\
    -r[^][+][~][#][#LEVEL[:#MAX]]  Recurse through subdirectories\n\
\n\
        Using -r will result in subdirectories being scanned. The search will\n\
        begin in the leading directory of a filename. If a filename lacks a\n\
        leading directory, the current directory will be recursed through. If\n\
        a directory is used as a filename, all files in the directory will be\n\
        scanned.\n\
\n\
        The parameters for -r are:\n\
\n\
        ^   Do a depth-first instead of a breadth-first search\n\
\n\
        +   Follow symbolic links (UNIX only)\n\
\n\
        ~   Skip files which are not regular files. In UNIX, regular\n\
            files are not devices, pipes or sockets. In DOS, files\n\
            which are do not have the system archive set are considered\n\
            regular files.\n\
\n\
        #   Go through the files in a directory in alphabetical order\n\
\n\
        #LEVEL[:#MAX] These parameters determine the depth of recursion\n\
            through the directory tree. If #LEVEL is present without :MAX,\n\
            #LEVEL is the maximum level of recursion. The presence of :#MAX\n\
            will make #LEVEL the minimum level, with the second parameter\n\
            representing the maximum.\n\
\n\
\n\
    -s[#MAX][:#NCONSEC]  control behavior of accelerated Scrolling\n\
\n\
        Pressing an up or down arrow key normally causes the position of the\n\
        screen to change by one line. If accelerated scrolling is enabled and\n\
        the arrow key is held down, the arrow key will result in movement of\n\
        more than one line, allowing faster movement through the file. #MAX\n\
        determines the maximum position change that an arrow key can produce.\n\
        #NCONSEC sets the number of consecutive arrow presses which will\n\
        increment the number of lines scrolled. Using -s without any\n\
        parameters will disable accelerated scrolling.\n\
\n\
\n\
    -t#TABSIZE  set Tab size in text viewer\n\
\n\
        The -t option determines how many spaces tab characters embedded\n\
        in files are expanded to.\n\
\n\
\n\
    -u[#NLINES][:#NBYTES]  control proximity needed for boolean matches\n\
\n\
        The -u option determines the maximum distance allowed between members\n\
        of a boolean match. #NLINES determines the number of lines in the\n\
        region in which the strings in the boolean match must occur. If\n\
        #NLINES is 1, then the strings in a boolean match must appear on the\n\
        same line. The maximum number of characters between the parts of a\n\
        boolean match is set with the #NBYTES parameter. If both #NLINES and\n\
        #NBYTES are present, the smaller region will be used. If neither\n\
        parameter is used, the members of a boolean match can be anywhere in\n\
        a file.\n\
\n\
\n\
    -v[+][:mono][:COLORS]  set Video mode\n\
\n\
        In DOS, the + parameter will write the screen through the terminal\n\
        instead of writing directly to video memory. ANSI.SYS or another\n\
        terminal driver must be used. In UNIX, + will pad the ends of lines\n\
        with spaces. Some terminals, such as nxterm, always clear the screen\n\
        to black. This requires that the ends of the lines be padded with\n\
        spaces to make the right side of the screen the same color as the\n\
        rest of the screen.\n\
\n\
        The :mono parameter will suppress screen colors. :mono must be present\n\
        if a non-ANSI terminal is used.\n\
\n\
        The COLORS parameter allows user definition for the screen colors.\n\
        COLORS is a string of background/text color pairs. The following\n\
        abbreviations represent valid background colors:\n\
\n\
            bk - black      bl - blue        gn - green     cy - cyan\n\
            re - red        ma - magenta     br - brown     Gr - bright gray\n\
\n\
        The text color can be any background color or any of the following:\n\
\n\
            gr - gray           Bl - bright blue    Gn - bright green\n\
            Cy - bright cyan    Re - bright red     Ma - bright magenta\n\
            ye - yellow         wh - white\n\
\n\
        A color pair is represented by preceding the background color before\n\
        the text color. bkwh will produce white text on a black background.\n\
\n\
        The parts of the screen in COLORS occur in the following order:\n\
\n\
            :Normal text:Current match:Previous matches:Wrapped lines ...\n\
            :Lines with unknown starts:Status line:Substituted text\n\
\n\
        To use white text on a black screen with current and previous matches\n\
        having black text on a bright gray background, use:\n\
\n\
        -v:bkwh:Grbk:Grbk\n\
\n\
        The default color will be used if a color pair is not present.\n\
\n\
\n\
    -w[+][:WORDSET]  Whole words only\n\
\n\
        If -w is used and the leading and trailing characters of a match are\n\
        in the set of word characters, the characters preceding and following\n\
        the string must not be members of the set of word characters. The\n\
        WORDSET parameter allows definition of the set of word characters.\n\
        WORDSET has the same syntax as a regular expression character set.\n\
        The regular expression assertions \\b and \\B along with the -f+ option\n\
        use WORDSET to determine where a word break occurs. If the +\n\
        parameter is used, the set of word characters can be changed without\n\
        requiring matches to be whole words.\n\
\n\
\n\
    -x  use regular eXpressions\n\
\n\
        Using -x will result in the strings being interpreted as regular\n\
        expressions. Regular expression symbols must be preceded by a \\ for\n\
        them to be processed as normal characters.\n\
\n\
\n\
    -y[+]  skip binarY files\n\
\n\
        The -y option will skip files which are presumed to be binary files.\n\
        Files are considered binary if more than 10% of their characters are\n\
        characters not commonly found in text files. This is not foolproof\n\
        and some files which are binary might be considered text and vice\n\
        versa. Using -y+ will skip all files which are not considered binary.\n\
\n\
\n\
    -z:EXT:PROGNAME:OPTIONS[:EXT:PROGNAME:OPTIONS] ...  unZip files\n\
\n\
        The -z option allows compressed files to be decompressed before they\n\
        are scanned. The first parameter, EXT is the extension of the\n\
        filenames which are to be decompressed. PROGNAME is the name of the\n\
        decompression program. The third parameter is the flag required by\n\
        the decompression program to write the expanded data to standard\n\
        output. (This is -c for pkunzip, -p for unzip, -c for gunzip).\n\
        Decompressing the archive to standard output avoids the need to alter\n\
        the compressed file. More than one type of decompressor can be used\n\
        by following the initial parameters by additional parameter sets.\n\
        Writing to a file which has been expanded is not allowed.\n\
\n\
        If PROGNAME is not present, then files with the extension EXT\n\
        are skipped completely. To skip graphics files, use:\n\
        -z:.jpg:::.gif:::.tif\n\
\n\
\n\
    -@[+][:FILENAME]  read filenames from file\n\
\n\
        -@ scans filenames contained in a file in addition to the filenames\n\
        listed on the command line. If :FILENAME is omitted, filenames are\n\
        read from standard input. The + parameter requires that a null\n\
        character (\\0) separate the filenames, otherwise any whitespace is\n\
        sufficient to demarcate the filenames.\n\
\n\
\n\
File Names\n\
\n\
    File names for all versions of MiniTrue use UNIX wildcards. Like DOS\n\
    wildcards, * matches a variable amount of text in a filename and \?\n\
    matches any single character in the filename. UNIX wildcards also allow a\n\
    set of characters to match at a location in the filename. To represent a\n\
    set, enclose the desired characters in []. minitrue.[ch] will match both\n\
    minitrue.c and minitrue.h. A range of characters can be specified by\n\
    placing a - between the endpoints of the range. *[0-9] will match all\n\
    filenames which end with a number. If ! is the first character inside the\n\
    set, all characters not in the set will be matched. \?\?[!o] matches all\n\
    three character filenames which do not end in o.\n\
\n\
    Either \\ or / can be used as a directory separator in the DOS versions.\n\
\n\
    UNIX shells usually expand wildcards before passing the command-line\n\
    arguments to a program. If automatic wildcard expansion is used and *.txt\n\
    is appears on the command line, *.txt will not appear in the argument\n\
    list seen by the program. Instead, *.txt will be replaced by whatever\n\
    files match the wildcard, such as a.txt, b.txt and c.txt. The expansion\n\
    of wildcards should not cause any problems if a separator - is present,\n\
    but if one is missing problems might result because only the first\n\
    expanded filename will be treated as a filename. Expansion of wildcards\n\
    can be prevented by quoting the filename. Wildcards must also be quoted\n\
    for recursion to work properly.\n\
\n\
\n\
Strings\n\
\n\
    Quoting\n\
\n\
        If a string contains a space or a whitespace character such as a tab\n\
        or newline, the string must be enclosed in \" regardless of whether it\n\
        appears on the command line or in an input file specified with the -i\n\
        option. Any additional unquoted spaces beyond the space used to\n\
        separate strings are ignored. \\s, an abbreviation for all whitespace\n\
        characters, does not require quoting. A string must also be enclosed\n\
        in quotes if contains characters which are treated specially by the\n\
        command shell. For COMMAND.COM in DOS, these characters are <, | and\n\
        >. Quoting strings containing these characters is not required in an\n\
        input file.\n\
\n\
        To search for a literal = and @, which are normally considered\n\
        MiniTrue symbols, precede them with a \\, like \\= and \\@. A leading \\\n\
        is not needed if a string of more than one character begins with = or\n\
        @.\n\
\n\
\n\
    Multiple String Considerations\n\
\n\
        If more than one string matches at a particular point in a file, the\n\
        string which occurs first on the command line will be displayed\n\
        first. Matches will not be made in the altered text of other strings;\n\
        to modify substituted text, the program must be run again. \n\
\n\
        \n\
    Escape Sequences\n\
\n\
        The following escape sequences enable the representation of\n\
        non-printing characters in a string:\n\
\n\
            \\a  alert (bell)        \\b backspace\n\
            \\e  escape              \\f formfeed\n\
            \\n  newline             \\r carriage return\n\
            \\t  tab                 \\z zero-length string\n\
            \\\\  backslash           \\[symbol] treat symbol as normal text\n\
\n\
            \\x[hexdigit][hexdigit]  hexadecimal number between 00 and ff\n\
            \\[digits]               numbers up to 3 digits, with no 8s or 9s\n\
                                    are considered an octal number, assuming\n\
                                    the sequence is not interpreted as a\n\
                                    backreference\n\
\n\
        If regular expressions are used, \\b will represent a word break\n\
        instead of a backspace. \\b must be enclosed in a character set, like\n\
        [\\b], to obtain a backspace character.\n\
\n\
        Backslashes and their following characters are always treated as\n\
        escape sequences regardless of whether regular expressions are used.\n\
\n\
\n\
    Regular Expressions\n\
\n\
        Regular expressions enable the search for strings which match a\n\
        general pattern. The parts of a match have a variable identity and\n\
        the number of times those parts of can occur can be altered as well.\n\
        All regular expression symbols are treated as normal text if they are\n\
        preceded by a \\\n\
\n\
\n\
        Character Sets\n\
\n\
            Character sets allow a more than one character to match at a\n\
            location in a string. The members of the set are enclosed in\n\
            square brakets, like [abcde]. Placing a dash between two\n\
            characters in a set will match all characters from the character\n\
            before the - to the character following the dash. [a-e] and\n\
            [abcde] are equivalent sets. If ^ is the first character in a set,\n\
            all characters will be matched with the exception of the\n\
            characters which follow the ^. [^0-9] will match all characters\n\
            which are not digits. When ^ occurs at a position besides the\n\
            start of a character set, the characters following the ^ are\n\
            removed from the set. [a-z^aeiou] will match the consonants.\n\
\n\
\n\
            Character set abbreviations\n\
\n\
                These escape sequences represent commonly used character\n\
                sets. The escape sequences can be either inside or outside\n\
                another character set.\n\
\n\
                    \\d digits                   \\D non-digit characters\n\
                    \\l lower case letters       \\L non-lower case letters\n\
                    \\u upper case letters       \\U non-upper case letters\n\
                    \\c alphabetic characters    \\C non-alphabetic characters\n\
                    \\w word characters          \\W non-word characters\n\
\n\
                    (The default word set contains all alphanumeric\n\
                    characters and _ It can be modified with -w)\n\
\n\
                    \\s whitespace characters    \\S non-whitespace characters\n\
\n\
                    (The set of whitespace characters consists of the space,\n\
                    tab, new line, carriage return, form feed and vertical\n\
                    tab characters.)\n\
\n\
                    \\p punctuation characters   \\P non-punctuation characters\n\
\n\
                    (Punctuation characters are defined as all ASCII\n\
                    characters which are neither alphanumeric or a space\n\
                    character.)\n\
\n\
                . represents all characters with the exception of \\n.\n\
                [^], a negated set with no negated characters, acts as\n\
                shorthand for a set with all characters including \\n.\n\
\n\
\n\
        Alternations\n\
\n\
            Alternations are similar to character sets because they allow\n\
            more than one item to match at a point in a string. Unlike\n\
            character sets, the variable text for an alternation can be\n\
            longer than one character. A | is used to demarcate the\n\
            alternatives. abc|def|ghi will match abc, def or ghi. The\n\
            alternation must be enclosed in parentheses for some parts of the\n\
            regular expression to appear outside the alternation.\n\
\n\
\n\
        Quantifiers\n\
\n\
            The following quantifiers enable part of a regular expression to\n\
            occur a variable number of times.\n\
\n\
                +           match 1 or more times\n\
                *           match 0 or more times\n\
                \?           match 0 or 1 times\n\
                {n}         match n times\n\
                {min,}      match at least min times\n\
                {min, max}  match between min and max times\n\
\n\
            Quantifiers operate only on the character or set immediately\n\
            preceding them unless parentheses are used. abc+ will match abc,\n\
            abcc, abccc, ... To match abcabcabc, the regular expression\n\
            (abc)+ must be used.\n\
\n\
            Numeric quantifiers can be any positive number smaller\n\
            than the maximum signed integer of the machine (32767 for 16-bit\n\
            DOS, 2147483647 otherwise).\n\
\n\
\n\
        Zero-width Assertions\n\
\n\
            The following characters and escape sequences do not match any\n\
            particular characters. Instead, they test if a certain condition\n\
            is true at the point they occur.\n\
\n\
            ^   line start\n\
            $   line end\n\
            \\b  word break\n\
            \\B  non-word break\n\
            \\A  start of file\n\
            \\Z  end of file\n\
\n\
            $, the line end assertion, assumes that a single newline is used\n\
            to represent a line end. In DOS text files, which use a carriage\n\
            return-new line pair to mark the end of a line, $ will match\n\
            between the carriage return and the new line. For $ to work as\n\
            intended in a DOS file, the carriage returns must be stripped\n\
            before the regular expression match is attempted. The line ends\n\
            can be reconverted back to normal DOS format when done.\n\
\n\
\n\
        Backreferences\n\
\n\
            The text where a backreference occurs must match the contents of\n\
            a parentheses which occurs previously in a regular expression.\n\
            \\(digit) represents the parentheses contents for parentheses 1\n\
            through 9. Parentheses between 10 through 99 are represented by\n\
            \\v(digit)(digit). ([a-z])([a-z])\\2\\1 will match a four letter\n\
            palindrome. The parentheses corresponding to a backreference must\n\
            be closed before the backreference occurs.\n\
\n\
            The text captured by a pair of parentheses is displayed in a\n\
            different color from the rest of the match if a color terminal is\n\
            used, making obvious the text that would match a backreference.\n\
            The contents of parentheses #1 is red, #2 is yellow, #3 is green\n\
            and then the color sequence repeats for subsequent parentheses.\n\
            The text color is determined by the innermost parentheses.\n\
\n\
\n\
        Regular expression replacements\n\
\n\
            The following escape sequences can be embedded in regular\n\
            expression replacements and allow the replacement text to vary in\n\
            accordance with the text that was matched.\n\
\n\
            \\(digit)            replace this escape sequence with the text\n\
                                enclosed by parentheses number (digit). The\n\
                                regular expression must have at least (digit)\n\
                                pairs of parentheses.\n\
\n\
            \\v(digit)(digit)    This functions like \\(digit), but the\n\
                                parentheses number ranges from 10-99 instead\n\
                                of 1-9.\n\
\n\
            \\l                  Make the following character lowercase\n\
\n\
            \\u                  Make the following character uppercase\n\
\n\
            \\L                  Make the following characters lowercase\n\
                                until a \\E or \\U appears\n\
\n\
            \\U                  Make the following characters uppercase\n\
                                until a \\E or \\L appears\n\
\n\
            \\E                  End the case modification caused by \\L or \\U\n\
\n\
\n\
\n\
    Boolean Expressions\n\
\n\
        The occurence of a string which appears in a boolean expression will\n\
        not be recorded unless other strings are found within a specified\n\
        distance from the match. To specify a set of strings which must must\n\
        appear together, place a @ between the strings on the command line.\n\
        If the region for a boolean match is not changed, a @ b @ c will\n\
        locate a, b and c only when they are present on the same line.\n\
        Boolean expressions can be nested by enclosing parts of them in\n\
        square brackets. If the strings enclosed in square brackets do not\n\
        have a @ between them, there is an implicit or. [ a b ] @ [ c d ]\n\
        requires a or b to occur close to where c or d occurs. A space must\n\
        precede and follow both the @ and the square brackets on the command\n\
        line.\n\
\n\
        The default region for a boolean match is a single line. The maximum\n\
        distance allowed between strings in a boolean match is set by the\n\
        -u option.\n\
\n\
        If there are multiple permutations for a boolean match in the desired\n\
        region, some permutations might not be recorded. a @ b will only\n\
        match the second a in aab.\n\
\n\
\n\
Return Values\n\
\n\
    0 is returned if a match if found, 1 if no matches are found. If an error\n\
    occurs, 2 is returned.\n\
\n\
\n\
Examples\n\
\n\
    Some strings might require quoting depending on the shell used. (Replace\n\
    mtr with mt for the DOS 16-bit version)\n\
\n\
\n\
    Example 1 - The original MiniTrue\n\
\n\
        mtr -rnw * - Eastasia = Eurasia\n\
\n\
        This will replace all instances of \"Eastasia\" with \"Eurasia\" in all\n\
        files on the current drive. The -r option is necessary for scanning\n\
        to recurse through the subdirectories. The -n option will make\n\
        replacements automatically, and the -w option will only find whole\n\
        words\n\
\n\
\n\
    Example 2 - Determining the frequency of each letter\n\
\n\
        mtr -kn /docs/* - a b c d e f g h i j k l m n o p q r s t u v w x y z\n\
\n\
        This will determine the number of times each letter appears in the\n\
        files (with case insensitivity) in the subdirectory /docs. The -n\n\
        option will avoid displaying a prompt screen after each find, while\n\
        the -k option will print statistics telling how many times each\n\
        letter was found when the program is finished.\n\
\n\
\n\
    Example 3 - Inserting blank lines between paragraphs\n\
\n\
        mtr -x *.txt - \"(^[ \\t]+)\" = \\n\\1\n\
\n\
        Assume that all paragraphs will start with an indentation consisting\n\
        of spaces or tabs. These indentation characters will be matched with\n\
        [ \\t]+. The ^ is used to indicate the start of a line. Quotes are\n\
        required because the regular expression contains a space. In the\n\
        replacement string, \\1 represents the indentation, with \\n being the\n\
        inserted newline.\n\
\n\
\n\
    Example 4 - Stripping tags from HTML files\n\
\n\
        mtr -xb+:.txt *.htm - \"<[^>]*>\" = \\z\n\
\n\
        This will strip most (but not all) tags enclosed in angle brackets\n\
        from HTML files. -x will enable regular expressions and b+:.txt will\n\
        save the stripped files with the extension .txt and leave the\n\
        original html files unaltered. < indicates start of the tag, [^>]*\n\
        will match until the closing bracket and > finishes the tag. Quotes\n\
        around the string are necessary to prevent the brackets from being\n\
        interpreted as I/O redirection symbols.\n\
\n\
\n\
    Example 5 - Stripping all the C++ comments from a program file\n\
\n\
        mtr -x prog.cpp ^\\s*//.*\\n = \\z  //.*$ = \\z\n\
\n\
        This will remove all // comments from a C++ source file. The first\n\
        find/replace pair will eliminate all comments which have nothing else\n\
        on their line. ^\\s* will skip over leading space. After the comment,\n\
        all characters before the newline symbol will be matched with .*\n\
        Finally the \\n itself will be included. The replacement string of \\z\n\
        (representing a null string) will result in the comment being\n\
        completely deleted.\n\
\n\
        The second find replace pair will handle comments with something else\n\
        on their line. Once the // has been found, all characters before the\n\
        end of the line will be matched with .*$ Because there is something\n\
        else on the line, it is not necessary to delete the \\r\\n at the end\n\
        of the comment.\n\
\n\
\n\
    Example 6 - Printing the start of a file\n\
\n\
        mtr -ox file.txt \\A(.*\\n){10}\n\
\n\
        This will function like the head utility and print out the first\n\
        10 lines of a file. -o will print out the matched text. \\A matches\n\
        the start of the file and (.*\\n) will match a line including\n\
        its ending newline. The number in brackets tells how many times\n\
        the line should occur.\n\
\n\
        The tail utility, which prints lines at the end of a file, can be\n\
        implemented with the string \"(^.*\\n){10}\\Z\".\n\
\n\
\n\
    Example 7 - Determining the density of C++ files\n\
\n\
        mtr -knx *.cpp *.h - \\n ^\\s*$ // ^\\s*// ^\\s*[{}]\\s*$\n\
\n\
        These strings provide information about how densely packed a C++\n\
        program file is. /k will keep track of the number of finds and /n\n\
        will prevent the individual strings from being displayed. \\n counts\n\
        the number of lines in the file and ^\\s*$ locates the blank lines. //\n\
        counts the comments in the file while ^\\s*// finds the comments\n\
        occupying a line by themselves. The last string, ^\\s*[{}]\\s*$, finds\n\
        lines with nothing on them except for a curly bracket.\n\
\n\
\n\
    Example 8 - Finding words in which all the vowels appear consecutively\n\
\n\
        mtr -x * - a[\\l^aeiou]*e[\\l^aeiou]*i[\\l^aeiou]*o[\\l^aeiou]*u\n\
\n\
        The set of lower case consonants is represented by [\\l^aeiou]. These\n\
        consonants can appear any number of times between the vowels. This\n\
        should match abstemious and facetious.\n\
\n\
\n\
    Example 9 - Converting a text file into a C string constant\n\
\n\
        mtr -x cstring.txt ([\\\\\\\?\\\"\\\']) = \\\\\\1   (\\r\?\\n) = \\\\n\\\\\\1\n\
\n\
        These find/replace strings will convert a text file into the form\n\
        used by C string constants. The first find/replace pair will preface\n\
        \", \', \? and \\ with a necessary backslash. The second pair will insert\n\
        a \\n, to indicate a new line, and a \\, to indicate line continuation,\n\
        before the ends of all lines.\n\
\n\
\n\
    Example 10 - Finding a six-letter palindrome\n\
\n\
        mtr -x * - \\b(\\l)(\\l)(\\l)\\3\\2\\1\\b\n\
\n\
        A palidrome reads the same forwards and backwards. The first three\n\
        letters of the regular expression are enclosed in parentheses to\n\
        enable backreference matching. The final three characters are\n\
        represented by backreferences, which match the corresponding\n\
        characters in the first half of the string. The \\bs at the start and\n\
        end of the regular expression insure that the regular expression will\n\
        only match a whole word.\n\
\n\
\n\
    Example 11 - Extracting email addresses from a non-ASCII file\n\
\n\
        mtr -xo$ addrbook.dat ([\\w\\.]{2,}@[\\w\\.]{4,}) = \\1\\r\\n\n\
\n\
        An email address consists of a @ surrounded by alphanumeric\n\
        characters and dots. The non-@ characters will be represented by\n\
        [\\w\\.] Assume a minimum of 2 characters to the left of the @ and 4\n\
        characters to the right, so the entire address will be represented by\n\
        [\\w\\.]{2,}@[\\w\\.]{4,} The x+ option will match the longest string\n\
        possible. Since a binary file is being searched, and the rest of the\n\
        line is not of interest, the o$ option will write only the addresses\n\
        to standard output. It is necessary to append a CR/LF to the\n\
        addresses to avoid having them printed on the same line. To do this,\n\
        make \\1\\r\\n the replacement string. \\1 will represent the address and\n\
        \\r\\n the CR/LF.\n\
\n\
\n\
    Example 12 - Finding consecutive duplicate (non-empty) lines\n\
\n\
        mtr -x file.txt (^.+\\r\\n)\\1+\n\
\n\
        The ^ matches the start of a line, .+ matches the body of lines which\n\
        contain at least one character and \\r\\n matches the trailing \n\
        carriage return/newline. (Remove the \\r for UNIX text files). \n\
        This is enclosed in parentheses so the backreference \\1+ will match\n\
        the parentheses contents at least once and possibly more.\n\
\n\
\n\
    Example 13 - Removing trailing whitespace from the end of lines\n\
    \n\
        mtr -x file.txt \"[ \\t]+(\\r\?\\n)\" = \\1\n\
\n\
        [ \\t]+ matches a sequence of spaces and/or tabs. \\r\?\\n matches\n\
        both DOS and UNIX line end characters. The replacement string \\1,\n\
        will replace the entire matched string with the line end characters, \n\
        which are enclosed in parentheses. \n\
        \n\
        \n\
    Example 14 - Normalizing line ends in a DOS text file\n\
    \n\
        mtr file.txt \\r\\n = \\r\\n \\n = \\r\\n \\r = \\z\n\
        \n\
        This example is used to convert a file which contains both DOS and UNIX\n\
        line end characters (\\r\\n and \\n, respectively) to all DOS line ends.\n\
\n\
        The first find/replace pair has no apparent effect, but it will\n\
        prevent the \\n = \\r\\n from adding an unwanted \\r to line ends which\n\
        already contain both a carriage return and new line. The second pair\n\
        will add a \\r if there is not already one before an \\n. The final\n\
        replacement removes stray \\r. \n\
        \n\
        \n\
";
