/* Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

#ifndef STRINGS_H
#define STRINGS_H 1
#include <stdio.h>
#include "fixedstr.h"
#include "regexp.h"
#include "rxsubst.h"

typedef struct
{   FixedStr fixed_str;
    RegExp *reg_exp;
    const char *loc;     /* Location of match in buffer */
    size_t len;    /* Length of match */
    char *replace; /* Replacement string - NULL if no replacement */
    size_t rep_len;  /* Length of replacement strings */
    RxSubst *rx_subst; /* Regular expression replacement template */
    int  flags;    /* Tells if replacements should be made automatically*/
    long finds;    /* # of times string has been found */
    long reps;     /* # of times string has been replaced */
    int  orig_i;   /* index for original text of string, used in writing
                    *  reports */
    int bool_start_i; /* If string is in boolean expression, index of first
                       * string in expression, -1 otherwise */
    int bool_match_i; /* If string is in boolean expression, index of next
                       * string to try if string present, -1 if no more to
                       * try or not in boolean expression */
    int bool_fail_i; /* If string is in boolean expression, index of next
                      * string to try if string not present, -1 if no more to
                      * try or not in boolean expression */
    int bool_in_match;/* Set if current string is part of boolean match */
    long prev_off;   /* Offset of previous match, needed for boolean
                      * expressions */
    long prev_line_num;/* Line number of previous match, needed for boolean
                       * expressions */
    size_t prev_len; /* Length of previous expression */
} String;

off_t String_off(String *str);
size_t String_len(String *str);
off_t String_prev_off(String *str);
size_t String_prev_len(String *str);
char *String_replace(String *str);
size_t String_rep_len(String *str);
int String_auto_rep(String *string);
off_t String_paren(String *string, int paren_num, int *len);
void String_new_replace(String *string, const char *new_rep, size_t len);
String *String_bool_start(String *str);
String *String_bool_first(String *str);
String *String_bool_next(String *str);

size_t Strings_Init(char * *str_vect, char * *orig_vect, FILE *input_file,
                    const char *case_param, const char *stats_param,
                    const char *log_file, const char *boolean_region,
                    const char *whole_words, const char *reg_exp);
String *Strings_Reset(const char *fname, int zero_len);
String *Strings_Next(int advance);
String *Strings_Add(char *str);
int Strings_Total(void);
int Strings_Found(void);
void String_set_auto_rep(String *string, int auto_rep);
void Strings_No_report(void);
void Strings_Kill(void);

enum { AUTO_REP_FILE = 1, AUTO_REP_ALL = 2, SUBST_REP = 4};

#endif /* STRINGS_H */
