/* Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

#ifndef STATLINE_H
#define STATLINE_H 1
#include "minitrue.h"
#include "console.h"
void StatLine_Init(void);
int StatLine_Used(void);
void StatLine_Make(const char *fname, off_t line_num, off_t nlines,
                   int pcnt, const char *far replace, int rep_len);
int StatLine_Getstr(char *str_buf, int max_len,
                    const char far *prompt_str, const char far *default_str);
int StatLine_Getch(const char far *prompt_str, const char *valid_chars);
long StatLine_Getnum(const char far *prompt_str, int base);
void StatLine_Message(const char far *msg_text, attr_t attr);
void StatLine_Show_fname(const char *fname);
int StatLine_File_error(const char far *err_msg, const char *fname,
                        const char far *options, const char *valid_chars);
int StatLine_Save(void);
void StatLine_Restore(int orig_len);
void StatLine_Error(const char far *err_msg);
int StatLine_Have_msg(void);
int StatLine_Height(void);
void StatLine_Set_cursor(int stat_line_curs);
int StatLine_Cursor(void);
void StatLine_Write(void);
#endif
