/* scroll.c - determine number of lines up/down arrow should scroll
 * Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

#include <stdlib.h>
#include "minitrue.h"
#include "console.h"

static int Scroll_inc     = 1;
static int Max_scroll     = 1;
static int Consec_arrows  = 10;
static int Arrow_keys;

static long key_time_diff(void);

void Scroll_Init(const char *scroll_params)
{
    if(scroll_params)
    {   if((scroll_params = read_int(scroll_params, &Max_scroll)) != NULL)
        {   if(scroll_params && *scroll_params == ':')
                scroll_params = read_int(++scroll_params, &Consec_arrows);
        }
        if(!scroll_params || *scroll_params != '\0')
            invalid_param('s', scroll_params ? *scroll_params : '\0');
    }
}

static int Prev_key = -1;
int Scroll_Accel(int key)
{
    if(key_time_diff() > 25 || key != Prev_key)
    {   Arrow_keys = 0;
        Scroll_inc = 1;
    }
    else if(++Arrow_keys == Consec_arrows && Scroll_inc < Max_scroll)
    {   ++Scroll_inc;
        Arrow_keys = 0;
    }
    Prev_key  = key;
    if(key == DOWN_KEY)
        return Scroll_inc;
    else if(key == UP_KEY)
        return -Scroll_inc;
    else
        return 0;
}
/* return # of hundredth of seconds since last key press */
#ifdef __MSDOS__
long key_time_diff(void)
{
    static clock_t Prev_time;
    clock_t curr_time = clock();
    long diff = hsec_diff(Prev_time, curr_time);
    Prev_time = curr_time;
    return diff;
}
#elif defined(__GNUC__)
#include <sys/time.h>
static long key_time_diff(void)
{
    static struct timeval Prev_time = {0, 0};
    struct timeval curr_time;
    long diff;
    gettimeofday(&curr_time, NULL);

    if(curr_time.tv_sec - Prev_time.tv_sec > 100)
        diff = 10000;
    else
    {   diff  = (curr_time.tv_sec - Prev_time.tv_sec) * 100;
        diff += curr_time.tv_usec / 10000;
        diff -= Prev_time.tv_usec / 10000;
    }
    Prev_time = curr_time;
    return diff;
}
#else
long key_time_diff(void) { return 1000000; }
#endif
