/* Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

#ifndef RXSUBST_H

#include "regexp.h"
/* This structure represents an atom in a regular expression substitution
 * If length is positive, the atom represents a fixed string. If length
 * is negative, the absolute value of the length is the number of the
 * paren to insert into the replacement string. */
typedef struct
{   const char *sub_str;
    int len;
} RxSubst;

RxSubst *RxSubst_init(char *src, int nparens, size_t *str_len);
char *RxSubst_str(RxSubst *rx_subst, RegExp *reg_exp, size_t *len);
void RxSubst_kill(void);

#endif /* RXSUBST_H */
