/* Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

#ifndef RXCHARS_H
#define RXCHARS_H 1

#include "regexp.h"

/* This structure contains information about the quantified parentheses
 *   which enclose the current atom */
typedef struct QuantPar
{   int count;              /* # of times quantified paren has occured */
    RxAtom *end;            /* end of quantified paren */
    RxAtom *back_ref;       /* if is a backreference */
    struct QuantPar *outer; /* Pointer to outer quantified parentheses,
                             * if present */
} QuantParen;

/* This data structure represents a state which the regular expression can
 * be in at the current position */
typedef struct
{   RxAtom *atom;            /* current atom */
    int count;               /* # of times atom has occured */
    int str_i;               /* if atom is string, current position in string*/
    QuantParen *quant_paren; /* Pointer to information on current-innermost
                              * quantified parentheses, if present */
} RxState;

/* This structure contains the state array and some other information */
typedef struct
{   RxState *states; /* array of states */
    RxAtom *end;     /* quit when this atom reached */
    int nused;       /* # of states used */
    int nalloc;      /* # of states allocated */
    int dir;         /* go forward if 1, backwards if -1 */
    RegExp *rx;      /* points to main regular expression structure */
} RxChars;

int RxChars_init(RxChars *rxc, RxAtom *start_ptr,
                  int len, int dir, RegExp *rx);
int RxChars_next(RxChars *rxc, char ch_array[]);
void RxChars_kill(RxChars *rxc);

#endif /* RXCHARS_H */

