/* Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

#ifndef RESIZER_H
#define RESIZER_H
/* This structure describes a buffer which will resize itself if
 * adding an item would cause a buffer overrun */
typedef struct
{   void far *start;   /* start of buffer */
    size_t free_i;    /* index of first unused byte */
    size_t nalloc;    /* number of bytes allocated */
    size_t item_len;  /* length of unit stored in buffer */
    size_t chunk_len; /* number of units to allocate at a time */
} Resizer;
void Resizer_init(Resizer *resizer, size_t item_len, size_t chunk_len);
void far *Resizer_ptr(Resizer *resizer, size_t index);
size_t Resizer_write(Resizer *resizer, void far *src, size_t nunits,
                  size_t write_i);
size_t Resizer_append(Resizer *resizer, void far *src, size_t nunits);
size_t Resizer_size(Resizer *resizer);
void Resizer_truncate(Resizer *resizer, size_t truncate_i);
void far *Resizer_trim(Resizer *resizer);
void Resizer_kill(Resizer *resizer);

enum { RESIZE_NEAR, RESIZE_FAR };
#endif /* RESIZER_H */

