/* Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 */

#ifndef MINITRUE_H
#define MINITRUE_H
#define TRUE 1
#define FALSE 0
#include <stdio.h>
#include <time.h>
#include <limits.h>
#include <stddef.h>

/* ==== 16-bit DOS version */
#ifdef __BORLANDC__  /* refers to small DOS memory model */
#define __DOS16__
#include <alloc.h>
/* Fix broken ctype macros which assume parameter will be between 0-255 */
#undef isalnum
#define isalnum(c)  (_ctype[(unsigned char)(c) + 1] & \\
                    (_IS_DIG | _IS_UPP | _IS_LOW))
#undef isalpha
#define isalpha(c)  (_ctype[(unsigned char)(c) + 1] & (_IS_UPP | _IS_LOW))
#undef iscntrl
#define iscntrl(c)  (_ctype[(unsigned char)(c) + 1] & _IS_CTL)
#undef isdigit
#define isdigit(c)  (_ctype[(unsigned char)(c) + 1] & _IS_DIG)
#undef islower
#define islower(c)  (_ctype[(unsigned char)(c) + 1] & _IS_LOW)
#undef ispunct
#define ispunct(c)  (_ctype[(unsigned char)(c) + 1] & _IS_PUN)
#undef isspace
#define isspace(c)  (_ctype[(unsigned char)(c) + 1] & _IS_SP)
#undef isupper
#define isupper(c)  (_ctype[(unsigned char)(c) + 1] & _IS_UPP)
#undef isxdigit
#define isxdigit(c) (_ctype[(unsigned char)(c) + 1] & (_IS_DIG | _IS_HEX))

#define FP_FORM "Fs"
#define EXE_NAME "mt"
typedef long off_t;

/* if not compiling for 16-bit DOS, alias all far memory functions to regular
 * functions */
#else
#ifndef __DJGPP__
#define __UNIX__
#endif /* __DJGPP__ */
# define farmalloc  malloc
#define farrealloc realloc
#define farfree    free
#define far
#define near
#define _fstrcpy   strcpy
#define _fmemcpy   memcpy
#define _fmemset   memset
#define _fmemchr   memchr
#define _fmemcmp   memcmp
#define _fmemmove  memmove
#define _fstrlen   strlen
#define _fstrcmp   strcmp
#define _fstricmp  stricmp
#define FP_FORM "s"
#define EXE_NAME "mtr"
#include <sys/types.h>
#endif /* ! __DOS16__ */

typedef unsigned int            uns;
typedef unsigned char           uchar;
typedef const char              cchar;
typedef char far                charf;
typedef char near               charn;
typedef const unsigned char     cuchar;
typedef unsigned char far       ucharf;
typedef const unsigned char far cucharf;
typedef const char far          ccharf;
typedef unsigned char near      ucharn;

#define OFF_MAX LONG_MAX
enum { NL = '\n' };
#define ctrl_chaR(ch) (ch) - 'a' + 1

#ifdef __MSDOS__
#define endln_cH(ch)    ((ch) == '\n' || (ch) == '\r')
#define path_sep_cH(ch) ((ch) == '\\' || (ch) == '/' || (ch) == ':')
#define FN_CASE_INS  1
#define DEFAULT_FLAGS "-c -x -z-:.zip:pkunzip:-c -p:[\\x20-\\x7e\\xa0-\\xff] -b:* -s6:10"
#else
#define endln_cH(ch)    ((ch) == '\n')
#define path_sep_cH(ch) ((ch) == '/')
#define FN_CASE_INS 0
#define DEFAULT_FLAGS "-c -x -z-:.gz:/usr/bin/gunzip:-cd:.zip:/usr/bin/unzip:-p:.Z:/usr/bin/compress:-cd -p:[\\x20-\\x7e\\xa0-\\xff] -b:.~*~ -s6:10"
#endif /* __MSDOS__ */

void error_msg(const char far *err_msg);
void fatal_error(const char far *err_msg);
int end_init(int);
void invalid_param(int option_ch, int param_ch);
void set_input_str(const char far *error_str);
void input_error(const char far *err_msg);
int have_input_error(void);

void MiniTrue_Rewrite(void);
void MiniTrue_Kill(void);

/* Prototypes for miscellaneous functions found in misc.h */
void set_case_insense(void);
char *esc_to_ch(char *dest, const char *src);
char *ch_to_esc(char *dest, int ch);
int same_char(const char ch1, const char ch2);
size_t str_preproc(char *src, int conv_case);
int strn_cmp_ci(const char *str1, const char *str2, int n);
char *skip_ws(const char *ptr);
char *skip_num(const char *ptr);
int have_ctype(const char far *str, int (*char_fn)(int ch));
char *read_int(const char *ptr, int *int_ptr);
char *falloc(FILE *file, size_t *len);
char *copy_str(char *dest, const char *src);
char *append_strs(const char far *str1, const char far *str2);
char *append_3strs(const char far *str1, const char far *str2,
                   const char far *str3);
char *str_mult(const char *str, size_t len, size_t n);
void *memrchr(const void *start, int c, size_t n);
size_t count_nl(const char far *start, size_t len);
char * *copy_str_vect(char *str_vect[], int nstrs);
void kill_str_vect(char *str_vect[], int nstrs);
int add_truncate(int a1, int a2);
int mult_truncate(int m1, int m2);
int char_freq(int ch);
long hsec_diff(clock_t start, clock_t end);
char *parse_path(char *pathname, char * *ext_pptr, int *fname_len);

void *x_malloc(size_t len);
void *x_realloc(void *p, size_t new_len);
void *x_calloc(size_t nobj, size_t len);
void far *x_farmalloc(size_t size);
void far *x_farrealloc(void far *p, size_t size);
char *x_strdup(const char *str);
char far *x_fstrdup(const char far *str);

long maj_faults(void);

extern uchar Lower_table[];
extern uchar Upper_table[];

#define low_casE(ch) (uchar)(Lower_table[(uchar)(ch)])
#define up_casE(ch)  (uchar)(Upper_table[(uchar)(ch)])

#define maX(a,b)    (((a) > (b)) ? (a) : (b))
#define miN(a,b)    (((a) < (b)) ? (a) : (b))

enum { FREQ_TOTAL = 1557, MAX_SKIP = UINT_MAX / FREQ_TOTAL};

enum { NCHAR = UCHAR_MAX + 1 }; /* Number of characters in character set */

#endif /* MINITRUE_H */
