/* minitrue.c - main program
 * Copyright (C) 1995-99 Andrew Pipkin (minitrue@pagesz.net)
 * MiniTrue is free software released with no warranty. See COPYING for details
 *
 * I am so smart!
 * I am so smart!!
 * S-M-R-T
 * I mean ... S-M-A-R-T
 *
 *             --Homer Simpson's diploma burning song */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "minitrue.h"
#include "flags.h"
#include "files.h"
#include "fileops.h"
#include "buffers.h"
#include "strings.h"
#include "stdout.h"
#include "viewer.h"
#include "lines.h"
#include "statline.h"
#include "hilites.h"
#include "attribs.h"
#include "console.h"
#include "scroll.h"
#include "signals.h"

static int Restore_screen = TRUE; /* if true, restore screen before program
                                   * invocation if possible */

static void print_copyright(void);

int main(int argc, char *argv[])
{
    Files *files;
    char * *argv_copy = copy_str_vect(argv, argc);
    int flag_args = Flags_Init(&argv_copy[1]);
    int quit      = FALSE, strlen_max, use_console = FALSE, use_stdout = FALSE;
    int quiet_mode = FALSE;
    char * *string_vect = Files_Init(&argv_copy[flag_args +1],
                                     argc - flag_args - 1, Flags_All_files(),
                                     Flags_Param('a'), Flags_Param('b'),
                                     Flags_Param('d'), Flags_Param('i'),
                                     Flags_Param('r'), Flags_Param('z'),
                                     Flags_Param('@'));

    char *stdout_param = Flags_Param('o');

 /* If -? has option parameter, print help corresponding to parameter */
    if(Flags_Param('?'))
    {   if(*Flags_Param('?') != '\0')
        {   Viewer_Option_info(Flags_Param('?'));
            return 1;
        }
    }
 /* If no arguments, print copyright info and quit */
    else if(!string_vect)
    {   print_copyright();
        return 1;
    }

    strlen_max = Strings_Init(string_vect, argv + (string_vect - argv_copy),
                              Files_String_file(), Flags_Param('c'),
                              Flags_Param('k'), Flags_Param('l'),
                              Flags_Param('u'), Flags_Param('w'),
                              Flags_Param('x'));
    Buffers_Init(strlen_max, Flags_Param('y'));
    FileOps_Init(Flags_Param('e'));

    if(stdout_param)
    {   Stdout_Init(stdout_param, !Files_Single(), !Strings_Total());
        use_stdout = TRUE;
    }
 /* Do not need to initialize screen if writing to stdout */
    else if(!Flags_Param('n'))
    {   use_console = TRUE;
        Console_Init(Flags_Param('v'));
        Scroll_Init(Flags_Param('s'));
        Lines_Init(Flags_Param('f'), Flags_Param('h'), Flags_Param('m'),
                   Flags_Param('p'), Flags_Param('t'));
        StatLine_Init();
        quiet_mode = Flags_Param('q') != NULL;
    }
    Signals_Init(use_console);
    atexit(MiniTrue_Kill);
    if(end_init(use_console))
        exit(2);

    if(use_console && Flags_Param('?'))
        Viewer_Tutorial();

    while(!quit && (files = Files_Next()) != NULL)
    {   const char *fname = Files_name(files);
        if(Buffers_Reset(files))
        {   if(use_console)
            {   if(!quiet_mode)
                    StatLine_Show_fname(fname);
                quit = Viewer(fname);
                if(quit >= QUIT_DIR)
                {   Files_finish_dir(quit == QUIT_SUBDIRS);
                    quit = FALSE;
                }
            }

            else if(use_stdout)
            {   String *str = Strings_Reset(fname, FALSE);
                Stdout_Reset(fname);
                while((str) && Stdout_Print(String_off(str), String_len(str),
                                            String_replace(str),
                                            String_rep_len(str)))
                    str = Strings_Next(String_replace(str) != NULL);

                Stdout_Flush();
            }
            else
            {   String *str = Strings_Reset(fname, FALSE);
                while(str)
                {   if(!String_replace(str))
                        str = Strings_Next(FALSE);
                    else
                    {   Buffers_Replace(String_off(str), String_len(str),
                                        String_replace(str),
                                        String_rep_len(str));
                        str = Strings_Next(TRUE);
                    }
                }
            }
            if(quit == QUIT_KEEP_SCREEN)
                Restore_screen = FALSE;
        }
     /* If quit is EXIT_PROG, do not write modified file, let MiniTrue_Kill
      *   handle file cleanup */
        if(quit != EXIT_PROG)
        {   Buffers_Close();
            Files_close(files);
        }
    }
    kill_str_vect(argv_copy, argc);
    return Strings_Found() ? 0 : 1;
}

static char far Copyright_text[] =
"Copyright (C) 1995-99 Andrew Pipkin  minitrue@pagesz.net\n\
MiniTrue is free software released with no warranty. See COPYING for details.\n\
\n\
Usage: " EXE_NAME " [-options] [files] - [strings]\n\
\n\
-a  search All files                 -b  make Backup files\n\
-c  Case insensitivity               -d  preserve original Datestamps\n\
-e  ignore file Errors               -f  Fold lines at word breaks\n\
-h  begin in Hex mode                -i:FILE read strings from FILE\n\
-k  Keep statistics                  -l  generate Log file\n\
-mNUM set top Margin                 -n  No prompting\n\
-o  use standard Output (grep mode)  -p:SET define set of printing chars\n\
-q  Quiet mode                       -r  Recurse through subdirectories\n\
-s  accelerated Scrolling            -tTABSIZE set Tab size\n\
-u  set region for boolean searches  -v  set Video mode\n\
-w  Whole words only                 -x  use regular eXpressions\n\
-y  skip binarY files                -z  unZip files before searching\n\
-@:FILE read filenames from FILE\n\n";

static char far Help_info[] =
"\nEnter "  EXE_NAME " -? to view the help file, " EXE_NAME " -?:<option> for \
option information\n";

#ifndef __MSDOS__
#include <sys/utsname.h>
#endif
static void print_copyright(void)
{
    char *mt_env = getenv("MINITRUE");
#ifdef __DJGPP__
    char *platform_name = "32-bit DOS";
#elif defined(__MSDOS__)
    char *platform_name = "16-bit DOS";
#else
    struct utsname uts_buf;
    char *platform_name;
    uname(&uts_buf);
    platform_name = uts_buf.sysname;
#endif
    printf("MiniTrue 2.0.2 (Alpha #3) for %s  " __DATE__ "\n", platform_name);
    printf("%"FP_FORM, Copyright_text);

    printf("Default options: " DEFAULT_FLAGS);
    if(mt_env)
        printf("%s\n", mt_env);
    else
        putchar('\n');
    printf("%"FP_FORM, Help_info);
}

#ifdef FOOO
#ifndef __MSDOS__
#include <malloc.h>
static int mem_diff(void)
{
    static int Prev_alloc;
    struct mallinfo mi = mallinfo();
    int diff = mi.uordblks - Prev_alloc;
    Prev_alloc = mi.uordblks;
    return diff;
}
static int mem_leak(void)
{
    struct mallinfo mi = mallinfo();
    return(mi.hblkhd != 0 || mi.uordblks != 0);
}
#else
static int mem_leak(void) { return FALSE; }
#endif
#endif

void MiniTrue_Rewrite(void)
{
    Lines_Rewrite();
    StatLine_Write();
    if(!StatLine_Cursor())
        Console_Move_cursor(0, Lines_Cursor_row());
}

void MiniTrue_Kill(void)
{
    if(!Console_Restore(Restore_screen))
        Lines_Write();
    Hilites_Kill();
    Lines_Kill();
    Console_Kill();
    Strings_Kill();
    Files_Kill();
    Buffers_Kill();
    Flags_Kill();
}
