/* This file contains the auxiliary programs used to generate tables */
#include <stdio.h>
#include <ctype.h>
#include <limits.h>
#ifdef MAKE_CASE_TABLES
int main(void)
{
    int ch_i;
    printf("#include \"minitrue.h\"\n");
    printf("unsigned char Lower_table[NCHAR]= {");
    for(ch_i = 0; ch_i <= UCHAR_MAX; ++ch_i)
    {   if(!(ch_i % 16))
            putchar('\n');
        printf("%d, ", ch_i);
    }
    printf("};\nunsigned char Upper_table[NCHAR] = {");
    for(ch_i = 0; ch_i <= UCHAR_MAX; ++ch_i)
    {   if(!(ch_i % 16))
            putchar('\n');
        printf("%d, ", ch_i);
    }
    printf("};\n");
    return 0;
}

#elif defined MAKE_CHAR_CLASSES
/* Generate a boolean array with each bit corresponding to a character
 *  class */

# include "charset.h"
int main(void)
{
    int ch_i;
    printf("#include \"minitrue.h\"\n");
    printf("unsigned char CharSet_Classes[NCHAR] = {");
    for(ch_i = 0; ch_i < 0x100; ++ch_i)
    {   uchar byte = 0;
        if(!(ch_i % 12))
            putchar('\n');
        if(isalnum(ch_i) || ch_i == '_')    byte |= WORD_BIT;
        if(isalpha(ch_i))                   byte |= ALPHA_BIT;
        if(islower(ch_i))                   byte |= LOWER_BIT;
        if(isupper(ch_i))                   byte |= UPPER_BIT;
        if(isdigit(ch_i))                   byte |= DIGIT_BIT;
        if(isspace(ch_i))                   byte |= SPACE_BIT;
        if(ispunct(ch_i))                   byte |= PUNCT_BIT;
        printf("0x%02x, ", byte);
    }
    printf("};\n");
    return 0;
}
#elif defined MAKE_ANSI_ESC /* end MAKE_CHAR_CLASSES */
/* Generate array mapping the attribute bytes in the PC video memory
 * to their corresponding of ANSI escape sequences */

int main(void)
{
    int ansi_color[] = { 0, 4, 2, 6, 1, 5, 3, 7};
    int bold_i, back_i, fore_i, attr_num = 0;
    printf("static char far Ansi_esc[128][12] = {\n");

    for(back_i = 0; back_i <= 7; ++back_i)
    {   for(bold_i = 0; bold_i <= 1; ++bold_i)
        {   for(fore_i = 0; fore_i <= 7; ++fore_i)
            {   printf("\"\\033[%i;%i;%im\",  ", bold_i,
                       30 + ansi_color[fore_i], 40 + ansi_color[back_i]);
                if(!(++attr_num % 4))
                    putchar('\n');
            }
        }
    }
    printf(" };\n");
    return 0;
}
#endif /* MAKE_ANSI_ESC */
